/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.filetransfer.httpclient.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.ProxyClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.core.util.ProxyAddress;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient.Activator;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient.ISSLSocketFactoryModifier;

public class SSLSocketFactoryModifier
implements ISSLSocketFactoryModifier,
ProtocolSocketFactory {
    private Proxy proxy;

    public void dispose() {
        this.proxy = null;
        Protocol.unregisterProtocol((String)"https");
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SSLSocketFactory factory = Activator.getDefault().getSSLSocketFactory();
        if (factory == null) {
            throw new IOException("Cannot get socket factory");
        }
        return factory.createSocket(host, port);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        SSLSocketFactory factory = Activator.getDefault().getSSLSocketFactory();
        if (factory == null) {
            throw new IOException("Cannot get socket factory");
        }
        return factory.createSocket(host, port, localAddress, localPort);
    }

    public Socket createSocket(String remoteHost, int remotePort, InetAddress clientHost, int clientPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        SSLSocketFactory factory = Activator.getDefault().getSSLSocketFactory();
        if (factory == null) {
            throw new IOException("Cannot get socket factory");
        }
        if (params == null || params.getConnectionTimeout() == 0) {
            return factory.createSocket(remoteHost, remotePort, clientHost, clientPort);
        }
        if (this.proxy != null && !Proxy.NO_PROXY.equals((Object)this.proxy)) {
            ProxyClient.ConnectResponse response;
            ProxyClient proxyClient = new ProxyClient();
            ProxyAddress address = this.proxy.getAddress();
            proxyClient.getHostConfiguration().setProxy(address.getHostName(), address.getPort());
            proxyClient.getHostConfiguration().setHost(remoteHost, remotePort);
            String proxyUsername = this.proxy.getUsername();
            String proxyPassword = this.proxy.getPassword();
            if (proxyUsername != null && !proxyUsername.equals("")) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                AuthScope proxyAuthScope = new AuthScope(address.getHostName(), address.getPort(), AuthScope.ANY_REALM);
                proxyClient.getState().setProxyCredentials(proxyAuthScope, (Credentials)credentials);
            }
            if ((response = proxyClient.connect()).getSocket() != null) {
                Socket sslsocket = factory.createSocket(response.getSocket(), remoteHost, remotePort, true);
                return sslsocket;
            }
        }
        Socket socket = factory.createSocket(remoteHost, remotePort, clientHost, clientPort);
        return socket;
    }

    public ProtocolSocketFactory getProtocolSocketFactoryForProxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }
}

