/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.remoteservice.generic;

import java.io.IOException;
import java.io.Serializable;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.events.IContainerConnectedEvent;
import org.eclipse.ecf.core.events.IContainerDisconnectedEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.sharedobject.BaseSharedObject;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContext;
import org.eclipse.ecf.core.sharedobject.SharedObjectInitException;
import org.eclipse.ecf.core.sharedobject.SharedObjectMsg;
import org.eclipse.ecf.core.sharedobject.events.ISharedObjectActivatedEvent;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.core.util.Event;
import org.eclipse.ecf.core.util.IEventProcessor;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.provider.remoteservice.Activator;
import org.eclipse.ecf.internal.provider.remoteservice.Messages;
import org.eclipse.ecf.provider.remoteservice.generic.AddRegistrationRequest;
import org.eclipse.ecf.provider.remoteservice.generic.RemoteCallImpl;
import org.eclipse.ecf.provider.remoteservice.generic.RemoteFilterImpl;
import org.eclipse.ecf.provider.remoteservice.generic.RemoteServiceImpl;
import org.eclipse.ecf.provider.remoteservice.generic.RemoteServiceReferenceImpl;
import org.eclipse.ecf.provider.remoteservice.generic.RemoteServiceRegistrationImpl;
import org.eclipse.ecf.provider.remoteservice.generic.RemoteServiceRegistryImpl;
import org.eclipse.ecf.provider.remoteservice.generic.Request;
import org.eclipse.ecf.provider.remoteservice.generic.Response;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.IRemoteCallListener;
import org.eclipse.ecf.remoteservice.IRemoteFilter;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.IRemoteServiceListener;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.IRemoteServiceRegistration;
import org.eclipse.ecf.remoteservice.events.IRemoteCallCompleteEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteCallEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteCallStartEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceRegisteredEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceUnregisteredEvent;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;

public class RegistrySharedObject
extends BaseSharedObject
implements IRemoteServiceContainerAdapter {
    protected RemoteServiceRegistryImpl localRegistry;
    protected final Map remoteRegistrys = Collections.synchronizedMap(new HashMap());
    protected final List serviceListeners = new ArrayList();
    protected final Map localServiceRegistrations = new HashMap();
    protected Map addRegistrationRequests = new Hashtable();
    protected List requests = Collections.synchronizedList(new ArrayList());
    private static final String FIRE_REQUEST = "handleFireRequest";
    private static final String FIRE_REQUEST_ERROR_MESSAGE = Messages.RegistrySharedObject_EXCEPTION_SENDING_FIRE_REQUEST;
    private static final int FIRE_REQUEST_ERROR_CODE = 202;
    private static final String CALL_REQUEST = "handleCallRequest";
    private static final String CALL_REQUEST_ERROR_MESSAGE = Messages.RegistrySharedObject_EXCEPTION_SENDING_CALL_REQUEST;
    private static final int CALL_REQUEST_ERROR_CODE = 203;
    private static final String CALL_REQUEST_TIMEOUT_ERROR_MESSAGE = Messages.RegistrySharedObject_EXCEPTION_TIMEOUT_FOR_CALL_REQUEST;
    private static final int CALL_REQUEST_TIMEOUT_ERROR_CODE = 204;
    private static final String UNREGISTER = "handleUnregister";
    private static final String UNREGISTER_ERROR_MESSAGE = Messages.RegistrySharedObject_EXCEPTION_SENDING_SERVICE_UNREGISTER;
    private static final int UNREGISTER_ERROR_CODE = 206;
    private static final String MSG_INVOKE_ERROR_MESSAGE = Messages.RegistrySharedObject_EXCEPTION_SHARED_OBJECT_INVOKE;
    private static final int MSG_INVOKE_ERROR_CODE = 207;
    private static final String SERVICE_INVOKE_ERROR_MESSAGE = Messages.RegistrySharedObject_EXCEPTION_INVOKING_SERVICE;
    private static final int SERVICE_INVOKE_ERROR_CODE = 208;
    private static final String HANDLE_REQUEST_ERROR_MESSAGE = Messages.RegistrySharedObject_EXCEPTION_LOCALLY_INVOKING_REMOTE_CALL;
    private static final int HANDLE_REQUEST_ERROR_CODE = 209;
    private static final String CALL_RESPONSE = "handleCallResponse";
    private static final String CALL_RESPONSE_ERROR_MESSAGE = Messages.RegistrySharedObject_EXCEPTION_SENDING_RESPONSE;
    private static final int CALL_RESPONSE_ERROR_CODE = 210;
    private static final String REQUEST_NOT_FOUND_ERROR_MESSAGE = Messages.RegistrySharedObject_EXCEPTION_REQUEST_NOT_FOUND;
    private static final int REQUEST_NOT_FOUND_ERROR_CODE = 211;
    private static final long RESPONSE_WAIT_INTERVAL = 5000L;
    private static final String ADD_REGISTRATION = "handleAddRegistration";
    private static final String ADD_REGISTRATION_ERROR_MESSAGE = Messages.RegistrySharedObject_EXCEPTION_SENDING_ADD_SERVICE;
    private static final int ADD_REGISTRATION_ERROR_CODE = 212;
    private static final String ADD_REGISTRATION_REFUSED = "handleAddRegistrationRefused";
    private static final String ADD_REGISTRATION_REFUSED_ERROR_MESSAGE = "Error sending addRegistration refused";
    private static final int ADD_REGISTRATION_REFUSED_ERROR_CODE = 214;
    private static final String REQUEST_SERVICE = "handleRequestService";
    private static final int REQUEST_SERVICE_ERROR_CODE = 213;
    private static final String REQUEST_SERVICE_ERROR_MESSAGE = "Error sending requestServiceReference";
    private static final String REGISTRY_UPDATE_REQUEST = "handleRegistryUpdateRequest";
    private static final int ADD_REGISTRATION_REQUEST_TIMEOUT = 10000;

    public void dispose(ID containerID) {
        super.dispose(containerID);
        this.unregisterAllServiceRegistrations();
        this.remoteRegistrys.clear();
        this.serviceListeners.clear();
        this.localServiceRegistrations.clear();
        this.addRegistrationRequests.clear();
        this.requests.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteServiceListener(IRemoteServiceListener listener) {
        List list = this.serviceListeners;
        synchronized (list) {
            this.serviceListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemoteServiceListener(IRemoteServiceListener listener) {
        List list = this.serviceListeners;
        synchronized (list) {
            this.serviceListeners.remove(listener);
        }
    }

    public IRemoteService getRemoteService(IRemoteServiceReference reference) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"getRemoteService", (Object)reference);
        RemoteServiceRegistrationImpl registration = this.getRemoteServiceRegistrationImpl(reference);
        if (registration == null) {
            return null;
        }
        RemoteServiceImpl remoteService = new RemoteServiceImpl(this, registration);
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"getRemoteService", (Object)remoteService);
        return remoteService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteServiceReference[] getRemoteServiceReferences(ID[] idFilter, String clazz, String filter) throws InvalidSyntaxException {
        RemoteServiceRegistryImpl registry;
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"getRemoteServiceReferences", (Object[])new Object[]{idFilter, clazz, filter});
        if (clazz == null) {
            return null;
        }
        RemoteFilterImpl remoteFilter = filter == null ? null : new RemoteFilterImpl(filter);
        ArrayList references = new ArrayList();
        Object object = this.remoteRegistrys;
        synchronized (object) {
            if (idFilter == null) {
                ArrayList registrys = new ArrayList(this.remoteRegistrys.values());
                Iterator i = registrys.iterator();
                while (i.hasNext()) {
                    registry = (RemoteServiceRegistryImpl)i.next();
                    this.addReferencesFromRegistry(clazz, remoteFilter, registry, references);
                }
            } else {
                int i = 0;
                while (i < idFilter.length) {
                    RemoteServiceRegistryImpl registry2 = (RemoteServiceRegistryImpl)this.remoteRegistrys.get(idFilter[i]);
                    if (registry2 != null) {
                        this.addReferencesFromRegistry(clazz, remoteFilter, registry2, references);
                    }
                    ++i;
                }
            }
        }
        object = this.localRegistry;
        synchronized (object) {
            this.addReferencesFromRegistry(clazz, remoteFilter, this.localRegistry, references);
        }
        if (references.size() == 0) {
            if (idFilter == null) {
                return null;
            }
            AddRegistrationRequest first = null;
            ArrayList<AddRegistrationRequest> ourAddRegistrationRequests = new ArrayList<AddRegistrationRequest>();
            int i = 0;
            while (i < idFilter.length) {
                ID target = idFilter[i];
                if (target != null) {
                    AddRegistrationRequest request = new AddRegistrationRequest(clazz, filter, first);
                    if (i == 0) {
                        first = request;
                    }
                    ourAddRegistrationRequests.add(request);
                    this.addRegistrationRequests.put(request.getId(), request);
                    this.sendAddRegistrationRequest(target, request, this.getAddRegistrationRequestCredentials(request));
                }
                ++i;
            }
            if (first != null) {
                first.waitForResponse(10000L);
                if (first.isDone()) {
                    i = 0;
                    while (i < idFilter.length) {
                        registry = (RemoteServiceRegistryImpl)this.remoteRegistrys.get(idFilter[i]);
                        if (registry != null) {
                            this.addReferencesFromRegistry(clazz, remoteFilter, registry, references);
                        }
                        ++i;
                    }
                }
                Iterator i2 = ourAddRegistrationRequests.iterator();
                while (i2.hasNext()) {
                    AddRegistrationRequest request = (AddRegistrationRequest)i2.next();
                    this.addRegistrationRequests.remove(request.getId());
                }
            }
        }
        IRemoteServiceReference[] result = references.toArray(new IRemoteServiceReference[references.size()]);
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"getRemoteServiceReferences", (Object)result);
        return result.length == 0 ? null : result;
    }

    protected Serializable getAddRegistrationRequestCredentials(AddRegistrationRequest request) {
        return null;
    }

    protected ID[] getTargetsFromProperties(Dictionary properties) {
        return null;
    }

    public IRemoteServiceRegistration registerRemoteService(String[] clazzes, Object service, Dictionary properties) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"registerRemoteService", (Object[])new Object[]{clazzes, service, properties});
        if (service == null) {
            throw new NullPointerException(Messages.RegistrySharedObject_EXCEPTION_SERVICE_CANNOT_BE_NULL);
        }
        int size = clazzes.length;
        if (size == 0) {
            throw new IllegalArgumentException(Messages.RegistrySharedObject_EXCEPTION_SERVICE_CLASSES_LIST_EMPTY);
        }
        String[] copy = new String[clazzes.length];
        int i = 0;
        while (i < clazzes.length) {
            copy[i] = new String(clazzes[i].getBytes());
            ++i;
        }
        clazzes = copy;
        String invalidService = RegistrySharedObject.checkServiceClass(clazzes, service);
        if (invalidService != null) {
            throw new IllegalArgumentException(String.valueOf(Messages.RegistrySharedObject_7) + invalidService);
        }
        RemoteServiceRegistrationImpl reg = new RemoteServiceRegistrationImpl();
        reg.publish(this, this.localRegistry, service, clazzes, properties);
        ID[] targets = this.getTargetsFromProperties(properties);
        if (targets == null) {
            this.sendAddRegistration(null, reg);
        } else {
            int i2 = 0;
            while (i2 < targets.length) {
                this.sendAddRegistration(targets[i2], reg);
                ++i2;
            }
        }
        this.fireRemoteServiceListeners((IRemoteServiceEvent)this.createRegisteredEvent(reg));
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"registerRemoteService", (Object)reg);
        return reg;
    }

    public boolean ungetRemoteService(IRemoteServiceReference ref) {
        return true;
    }

    protected ISharedObjectContext getSOContext() {
        return super.getContext();
    }

    public void initialize() throws SharedObjectInitException {
        super.initialize();
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"initialize");
        super.addEventProcessor(new IEventProcessor(){

            public boolean processEvent(Event arg0) {
                if (arg0 instanceof IContainerConnectedEvent) {
                    RegistrySharedObject.this.handleContainerConnectedEvent((IContainerConnectedEvent)arg0);
                } else if (arg0 instanceof IContainerDisconnectedEvent) {
                    RegistrySharedObject.this.handleContainerDisconnectedEvent((IContainerDisconnectedEvent)arg0);
                } else if (arg0 instanceof ISharedObjectActivatedEvent && RegistrySharedObject.this.getSOContext().getConnectedID() != null) {
                    RegistrySharedObject.this.sendRegistryUpdateRequest();
                }
                return false;
            }
        });
        this.localRegistry = new RemoteServiceRegistryImpl(this.getLocalContainerID());
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"initialize");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleContainerDisconnectedEvent(IContainerDisconnectedEvent event) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"handleContainerDisconnectedEvent", (Object)event);
        ID targetID = event.getTargetID();
        Map map = this.remoteRegistrys;
        synchronized (map) {
            RemoteServiceRegistryImpl registry = this.getRemoteRegistry(targetID);
            if (registry != null) {
                this.removeRemoteRegistry(targetID);
                RemoteServiceRegistrationImpl[] registrations = registry.getRegistrations();
                if (registrations != null) {
                    int i = 0;
                    while (i < registrations.length) {
                        registry.unpublishService(registrations[i]);
                        this.unregisterServiceRegistrationsForContainer(registrations[i].getContainerID());
                        this.fireRemoteServiceListeners((IRemoteServiceEvent)this.createUnregisteredEvent(registrations[i]));
                        ++i;
                    }
                }
            }
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"handleContainerDisconnectedEvent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendRegistryUpdate(ID targetContainerID) {
        RemoteServiceRegistryImpl remoteServiceRegistryImpl = this.localRegistry;
        synchronized (remoteServiceRegistryImpl) {
            RemoteServiceRegistrationImpl[] registrations = this.localRegistry.getRegistrations();
            if (registrations != null) {
                int i = 0;
                while (i < registrations.length) {
                    RemoteServiceRegistrationImpl registration = registrations[i];
                    this.sendAddRegistration(targetContainerID, registration);
                    ++i;
                }
            }
        }
    }

    protected void handleContainerConnectedEvent(IContainerConnectedEvent event) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"handleContainerConnectedEvent", (Object)event);
        ID targetID = event.getTargetID();
        if (this.getContext().isGroupManager() || event.getTargetID().equals((Object)this.getConnectedID())) {
            targetID = null;
        }
        this.sendRegistryUpdate(targetID);
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"handleContainerDisconnectedEvent");
    }

    private Request createRequest(RemoteServiceRegistrationImpl remoteRegistration, IRemoteCall call, IRemoteCallListener listener) {
        RemoteServiceReferenceImpl refImpl = (RemoteServiceReferenceImpl)remoteRegistration.getReference();
        return new Request(this.getLocalContainerID(), remoteRegistration.getServiceId(), RemoteCallImpl.createRemoteCall(refImpl.getRemoteClass(), call.getMethod(), call.getParameters(), call.getTimeout()), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRemoteServiceListeners(IRemoteServiceEvent event) {
        ArrayList entries = null;
        List list = this.serviceListeners;
        synchronized (list) {
            entries = new ArrayList(this.serviceListeners);
        }
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            IRemoteServiceListener l = (IRemoteServiceListener)i.next();
            l.handleServiceEvent(event);
        }
    }

    private RemoteServiceRegistrationImpl getRemoteServiceRegistrationImpl(IRemoteServiceReference reference) {
        if (reference instanceof RemoteServiceReferenceImpl) {
            RemoteServiceReferenceImpl ref = (RemoteServiceReferenceImpl)reference;
            if (!ref.isActive()) {
                return null;
            }
            return ref.getRegistration();
        }
        return null;
    }

    private void addReferencesFromRegistry(String clazz, IRemoteFilter remoteFilter, RemoteServiceRegistryImpl registry, List references) {
        IRemoteServiceReference[] rs = registry.lookupServiceReferences(clazz, remoteFilter);
        if (rs != null) {
            int j = 0;
            while (j < rs.length) {
                references.add(rs[j]);
                ++j;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object callSynch(RemoteServiceRegistrationImpl registration, IRemoteCall call) throws ECFException {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"callSynch", (Object[])new Object[]{registration, call});
        boolean doneWaiting = false;
        Response response = null;
        try {
            Request request = this.sendCallRequest(registration, call);
            long timeout = call.getTimeout() + System.currentTimeMillis();
            while (timeout - System.currentTimeMillis() > 0L && !doneWaiting) {
                Request request2 = request;
                synchronized (request2) {
                    if (request.isDone()) {
                        Trace.trace((String)"org.eclipse.ecf.provider.remoteservice", (String)(String.valueOf(Messages.RegistrySharedObject_15) + request));
                        doneWaiting = true;
                        response = request.getResponse();
                        if (response == null) {
                            throw new ECFException(Messages.RegistrySharedObject_EXCEPTION_INVALID_RESPONSE);
                        }
                    } else {
                        Trace.trace((String)"org.eclipse.ecf.provider.remoteservice", (String)("Waiting 5000 for response to request: " + request));
                        request.wait(5000L);
                    }
                }
            }
            if (!doneWaiting) {
                throw new ECFException(String.valueOf(Messages.RegistrySharedObject_19) + call.getTimeout() + Messages.RegistrySharedObject_20);
            }
        }
        catch (IOException e) {
            this.log(203, CALL_REQUEST_ERROR_MESSAGE, e);
            throw new ECFException(Messages.RegistrySharedObject_EXCEPTION_SENDING_REQUEST, (Throwable)e);
        }
        catch (InterruptedException e) {
            this.log(204, CALL_REQUEST_TIMEOUT_ERROR_MESSAGE, e);
            throw new ECFException(Messages.RegistrySharedObject_EXCEPTION_WAIT_INTERRUPTED, (Throwable)e);
        }
        Object result = null;
        if (response.hadException()) {
            throw new ECFException(Messages.RegistrySharedObject_EXCEPTION_IN_REMOTE_CALL, response.getException());
        }
        result = response.getResponse();
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"callSynch", (Object)result);
        return result;
    }

    protected void fireCallStartEvent(IRemoteCallListener listener, final long requestId, final IRemoteServiceReference reference, final IRemoteCall call) {
        if (listener != null) {
            listener.handleEvent((IRemoteCallEvent)new IRemoteCallStartEvent(){

                public long getRequestId() {
                    return requestId;
                }

                public IRemoteCall getCall() {
                    return call;
                }

                public IRemoteServiceReference getReference() {
                    return reference;
                }

                public String toString() {
                    StringBuffer buf = new StringBuffer("IRemoteCallStartEvent[");
                    buf.append(";reference=").append(reference).append(";call=").append(call).append("]");
                    return buf.toString();
                }
            });
        }
    }

    protected void fireCallCompleteEvent(IRemoteCallListener listener, final long requestId, final Object response, final boolean hadException, final Throwable exception) {
        if (listener != null) {
            listener.handleEvent((IRemoteCallEvent)new IRemoteCallCompleteEvent(){

                public long getRequestId() {
                    return requestId;
                }

                public Throwable getException() {
                    return exception;
                }

                public Object getResponse() {
                    return response;
                }

                public boolean hadException() {
                    return hadException;
                }

                public String toString() {
                    StringBuffer buf = new StringBuffer("IRemoteCallCompleteEvent[");
                    buf.append(";response=").append(response).append(";hadException=").append(hadException).append(";exception=").append(exception).append("]");
                    return buf.toString();
                }
            });
        }
    }

    static String checkServiceClass(String[] clazzes, final Object serviceObject) {
        ClassLoader cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return serviceObject.getClass().getClassLoader();
            }
        });
        int i = 0;
        while (i < clazzes.length) {
            block4: {
                try {
                    Class<?> serviceClazz;
                    Class<?> clazz = serviceClazz = cl == null ? Class.forName(clazzes[i]) : cl.loadClass(clazzes[i]);
                    if (!serviceClazz.isInstance(serviceObject)) {
                        return clazzes[i];
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!RegistrySharedObject.extensiveCheckServiceClass(clazzes[i], serviceObject.getClass())) break block4;
                    return clazzes[i];
                }
            }
            ++i;
        }
        return null;
    }

    private static boolean extensiveCheckServiceClass(String clazz, Class serviceClazz) {
        if (clazz.equals(serviceClazz.getName())) {
            return false;
        }
        Class<?>[] interfaces = serviceClazz.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (!RegistrySharedObject.extensiveCheckServiceClass(clazz, interfaces[i])) {
                return false;
            }
            ++i;
        }
        Class superClazz = serviceClazz.getSuperclass();
        return superClazz == null || RegistrySharedObject.extensiveCheckServiceClass(clazz, superClazz);
    }

    protected void sendRegistryUpdateRequest() {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"sendRegistryUpdateRequest");
        try {
            this.sendSharedObjectMsgTo(null, SharedObjectMsg.createMsg((String)REGISTRY_UPDATE_REQUEST, (Object)this.getLocalContainerID()));
        }
        catch (IOException e) {
            this.log(210, CALL_RESPONSE_ERROR_MESSAGE, e);
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"sendRegistryUpdateRequest");
    }

    protected void handleRegistryUpdateRequest(ID remoteContainerID) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)REGISTRY_UPDATE_REQUEST);
        if (remoteContainerID == null || this.getLocalContainerID().equals((Object)remoteContainerID)) {
            return;
        }
        this.sendRegistryUpdate(remoteContainerID);
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)REGISTRY_UPDATE_REQUEST);
    }

    protected AddRegistrationRequest sendAddRegistrationRequest(ID receiver, AddRegistrationRequest request, Serializable credentials) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"sendRequestService", (Object[])new Object[]{receiver, request, credentials});
        Assert.isNotNull((Object)receiver);
        Assert.isNotNull((Object)request);
        try {
            this.sendSharedObjectMsgTo(receiver, SharedObjectMsg.createMsg(null, (String)REQUEST_SERVICE, (Object[])new Object[]{this.getLocalContainerID(), request, request.getId(), credentials}));
        }
        catch (IOException e) {
            this.log(213, REQUEST_SERVICE_ERROR_MESSAGE, e);
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"sendRequestService");
        return request;
    }

    protected void checkRequestServiceAuthorization(ID remoteContainerID, AddRegistrationRequest request, Serializable credentials) throws AccessControlException {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"checkRequestServiceAuthorization", (Object[])new Object[]{remoteContainerID, request, credentials});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequestService(ID remoteContainerID, AddRegistrationRequest request, Integer requestId, Serializable credentials) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"handleRequestServiceReference", (Object[])new Object[]{remoteContainerID, request, requestId, credentials});
        if (remoteContainerID == null || requestId == null) {
            return;
        }
        if (request == null || request.getService() == null) {
            return;
        }
        RemoteFilterImpl rf = null;
        try {
            rf = request.getFilter() == null ? null : new RemoteFilterImpl(request.getFilter());
        }
        catch (InvalidSyntaxException e) {
            this.log("handleRequestService invalid syntax exception for filter", e);
            rf = null;
        }
        try {
            this.checkRequestServiceAuthorization(remoteContainerID, request, credentials);
        }
        catch (AccessControlException e) {
            this.log("handleRequestService. checkRequestServiceAuthorization exception", e);
            this.sendAddRegistrationRequestRefused(remoteContainerID, requestId, e);
            return;
        }
        RemoteServiceRegistryImpl remoteServiceRegistryImpl = this.localRegistry;
        synchronized (remoteServiceRegistryImpl) {
            RemoteServiceReferenceImpl[] srs = (RemoteServiceReferenceImpl[])this.localRegistry.lookupServiceReferences(request.getService(), rf);
            if (srs != null && srs.length > 0) {
                int i = 0;
                while (i < srs.length) {
                    RemoteServiceRegistrationImpl impl = this.getRemoteServiceRegistrationImpl(srs[i]);
                    if (impl != null) {
                        this.sendAddRegistration(remoteContainerID, requestId, impl);
                    }
                    ++i;
                }
            } else {
                this.sendAddRegistrationRequestRefused(remoteContainerID, requestId, null);
            }
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)REQUEST_SERVICE);
    }

    protected void sendAddRegistration(ID receiver, RemoteServiceRegistrationImpl reg) {
        this.sendAddRegistration(receiver, null, reg);
    }

    protected void sendAddRegistration(ID receiver, Integer requestId, RemoteServiceRegistrationImpl reg) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"sendAddRegistration", (Object[])new Object[]{receiver, requestId, reg});
        try {
            this.sendSharedObjectMsgTo(receiver, SharedObjectMsg.createMsg(null, (String)ADD_REGISTRATION, (Object)this.getLocalContainerID(), (Object)requestId, (Object)reg));
        }
        catch (IOException e) {
            this.log(212, ADD_REGISTRATION_ERROR_MESSAGE, e);
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"sendAddRegistration");
    }

    protected void sendAddRegistrationRequestRefused(ID receiver, Integer requestId, Exception except) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"sendAddRegistrationRequestRefused", (Object[])new Object[]{receiver, except});
        try {
            this.sendSharedObjectMsgTo(receiver, SharedObjectMsg.createMsg(null, (String)ADD_REGISTRATION_REFUSED, (Object)this.getLocalContainerID(), (Object)requestId, (Object)except));
        }
        catch (IOException e) {
            this.log(214, ADD_REGISTRATION_REFUSED_ERROR_MESSAGE, e);
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"sendAddRegistrationRequestRefused");
    }

    protected void handleAddRegistrationRequestRefused(ID remoteContainerID, Integer requestId, AccessControlException e) {
        if (remoteContainerID == null || requestId == null) {
            return;
        }
        this.notifyAddRegistrationResponse(requestId, e);
    }

    protected void handleAddRegistration(ID remoteContainerID, RemoteServiceRegistrationImpl registration) {
        this.handleAddRegistration(remoteContainerID, null, registration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAddRegistration(ID remoteContainerID, Integer requestId, RemoteServiceRegistrationImpl registration) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)ADD_REGISTRATION, (Object[])new Object[]{remoteContainerID, registration});
        if (remoteContainerID == null || this.getLocalContainerID().equals((Object)remoteContainerID)) {
            return;
        }
        Map map = this.remoteRegistrys;
        synchronized (map) {
            RemoteServiceRegistryImpl registry = this.getRemoteRegistry(remoteContainerID);
            if (registry == null) {
                registry = new RemoteServiceRegistryImpl(remoteContainerID);
                this.addRemoteRegistry(registry);
            }
            registry.publishService(registration);
            this.localRegisterService(registration);
            this.notifyAddRegistrationResponse(requestId, null);
        }
        this.fireRemoteServiceListeners((IRemoteServiceEvent)this.createRegisteredEvent(registration));
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)ADD_REGISTRATION);
    }

    private void notifyAddRegistrationResponse(Integer requestId, AccessControlException exception) {
        if (requestId == null) {
            return;
        }
        AddRegistrationRequest request = (AddRegistrationRequest)this.addRegistrationRequests.remove(requestId);
        if (request != null) {
            request.notifyResponse(exception);
        }
    }

    private void localRegisterService(RemoteServiceRegistrationImpl registration) {
        Object localServiceRegistrationValue = registration.getProperty("org.eclipse.ecf.serviceRegistrationRemote");
        if (localServiceRegistrationValue != null) {
            Object service;
            BundleContext context = Activator.getDefault().getContext();
            if (context == null) {
                return;
            }
            RemoteServiceImpl remoteServiceImpl = new RemoteServiceImpl(this, registration);
            try {
                service = remoteServiceImpl.getProxy();
            }
            catch (ECFException e) {
                e.printStackTrace();
                this.log("localRegisterService", e);
                return;
            }
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            String[] keys = registration.getPropertyKeys();
            int i = 0;
            while (i < keys.length) {
                Object value = registration.getProperty(keys[i]);
                if (value != null) {
                    properties.put(keys[i], value);
                }
                ++i;
            }
            ID remoteContainerID = registration.getContainerID();
            properties.put("org.eclipse.ecf.containerID", remoteContainerID.getName());
            ServiceRegistration serviceRegistration = context.registerService(registration.getClasses(), service, properties);
            this.addLocalServiceRegistration(remoteContainerID, serviceRegistration);
        }
    }

    private void addLocalServiceRegistration(ID remoteContainerID, ServiceRegistration registration) {
        ArrayList<ServiceRegistration> containerRegistrations = (ArrayList<ServiceRegistration>)this.localServiceRegistrations.get(remoteContainerID);
        if (containerRegistrations == null) {
            containerRegistrations = new ArrayList<ServiceRegistration>();
            this.localServiceRegistrations.put(remoteContainerID, containerRegistrations);
        }
        containerRegistrations.add(registration);
    }

    protected Request sendCallRequest(RemoteServiceRegistrationImpl remoteRegistration, IRemoteCall call) throws IOException {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"sendCallRequest", (Object[])new Object[]{remoteRegistration, call});
        Request request = this.createRequest(remoteRegistration, call, null);
        this.addRequest(request);
        try {
            this.sendSharedObjectMsgTo(remoteRegistration.getContainerID(), SharedObjectMsg.createMsg((String)CALL_REQUEST, (Object)request));
        }
        catch (IOException e) {
            this.removeRequest(request);
            throw e;
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"sendCallRequest", (Object)request);
        return request;
    }

    protected void handleCallRequest(Request request) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)CALL_REQUEST, (Object)request);
        ID responseTarget = request.getRequestContainerID();
        RemoteServiceRegistrationImpl localRegistration = this.getLocalRegistrationForRequest(request);
        RemoteCallImpl call = request.getCall();
        Response response = null;
        Object result = null;
        try {
            result = localRegistration.callService(call);
            response = new Response(request.getRequestId(), result);
        }
        catch (Exception e) {
            response = new Response(request.getRequestId(), e);
            this.log(208, SERVICE_INVOKE_ERROR_MESSAGE, e);
        }
        this.sendCallResponse(responseTarget, response);
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)CALL_REQUEST);
    }

    protected void sendCallRequestWithListener(RemoteServiceRegistrationImpl remoteRegistration, IRemoteCall call, IRemoteCallListener listener) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"sendCallRequestWithListener", (Object[])new Object[]{remoteRegistration, call, listener});
        Request request = this.createRequest(remoteRegistration, call, listener);
        this.fireCallStartEvent(listener, request.getRequestId(), remoteRegistration.getReference(), call);
        try {
            this.addRequest(request);
            this.sendSharedObjectMsgTo(remoteRegistration.getContainerID(), SharedObjectMsg.createMsg((String)CALL_REQUEST, (Object)request));
        }
        catch (IOException e) {
            this.log(203, CALL_REQUEST_ERROR_MESSAGE, e);
            this.removeRequest(request);
            this.fireCallCompleteEvent(listener, request.getRequestId(), null, true, e);
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"sendCallRequestWithListener");
    }

    protected void sendCallResponse(ID responseTarget, Response response) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"sendCallResponse", (Object[])new Object[]{responseTarget, response});
        try {
            this.sendSharedObjectMsgTo(responseTarget, SharedObjectMsg.createMsg((String)CALL_RESPONSE, (Object)response));
        }
        catch (IOException e) {
            this.log(210, CALL_RESPONSE_ERROR_MESSAGE, e);
            e.printStackTrace(System.err);
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"sendCallResponse");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCallResponse(Response response) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)CALL_RESPONSE, (Object[])new Object[]{response});
        Request request = this.getRequest(response.getRequestId());
        if (request == null) {
            this.log(211, REQUEST_NOT_FOUND_ERROR_MESSAGE, new NullPointerException());
            return;
        }
        this.removeRequest(request);
        IRemoteCallListener listener = request.getListener();
        if (listener != null) {
            this.fireCallCompleteEvent(listener, request.getRequestId(), response.getResponse(), response.hadException(), response.getException());
            return;
        }
        Request request2 = request;
        synchronized (request2) {
            request.setResponse(response);
            request.setDone(true);
            request.notify();
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)CALL_RESPONSE);
    }

    protected Request sendFireRequest(RemoteServiceRegistrationImpl remoteRegistration, IRemoteCall call) throws ECFException {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"sendFireRequest", (Object[])new Object[]{remoteRegistration, call});
        Request request = this.createRequest(remoteRegistration, call, null);
        try {
            this.sendSharedObjectMsgTo(remoteRegistration.getContainerID(), SharedObjectMsg.createMsg((String)FIRE_REQUEST, (Object)request));
        }
        catch (IOException e) {
            this.log(202, FIRE_REQUEST_ERROR_MESSAGE, e);
            throw new ECFException(Messages.RegistrySharedObject_EXCEPTION_SENDING_REMOTE_REQUEST, (Throwable)e);
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"sendFireRequest", (Object)request);
        return request;
    }

    protected void handleFireRequest(Request request) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)FIRE_REQUEST, (Object[])new Object[]{request});
        RemoteServiceRegistrationImpl localRegistration = this.getLocalRegistrationForRequest(request);
        RemoteCallImpl call = request.getCall();
        try {
            localRegistration.callService(call);
        }
        catch (Exception e) {
            this.log(209, HANDLE_REQUEST_ERROR_MESSAGE, e);
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)FIRE_REQUEST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendUnregister(RemoteServiceRegistrationImpl serviceRegistration) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"sendUnregister", (Object[])new Object[]{serviceRegistration});
        RemoteServiceRegistryImpl remoteServiceRegistryImpl = this.localRegistry;
        synchronized (remoteServiceRegistryImpl) {
            this.localRegistry.unpublishService(serviceRegistration);
            ID containerID = serviceRegistration.getContainerID();
            Long serviceId = new Long(serviceRegistration.getServiceId());
            try {
                this.sendSharedObjectMsgTo(null, SharedObjectMsg.createMsg((String)UNREGISTER, (Object[])new Object[]{containerID, serviceId}));
            }
            catch (IOException e) {
                this.log(206, UNREGISTER_ERROR_MESSAGE, e);
            }
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"sendUnregister");
    }

    private void unregisterServiceRegistrationsForContainer(ID containerID) {
        if (containerID == null) {
            return;
        }
        List containerRegistrations = (List)this.localServiceRegistrations.remove(containerID);
        if (containerRegistrations != null) {
            Iterator i = containerRegistrations.iterator();
            while (i.hasNext()) {
                ServiceRegistration serviceRegistration = (ServiceRegistration)i.next();
                try {
                    serviceRegistration.unregister();
                }
                catch (Exception e) {
                    this.log("unregister", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterAllServiceRegistrations() {
        Map map = this.remoteRegistrys;
        synchronized (map) {
            Iterator i = this.localServiceRegistrations.keySet().iterator();
            while (i.hasNext()) {
                this.unregisterServiceRegistrationsForContainer((ID)i.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleUnregister(ID containerID, Long serviceId) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)UNREGISTER, (Object[])new Object[]{containerID, serviceId});
        Map map = this.remoteRegistrys;
        synchronized (map) {
            RemoteServiceRegistrationImpl registration;
            RemoteServiceRegistryImpl serviceRegistry = (RemoteServiceRegistryImpl)this.remoteRegistrys.get(containerID);
            if (serviceRegistry != null && (registration = serviceRegistry.findRegistrationForServiceId(serviceId)) != null) {
                serviceRegistry.unpublishService(registration);
                this.unregisterServiceRegistrationsForContainer(registration.getContainerID());
                this.fireRemoteServiceListeners((IRemoteServiceEvent)this.createUnregisteredEvent(registration));
            }
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)UNREGISTER);
    }

    protected IRemoteServiceUnregisteredEvent createUnregisteredEvent(final RemoteServiceRegistrationImpl registration) {
        return new IRemoteServiceUnregisteredEvent(){

            public String[] getClazzes() {
                return registration.getClasses();
            }

            public ID getContainerID() {
                return registration.getContainerID();
            }

            public IRemoteServiceReference getReference() {
                return registration.getReference();
            }

            public String toString() {
                StringBuffer buf = new StringBuffer("RemoteServiceUnregisteredEvent[");
                buf.append("containerID=").append(registration.getContainerID());
                buf.append(";clazzes=").append(Arrays.asList(registration.getClasses()));
                buf.append(";reference=").append(registration.getReference()).append("]");
                return buf.toString();
            }
        };
    }

    protected IRemoteServiceRegisteredEvent createRegisteredEvent(final RemoteServiceRegistrationImpl registration) {
        return new IRemoteServiceRegisteredEvent(){

            public String[] getClazzes() {
                return registration.getClasses();
            }

            public ID getContainerID() {
                return registration.getContainerID();
            }

            public IRemoteServiceReference getReference() {
                return registration.getReference();
            }

            public String toString() {
                StringBuffer buf = new StringBuffer("RemoteServiceRegisteredEvent[");
                buf.append("containerID=").append(registration.getContainerID());
                buf.append(";clazzes=").append(Arrays.asList(registration.getClasses()));
                buf.append(";reference=").append(registration.getReference()).append("]");
                return buf.toString();
            }
        };
    }

    protected RemoteServiceRegistryImpl addRemoteRegistry(RemoteServiceRegistryImpl registry) {
        return this.remoteRegistrys.put(registry.getContainerID(), registry);
    }

    protected RemoteServiceRegistryImpl getRemoteRegistry(ID containerID) {
        return (RemoteServiceRegistryImpl)this.remoteRegistrys.get(containerID);
    }

    protected RemoteServiceRegistryImpl removeRemoteRegistry(ID containerID) {
        return (RemoteServiceRegistryImpl)this.remoteRegistrys.remove(containerID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteServiceRegistrationImpl getLocalRegistrationForRequest(Request request) {
        RemoteServiceRegistryImpl remoteServiceRegistryImpl = this.localRegistry;
        synchronized (remoteServiceRegistryImpl) {
            return this.localRegistry.findRegistrationForServiceId(request.getServiceId());
        }
    }

    private boolean addRequest(Request request) {
        return this.requests.add(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Request getRequest(long requestId) {
        List list = this.requests;
        synchronized (list) {
            Iterator i = this.requests.iterator();
            while (i.hasNext()) {
                Request req = (Request)i.next();
                long reqId = req.getRequestId();
                if (reqId != requestId) continue;
                return req;
            }
        }
        return null;
    }

    private boolean removeRequest(Request request) {
        return this.requests.remove(request);
    }

    protected void logException(int code, String message, Throwable e) {
        Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider.remoteservice", code, message, e));
    }

    protected boolean handleSharedObjectMsg(SharedObjectMsg msg) {
        try {
            msg.invoke((Object)this);
            return true;
        }
        catch (Exception e) {
            this.logException(207, NLS.bind((String)MSG_INVOKE_ERROR_MESSAGE, (Object)msg), e);
            return false;
        }
    }
}

