/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import org.jivesoftware.smack.AccountManager;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionEstablishedListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.GroupChat;
import org.jivesoftware.smack.NonSASLAuthentication;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.PacketReader;
import org.jivesoftware.smack.PacketWriter;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.ServerTrustManager;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.DNSUtil;
import org.jivesoftware.smack.util.StringUtils;

public class XMPPConnection {
    public static boolean DEBUG_ENABLED = false;
    private static List connectionEstablishedListeners = new ArrayList();
    private SmackDebugger debugger = null;
    String host;
    int port;
    Socket socket;
    String serviceName;
    String connectionID;
    private String user = null;
    private boolean connected = false;
    private boolean authenticated = false;
    private boolean anonymous = false;
    private boolean usingTLS = false;
    PacketWriter packetWriter;
    PacketReader packetReader;
    Roster roster = null;
    private AccountManager accountManager = null;
    private SASLAuthentication saslAuthentication = new SASLAuthentication(this);
    Writer writer;
    Reader reader;
    Map chats = Collections.synchronizedMap(new HashMap());
    private Collection compressionMethods;
    private boolean usingCompression;
    private ConnectionConfiguration configuration;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    static {
        try {
            DEBUG_ENABLED = Boolean.getBoolean("smack.debugEnabled");
        }
        catch (Exception exception) {}
        SmackConfiguration.getVersion();
    }

    public XMPPConnection(String serviceName) throws XMPPException {
        DNSUtil.HostAddress address = DNSUtil.resolveXMPPDomain(serviceName);
        ConnectionConfiguration config = new ConnectionConfiguration(address.getHost(), address.getPort(), serviceName);
        config.setTLSEnabled(true);
        config.setCompressionEnabled(false);
        config.setSASLAuthenticationEnabled(true);
        config.setDebuggerEnabled(DEBUG_ENABLED);
        this.connectUsingConfiguration(config, null);
    }

    public XMPPConnection(String host, int port) throws XMPPException {
        ConnectionConfiguration config = new ConnectionConfiguration(host, port);
        config.setTLSEnabled(true);
        config.setCompressionEnabled(false);
        config.setSASLAuthenticationEnabled(true);
        config.setDebuggerEnabled(DEBUG_ENABLED);
        this.connectUsingConfiguration(config, null);
    }

    public XMPPConnection(String host, int port, String serviceName) throws XMPPException {
        ConnectionConfiguration config = new ConnectionConfiguration(host, port, serviceName);
        config.setTLSEnabled(true);
        config.setCompressionEnabled(false);
        config.setSASLAuthenticationEnabled(true);
        config.setDebuggerEnabled(DEBUG_ENABLED);
        this.connectUsingConfiguration(config, null);
    }

    public XMPPConnection(String host, int port, String serviceName, SocketFactory socketFactory) throws XMPPException {
        ConnectionConfiguration config = new ConnectionConfiguration(host, port, serviceName);
        config.setTLSEnabled(true);
        config.setCompressionEnabled(false);
        config.setSASLAuthenticationEnabled(true);
        config.setDebuggerEnabled(DEBUG_ENABLED);
        this.connectUsingConfiguration(config, socketFactory);
    }

    public XMPPConnection(ConnectionConfiguration config) throws XMPPException {
        this.connectUsingConfiguration(config, null);
    }

    public XMPPConnection(ConnectionConfiguration config, SocketFactory socketFactory) throws XMPPException {
        this.connectUsingConfiguration(config, socketFactory);
    }

    private void connectUsingConfiguration(ConnectionConfiguration config, SocketFactory socketFactory) throws XMPPException {
        this.host = config.getHost();
        this.port = config.getPort();
        try {
            this.socket = socketFactory == null ? new Socket(this.host, this.port) : socketFactory.createSocket(this.host, this.port);
        }
        catch (UnknownHostException uhe) {
            throw new XMPPException("Could not connect to " + this.host + ":" + this.port + ".", new XMPPError(504), uhe);
        }
        catch (IOException ioe) {
            throw new XMPPException("XMPPError connecting to " + this.host + ":" + this.port + ".", new XMPPError(502), ioe);
        }
        this.serviceName = config.getServiceName();
        try {
            this.configuration = (ConnectionConfiguration)config.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        this.init();
    }

    XMPPConnection() {
    }

    public String getConnectionID() {
        return this.connectionID;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        if (!this.isAuthenticated()) {
            return null;
        }
        return this.user;
    }

    public void login(String username, String password) throws XMPPException {
        this.login(username, password, "Smack");
    }

    public synchronized void login(String username, String password, String resource) throws XMPPException {
        this.login(username, password, resource, true);
    }

    public synchronized void login(String username, String password, String resource, boolean sendPresence) throws XMPPException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Already logged in to server.");
        }
        username = username.toLowerCase().trim();
        String response = null;
        response = this.configuration.isSASLAuthenticationEnabled() && this.saslAuthentication.hasNonAnonymousAuthentication() ? this.saslAuthentication.authenticate(username, password, resource) : new NonSASLAuthentication(this).authenticate(username, password, resource);
        if (response != null) {
            this.user = response;
            this.serviceName = StringUtils.parseServer(response);
        } else {
            this.user = String.valueOf(username) + "@" + this.serviceName;
            if (resource != null) {
                this.user = String.valueOf(this.user) + "/" + resource;
            }
        }
        if (this.configuration.isCompressionEnabled()) {
            this.useCompression();
        }
        this.roster = new Roster(this);
        this.roster.reload();
        if (sendPresence) {
            this.packetWriter.sendPacket(new Presence(Presence.Type.AVAILABLE));
        }
        this.authenticated = true;
        this.anonymous = false;
        if (this.configuration.isDebuggerEnabled() && this.debugger != null) {
            this.debugger.userHasLogged(this.user);
        }
    }

    public synchronized void loginAnonymously() throws XMPPException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Already logged in to server.");
        }
        String response = null;
        response = this.configuration.isSASLAuthenticationEnabled() && this.saslAuthentication.hasAnonymousAuthentication() ? this.saslAuthentication.authenticateAnonymously() : new NonSASLAuthentication(this).authenticateAnonymously();
        this.user = response;
        this.serviceName = StringUtils.parseServer(response);
        if (this.configuration.isCompressionEnabled()) {
            this.useCompression();
        }
        this.roster = null;
        this.packetWriter.sendPacket(new Presence(Presence.Type.AVAILABLE));
        this.authenticated = true;
        this.anonymous = true;
        if (this.configuration.isDebuggerEnabled() && this.debugger != null) {
            this.debugger.userHasLogged(this.user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Roster getRoster() {
        if (this.roster == null) {
            return null;
        }
        if (!this.roster.rosterInitialized) {
            try {
                Roster roster = this.roster;
                synchronized (roster) {
                    long waitTime = SmackConfiguration.getPacketReplyTimeout();
                    long start = System.currentTimeMillis();
                    while (!this.roster.rosterInitialized) {
                        if (waitTime <= 0L) break;
                        this.roster.wait(waitTime);
                        long now = System.currentTimeMillis();
                        waitTime -= now - start;
                        start = now;
                    }
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.roster;
    }

    public synchronized AccountManager getAccountManager() {
        if (this.accountManager == null) {
            this.accountManager = new AccountManager(this);
        }
        return this.accountManager;
    }

    public Chat createChat(String participant) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        return new Chat(this, participant);
    }

    public GroupChat createGroupChat(String room) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        return new GroupChat(this, room);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isSecureConnection() {
        return this.isUsingTLS();
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void close() {
        this.packetWriter.sendPacket(new Presence(Presence.Type.UNAVAILABLE));
        this.packetReader.shutdown();
        this.packetWriter.shutdown();
        try {
            Thread.sleep(150L);
        }
        catch (Exception exception) {}
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (Throwable throwable) {}
            this.reader = null;
        }
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (Throwable throwable) {}
            this.writer = null;
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {}
        this.authenticated = false;
        this.connected = false;
    }

    public void sendPacket(Packet packet) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (packet == null) {
            throw new NullPointerException("Packet is null.");
        }
        this.packetWriter.sendPacket(packet);
    }

    public void addPacketListener(PacketListener packetListener, PacketFilter packetFilter) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        this.packetReader.addPacketListener(packetListener, packetFilter);
    }

    public void removePacketListener(PacketListener packetListener) {
        this.packetReader.removePacketListener(packetListener);
    }

    public void addPacketWriterListener(PacketListener packetListener, PacketFilter packetFilter) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        this.packetWriter.addPacketListener(packetListener, packetFilter);
    }

    public void removePacketWriterListener(PacketListener packetListener) {
        this.packetWriter.removePacketListener(packetListener);
    }

    public void addPacketWriterInterceptor(PacketInterceptor packetInterceptor, PacketFilter packetFilter) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        this.packetWriter.addPacketInterceptor(packetInterceptor, packetFilter);
    }

    public void removePacketWriterInterceptor(PacketInterceptor packetInterceptor) {
        this.packetWriter.removePacketInterceptor(packetInterceptor);
    }

    public PacketCollector createPacketCollector(PacketFilter packetFilter) {
        return this.packetReader.createPacketCollector(packetFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(ConnectionListener connectionListener) {
        if (connectionListener == null) {
            return;
        }
        List list = this.packetReader.connectionListeners;
        synchronized (list) {
            if (!this.packetReader.connectionListeners.contains(connectionListener)) {
                this.packetReader.connectionListeners.add(connectionListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(ConnectionListener connectionListener) {
        List list = this.packetReader.connectionListeners;
        synchronized (list) {
            this.packetReader.connectionListeners.remove(connectionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConnectionListener(ConnectionEstablishedListener connectionEstablishedListener) {
        List list = connectionEstablishedListeners;
        synchronized (list) {
            if (!connectionEstablishedListeners.contains(connectionEstablishedListener)) {
                connectionEstablishedListeners.add(connectionEstablishedListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeConnectionListener(ConnectionEstablishedListener connectionEstablishedListener) {
        List list = connectionEstablishedListeners;
        synchronized (list) {
            connectionEstablishedListeners.remove(connectionEstablishedListener);
        }
    }

    private void init() throws XMPPException {
        this.initReaderAndWriter();
        try {
            this.packetWriter = new PacketWriter(this);
            this.packetReader = new PacketReader(this);
            if (this.configuration.isDebuggerEnabled()) {
                this.packetReader.addPacketListener(this.debugger.getReaderListener(), null);
                if (this.debugger.getWriterListener() != null) {
                    this.packetWriter.addPacketListener(this.debugger.getWriterListener(), null);
                }
            }
            this.packetWriter.startup();
            this.packetReader.startup();
            this.connected = true;
            this.packetWriter.startKeepAliveProcess();
            XMPPConnection.connectionEstablished(this);
            PacketListener packetListener = new PacketListener(){

                public void processPacket(Packet packet) {
                    WeakReference chatRef;
                    Message message = (Message)packet;
                    if (message.getThread() == null && message.getType() != Message.Type.GROUP_CHAT && message.getType() != Message.Type.HEADLINE && (chatRef = (WeakReference)XMPPConnection.this.chats.get(StringUtils.parseBareAddress(message.getFrom()))) != null) {
                        Chat chat = (Chat)chatRef.get();
                        if (chat == null) {
                            XMPPConnection.this.chats.remove(message.getFrom());
                        } else {
                            chat.deliver(message);
                        }
                    }
                }
            };
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.jivesoftware.smack.packet.Message");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.addPacketListener(packetListener, new PacketTypeFilter(clazz));
        }
        catch (XMPPException ex) {
            if (this.packetWriter != null) {
                try {
                    this.packetWriter.shutdown();
                }
                catch (Throwable throwable) {}
                this.packetWriter = null;
            }
            if (this.packetReader != null) {
                try {
                    this.packetReader.shutdown();
                }
                catch (Throwable throwable) {}
                this.packetReader = null;
            }
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (Throwable throwable) {}
                this.reader = null;
            }
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (Throwable throwable) {}
                this.writer = null;
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception exception) {}
                this.socket = null;
            }
            this.authenticated = false;
            this.connected = false;
            throw ex;
        }
    }

    private void initReaderAndWriter() throws XMPPException {
        block35: {
            try {
                if (!this.usingCompression) {
                    this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
                    this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8"));
                    break block35;
                }
                try {
                    Class<?> zoClass = Class.forName("com.jcraft.jzlib.ZOutputStream");
                    Class[] classArray = new Class[2];
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("java.io.OutputStream");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz;
                    classArray[1] = Integer.TYPE;
                    Constructor<?> constructor = zoClass.getConstructor(classArray);
                    Object out = constructor.newInstance(this.socket.getOutputStream(), new Integer(9));
                    Method method = zoClass.getMethod("setFlushMode", Integer.TYPE);
                    method.invoke(out, new Integer(1));
                    this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
                    Class<?> ziClass = Class.forName("com.jcraft.jzlib.ZInputStream");
                    Class[] classArray2 = new Class[1];
                    Class<?> clazz2 = class$2;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$2 = Class.forName("java.io.InputStream");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray2[0] = clazz2;
                    constructor = ziClass.getConstructor(classArray2);
                    Object in = constructor.newInstance(this.socket.getInputStream());
                    method = ziClass.getMethod("setFlushMode", Integer.TYPE);
                    method.invoke(in, new Integer(1));
                    this.reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
                    this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8"));
                }
            }
            catch (IOException ioe) {
                throw new XMPPException("XMPPError establishing connection with server.", new XMPPError(502), ioe);
            }
        }
        if (this.configuration.isDebuggerEnabled()) {
            if (this.debugger == null) {
                String className = null;
                try {
                    className = System.getProperty("smack.debuggerClass");
                }
                catch (Throwable throwable) {}
                Class<?> debuggerClass = null;
                if (className != null) {
                    try {
                        debuggerClass = Class.forName(className);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (debuggerClass == null) {
                    try {
                        debuggerClass = Class.forName("org.jivesoftware.smackx.debugger.EnhancedDebugger");
                    }
                    catch (Exception exception) {
                        try {
                            debuggerClass = Class.forName("org.jivesoftware.smack.debugger.LiteDebugger");
                        }
                        catch (Exception ex2) {
                            ex2.printStackTrace();
                        }
                    }
                }
                try {
                    Class[] classArray = new Class[3];
                    Class<?> clazz = class$3;
                    if (clazz == null) {
                        try {
                            clazz = class$3 = Class.forName("org.jivesoftware.smack.XMPPConnection");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz;
                    Class<?> clazz3 = class$4;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$4 = Class.forName("java.io.Writer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[1] = clazz3;
                    Class<?> clazz4 = class$5;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$5 = Class.forName("java.io.Reader");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[2] = clazz4;
                    Constructor<?> constructor = debuggerClass.getConstructor(classArray);
                    this.debugger = (SmackDebugger)constructor.newInstance(this, this.writer, this.reader);
                    this.reader = this.debugger.getReader();
                    this.writer = this.debugger.getWriter();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DEBUG_ENABLED = false;
                }
            } else {
                this.reader = this.debugger.newConnectionReader(this.reader);
                this.writer = this.debugger.newConnectionWriter(this.writer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void connectionEstablished(XMPPConnection connection) {
        ConnectionEstablishedListener[] listeners = null;
        List list = connectionEstablishedListeners;
        synchronized (list) {
            listeners = new ConnectionEstablishedListener[connectionEstablishedListeners.size()];
            connectionEstablishedListeners.toArray(listeners);
        }
        int i = 0;
        while (i < listeners.length) {
            listeners[i].connectionEstablished(connection);
            ++i;
        }
    }

    public boolean isUsingTLS() {
        return this.usingTLS;
    }

    public SASLAuthentication getSASLAuthentication() {
        return this.saslAuthentication;
    }

    void startTLSReceived() {
        if (!this.configuration.isTLSEnabled()) {
            return;
        }
        try {
            this.writer.write("<starttls xmlns=\"urn:ietf:params:xml:ns:xmpp-tls\"/>");
            this.writer.flush();
        }
        catch (IOException e) {
            this.packetReader.notifyConnectionError(e);
        }
    }

    void proceedTLSReceived() throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, new TrustManager[]{new ServerTrustManager(this.serviceName, this.configuration)}, new SecureRandom());
        Socket plain = this.socket;
        this.socket = context.getSocketFactory().createSocket(plain, plain.getInetAddress().getHostName(), plain.getPort(), true);
        this.socket.setSoTimeout(0);
        this.socket.setKeepAlive(true);
        this.initReaderAndWriter();
        ((SSLSocket)this.socket).startHandshake();
        this.usingTLS = true;
        this.packetWriter.setWriter(this.writer);
        this.packetWriter.openStream();
    }

    void setAvailableCompressionMethods(Collection methods) {
        this.compressionMethods = methods;
    }

    private boolean hasAvailableCompressionMethod(String method) {
        return this.compressionMethods != null && this.compressionMethods.contains(method);
    }

    public boolean isUsingCompression() {
        return this.usingCompression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean useCompression() {
        if (this.authenticated) {
            throw new IllegalStateException("Compression should be negotiated before authentication.");
        }
        try {
            Class.forName("com.jcraft.jzlib.ZOutputStream");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("Cannot use compression. Add smackx.jar to the classpath");
        }
        if (this.hasAvailableCompressionMethod("zlib")) {
            this.requestStreamCompression();
            XMPPConnection xMPPConnection = this;
            synchronized (xMPPConnection) {
                try {
                    this.wait(SmackConfiguration.getPacketReplyTimeout() * 5);
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.usingCompression;
        }
        return false;
    }

    private void requestStreamCompression() {
        try {
            this.writer.write("<compress xmlns='http://jabber.org/protocol/compress'>");
            this.writer.write("<method>zlib</method></compress>");
            this.writer.flush();
        }
        catch (IOException e) {
            this.packetReader.notifyConnectionError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startStreamCompression() throws Exception {
        this.usingCompression = true;
        this.initReaderAndWriter();
        this.packetWriter.setWriter(this.writer);
        this.packetWriter.openStream();
        XMPPConnection xMPPConnection = this;
        synchronized (xMPPConnection) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamCompressionDenied() {
        XMPPConnection xMPPConnection = this;
        synchronized (xMPPConnection) {
            this.notify();
        }
    }
}

