/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.InputStream;
import java.io.OutputStream;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;
import org.jivesoftware.smackx.packet.StreamInitiation;

public class FaultTolerantNegotiator
extends StreamNegotiator {
    private StreamNegotiator primaryNegotiator;
    private StreamNegotiator secondaryNegotiator;
    private XMPPConnection connection;
    private PacketFilter primaryFilter;
    private PacketFilter secondaryFilter;

    public FaultTolerantNegotiator(XMPPConnection connection, StreamNegotiator primary, StreamNegotiator secondary) {
        this.primaryNegotiator = primary;
        this.secondaryNegotiator = secondary;
        this.connection = connection;
    }

    public PacketFilter getInitiationPacketFilter(String from, String streamID) {
        if (this.primaryFilter == null || this.secondaryFilter == null) {
            this.primaryFilter = this.primaryNegotiator.getInitiationPacketFilter(from, streamID);
            this.secondaryFilter = this.secondaryNegotiator.getInitiationPacketFilter(from, streamID);
        }
        return new OrFilter(this.primaryFilter, this.secondaryFilter);
    }

    InputStream negotiateIncomingStream(Packet streamInitiation) throws XMPPException {
        throw new UnsupportedOperationException("Negotiation only handled by create incoming stream method.");
    }

    final Packet initiateIncomingStream(XMPPConnection connection, StreamInitiation initiation) throws XMPPException {
        throw new UnsupportedOperationException("Initiation handled by createIncomingStream method");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream createIncomingStream(StreamInitiation initiation) throws XMPPException {
        InputStream stream;
        PacketFilter filter = this.getInitiationPacketFilter(initiation.getFrom(), initiation.getSessionID());
        PacketCollector collector = this.connection.createPacketCollector(filter);
        StreamInitiation response = super.createInitiationAccept(initiation, this.getNamespaces());
        this.connection.sendPacket(response);
        try {
            try {
                Packet streamInitiation = collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
                if (streamInitiation == null) {
                    throw new XMPPException("No response from remote client");
                }
                StreamNegotiator negotiator = this.determineNegotiator(streamInitiation);
                stream = negotiator.negotiateIncomingStream(streamInitiation);
            }
            catch (XMPPException ex) {
                ex.printStackTrace();
                Packet streamInitiation = collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
                collector.cancel();
                if (streamInitiation == null) {
                    throw new XMPPException("No response from remote client");
                }
                StreamNegotiator negotiator = this.determineNegotiator(streamInitiation);
                stream = negotiator.negotiateIncomingStream(streamInitiation);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            collector.cancel();
            throw throwable;
        }
        {
            Object var9_13 = null;
            collector.cancel();
            return stream;
        }
    }

    private StreamNegotiator determineNegotiator(Packet streamInitiation) {
        return this.primaryFilter.accept(streamInitiation) ? this.primaryNegotiator : this.secondaryNegotiator;
    }

    public OutputStream createOutgoingStream(String streamID, String initiator, String target) throws XMPPException {
        OutputStream stream;
        try {
            stream = this.primaryNegotiator.createOutgoingStream(streamID, initiator, target);
        }
        catch (XMPPException xMPPException) {
            stream = this.secondaryNegotiator.createOutgoingStream(streamID, initiator, target);
        }
        return stream;
    }

    public String[] getNamespaces() {
        String[] primary = this.primaryNegotiator.getNamespaces();
        String[] secondary = this.secondaryNegotiator.getNamespaces();
        String[] namespaces = new String[primary.length + secondary.length];
        System.arraycopy(primary, 0, namespaces, 0, primary.length);
        System.arraycopy(secondary, 0, namespaces, primary.length, secondary.length);
        return namespaces;
    }

    public void cleanup() {
    }
}

