/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.httpclient;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import javax.security.auth.login.LoginException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.util.DateUtil;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.security.Callback;
import org.eclipse.ecf.core.security.CallbackHandler;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.security.NameCallback;
import org.eclipse.ecf.core.security.ObjectCallback;
import org.eclipse.ecf.core.security.UnsupportedCallbackException;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.core.util.ProxyAddress;
import org.eclipse.ecf.filetransfer.IFileRangeSpecification;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.filetransfer.InvalidFileRangeSpecificationException;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient.Activator;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient.ISSLSocketFactoryModifier;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient.Messages;
import org.eclipse.ecf.provider.filetransfer.httpclient.HttpClientSslProtocolSocketFactory;
import org.eclipse.ecf.provider.filetransfer.identity.FileTransferID;
import org.eclipse.ecf.provider.filetransfer.retrieve.AbstractRetrieveFileTransfer;
import org.eclipse.ecf.provider.filetransfer.retrieve.HttpHelper;
import org.eclipse.ecf.provider.filetransfer.util.JREProxyHelper;
import org.eclipse.osgi.util.NLS;

public class HttpClientRetrieveFileTransfer
extends AbstractRetrieveFileTransfer {
    private static final String USERNAME_PREFIX = Messages.HttpClientRetrieveFileTransfer_Username_Prefix;
    protected static final int DEFAULT_CONNECTION_TIMEOUT = 30000;
    protected static final int HTTP_PORT = 80;
    protected static final int HTTPS_PORT = 443;
    protected static final int MAX_RETRY = 2;
    protected static final String HTTPS = Messages.FileTransferNamespace_Https_Protocol;
    protected static final String HTTP = Messages.FileTransferNamespace_Http_Protocol;
    protected static final String[] supportedProtocols = new String[]{HTTP, HTTPS};
    private static final String LAST_MODIFIED_HEADER = "Last-Modified";
    private GzipGetMethod getMethod = null;
    private HttpClient httpClient = null;
    private String username;
    private String password;
    private int responseCode = -1;
    private String remoteFileName;
    protected int httpVersion = 1;
    protected IFileID fileid = null;
    protected JREProxyHelper proxyHelper = null;
    static /* synthetic */ Class class$0;

    public HttpClientRetrieveFileTransfer(HttpClient httpClient) {
        this.httpClient = httpClient;
        Assert.isNotNull((Object)this.httpClient);
        this.proxyHelper = new JREProxyHelper();
    }

    public String getRemoteFileName() {
        return this.remoteFileName;
    }

    protected void hardClose() {
        super.hardClose();
        if (this.getMethod != null) {
            this.getMethod.releaseConnection();
            this.getMethod = null;
        }
        this.responseCode = -1;
        if (this.proxyHelper != null) {
            this.proxyHelper.dispose();
            this.proxyHelper = null;
        }
    }

    protected Credentials getFileRequestCredentials() throws UnsupportedCallbackException, IOException {
        if (this.connectContext == null) {
            return null;
        }
        CallbackHandler callbackHandler = this.connectContext.getCallbackHandler();
        if (callbackHandler == null) {
            return null;
        }
        NameCallback usernameCallback = new NameCallback(USERNAME_PREFIX);
        ObjectCallback passwordCallback = new ObjectCallback();
        callbackHandler.handle(new Callback[]{usernameCallback, passwordCallback});
        this.username = usernameCallback.getName();
        this.password = (String)passwordCallback.getObject();
        return new UsernamePasswordCredentials(this.username, this.password);
    }

    protected void setupAuthentication(String urlString) throws UnsupportedCallbackException, IOException {
        Credentials credentials = null;
        if (this.username == null) {
            credentials = this.getFileRequestCredentials();
        }
        if (credentials != null && this.username != null) {
            AuthScope authScope = new AuthScope(HttpClientRetrieveFileTransfer.getHostFromURL(urlString), HttpClientRetrieveFileTransfer.getPortFromURL(urlString), AuthScope.ANY_REALM);
            this.httpClient.getState().setCredentials(authScope, credentials);
        }
    }

    protected void setupHostAndPort(String urlString) {
        if (HttpClientRetrieveFileTransfer.urlUsesHttps(urlString)) {
            ISSLSocketFactoryModifier sslSocketFactoryModifier = Activator.getDefault().getSSLSocketFactoryModifier();
            Protocol sslProtocol = null;
            Object psf = null;
            psf = sslSocketFactoryModifier != null ? sslSocketFactoryModifier.getProtocolSocketFactoryForProxy(this.proxy) : new HttpClientSslProtocolSocketFactory(this.proxy);
            sslProtocol = new Protocol(HTTPS, psf, HttpClientRetrieveFileTransfer.getPortFromURL(urlString));
            Protocol.registerProtocol((String)HTTPS, (Protocol)sslProtocol);
            this.httpClient.getHostConfiguration().setHost(HttpClientRetrieveFileTransfer.getHostFromURL(urlString), HttpClientRetrieveFileTransfer.getPortFromURL(urlString), sslProtocol);
        } else {
            this.httpClient.getHostConfiguration().setHost(HttpClientRetrieveFileTransfer.getHostFromURL(urlString), HttpClientRetrieveFileTransfer.getPortFromURL(urlString));
        }
    }

    protected void setRequestHeaderValues() throws InvalidFileRangeSpecificationException {
        IFileRangeSpecification rangeSpec = this.getFileRangeSpecification();
        if (rangeSpec != null) {
            long startPosition = rangeSpec.getStartPosition();
            long endPosition = rangeSpec.getEndPosition();
            if (startPosition < 0L) {
                throw new InvalidFileRangeSpecificationException(Messages.HttpClientRetrieveFileTransfer_RESUME_START_POSITION_LESS_THAN_ZERO, rangeSpec);
            }
            if (endPosition != -1L && endPosition <= startPosition) {
                throw new InvalidFileRangeSpecificationException(Messages.HttpClientRetrieveFileTransfer_RESUME_ERROR_END_POSITION_LESS_THAN_START, rangeSpec);
            }
            this.setRangeHeader("bytes=" + startPosition + "-" + (endPosition == -1L ? "" : "" + endPosition));
        }
        this.getMethod.addRequestHeader("Cache-Control", "max-age=0");
    }

    private void setRangeHeader(String value) {
        this.getMethod.addRequestHeader("Range", value);
    }

    private boolean isHTTP11() {
        return this.httpVersion >= 1;
    }

    public int getResponseCode() {
        if (this.responseCode != -1) {
            return this.responseCode;
        }
        HttpVersion version = this.getMethod.getEffectiveVersion();
        if (version == null) {
            this.responseCode = -1;
            this.httpVersion = 1;
            return this.responseCode;
        }
        this.httpVersion = version.getMinor();
        this.responseCode = this.getMethod.getStatusCode();
        return this.responseCode;
    }

    public ID getID() {
        return this.fileid;
    }

    private long getLastModifiedTimeFromHeader() throws IOException {
        Header lastModifiedHeader = this.getMethod.getResponseHeader(LAST_MODIFIED_HEADER);
        if (lastModifiedHeader == null) {
            throw new IOException(Messages.HttpClientRetrieveFileTransfer_INVALID_LAST_MODIFIED_TIME);
        }
        String lastModifiedString = lastModifiedHeader.getValue();
        long lastModified = 0L;
        if (lastModifiedString != null) {
            try {
                lastModified = DateUtil.parseDate((String)lastModifiedString).getTime();
            }
            catch (Exception exception) {
                throw new IOException(Messages.HttpClientRetrieveFileTransfer_EXCEPITION_INVALID_LAST_MODIFIED_FROM_SERVER);
            }
        }
        return lastModified;
    }

    protected void getResponseHeaderValues() throws IOException {
        if (this.getResponseCode() == -1) {
            throw new IOException(Messages.HttpClientRetrieveFileTransfer_INVALID_SERVER_RESPONSE_TO_PARTIAL_RANGE_REQUEST);
        }
        Header lastModifiedHeader = this.getMethod.getResponseHeader(LAST_MODIFIED_HEADER);
        if (lastModifiedHeader != null) {
            this.setLastModifiedTime(this.getLastModifiedTimeFromHeader());
        }
        this.setFileLength(this.getMethod.getResponseContentLength());
        this.fileid = new FileTransferID(this.getRetrieveNamespace(), this.getRemoteFileURL());
        Header contentDispositionHeader = this.getMethod.getResponseHeader("Content-Disposition");
        if (contentDispositionHeader != null) {
            this.remoteFileName = HttpHelper.getRemoteFileNameFromContentDispositionHeader((String)contentDispositionHeader.getValue());
        }
        if (this.remoteFileName == null) {
            IPath path;
            String pathStr = this.getMethod.getPath();
            if (pathStr != null && pathStr.length() > 0 && (path = Path.fromPortableString((String)pathStr)).segmentCount() > 0) {
                this.remoteFileName = path.lastSegment();
            }
            if (this.remoteFileName == null) {
                this.remoteFileName = super.getRemoteFileName();
            }
        }
    }

    Proxy getProxy() {
        return this.proxy;
    }

    protected void openStreams() throws IncomingFileTransferException {
        String urlString = this.getRemoteFileURL().toString();
        int code = -1;
        try {
            this.httpClient.getHttpConnectionManager().getParams().setSoTimeout(30000);
            this.httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(30000);
            this.setupAuthentication(urlString);
            this.setupHostAndPort(urlString);
            this.getMethod = new GzipGetMethod(urlString);
            this.getMethod.setFollowRedirects(true);
            this.getMethod.getParams().setParameter("http.authentication.credential-provider", (Object)new ECFCredentialsProvider());
            this.setRequestHeaderValues();
            code = this.httpClient.executeMethod((HttpMethod)this.getMethod);
            if (code != 206 && code != 200) {
                if (code == 404) {
                    this.getMethod.releaseConnection();
                    throw new FileNotFoundException(urlString);
                }
                if (code == 401 || code == 403) {
                    this.getMethod.getResponseBody();
                    this.getMethod.releaseConnection();
                    throw new IncomingFileTransferException(Messages.HttpClientRetrieveFileTransfer_Unauthorized);
                }
                if (code == 407) {
                    this.getMethod.releaseConnection();
                    throw new LoginException(Messages.HttpClientRetrieveFileTransfer_Proxy_Auth_Required);
                }
                this.getMethod.releaseConnection();
                throw new IOException(NLS.bind((String)Messages.HttpClientRetrieveFileTransfer_ERROR_GENERAL_RESPONSE_CODE, (Object)new Integer(code)));
            }
            this.getResponseHeaderValues();
            this.setInputStream(this.getMethod.getResponseBodyAsUnzippedStream());
            this.fireReceiveStartEvent();
        }
        catch (Exception e) {
            throw new IncomingFileTransferException(NLS.bind((String)Messages.HttpClientRetrieveFileTransfer_EXCEPTION_COULD_NOT_CONNECT, (Object)urlString), (Throwable)e, code);
        }
    }

    public void setConnectContextForAuthentication(IConnectContext connectContext) {
        super.setConnectContextForAuthentication(connectContext);
        this.username = null;
        this.password = null;
    }

    protected static String getHostFromURL(String url) {
        String result = url;
        int colonSlashSlash = url.indexOf("://");
        if (colonSlashSlash >= 0) {
            result = url.substring(colonSlashSlash + 3);
        }
        int colonPort = result.indexOf(58);
        int requestPath = result.indexOf(47);
        int substringEnd = colonPort > 0 && requestPath > 0 ? Math.min(colonPort, requestPath) : (colonPort > 0 ? colonPort : (requestPath > 0 ? requestPath : result.length()));
        return result.substring(0, substringEnd);
    }

    protected static int getPortFromURL(String url) {
        int colonSlashSlash = url.indexOf("://");
        int colonPort = url.indexOf(58, colonSlashSlash + 1);
        if (colonPort < 0) {
            return HttpClientRetrieveFileTransfer.urlUsesHttps(url) ? 443 : 80;
        }
        int requestPath = url.indexOf(47, colonPort + 1);
        int end = requestPath < 0 ? url.length() : requestPath;
        return Integer.parseInt(url.substring(colonPort + 1, end));
    }

    protected static boolean urlUsesHttps(String url) {
        return url.matches(String.valueOf(HTTPS) + ".*");
    }

    public static boolean supportsProtocol(String protocolString) {
        int i = 0;
        while (i < supportedProtocols.length) {
            if (supportedProtocols[i].equalsIgnoreCase(protocolString)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isConnected() {
        return this.getMethod != null;
    }

    protected boolean doPause() {
        if (this.isPaused() || !this.isConnected() || this.isDone()) {
            return false;
        }
        this.paused = true;
        return this.paused;
    }

    protected boolean doResume() {
        if (!this.isPaused() || this.isConnected()) {
            return false;
        }
        return this.openStreamsForResume();
    }

    protected void setResumeRequestHeaderValues() throws IOException {
        if (this.bytesReceived <= 0L || this.fileLength <= this.bytesReceived) {
            throw new IOException(Messages.HttpClientRetrieveFileTransfer_RESUME_START_ERROR);
        }
        this.setRangeHeader("bytes=" + this.bytesReceived + "-");
        this.getMethod.addRequestHeader("Cache-Control", "max-age=0");
    }

    private boolean openStreamsForResume() {
        URL theURL = this.getRemoteFileURL();
        int code = -1;
        try {
            this.remoteFileURL = new URL(theURL.toString());
            String urlString = this.getRemoteFileURL().toString();
            this.httpClient.getHttpConnectionManager().getParams().setSoTimeout(30000);
            this.httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(30000);
            this.setupAuthentication(urlString);
            this.setupHostAndPort(urlString);
            this.getMethod = new GzipGetMethod(urlString);
            this.getMethod.setFollowRedirects(true);
            this.setResumeRequestHeaderValues();
            code = this.httpClient.executeMethod((HttpMethod)this.getMethod);
            if (code != 206 && code != 200) {
                if (code == 404) {
                    this.getMethod.releaseConnection();
                    throw new FileNotFoundException(urlString);
                }
                if (code == 401 || code == 403) {
                    this.getMethod.getResponseBody();
                    this.getMethod.releaseConnection();
                    throw new IncomingFileTransferException(Messages.HttpClientRetrieveFileTransfer_Unauthorized, code);
                }
                if (code == 407) {
                    this.getMethod.releaseConnection();
                    throw new LoginException(Messages.HttpClientRetrieveFileTransfer_Proxy_Auth_Required);
                }
                this.getMethod.releaseConnection();
                throw new IOException(NLS.bind((String)Messages.HttpClientRetrieveFileTransfer_ERROR_GENERAL_RESPONSE_CODE, (Object)new Integer(code)));
            }
            this.getResumeResponseHeaderValues();
            this.setInputStream(this.getMethod.getResponseBodyAsUnzippedStream());
            this.paused = false;
            this.fireReceiveResumedEvent();
            return true;
        }
        catch (Exception e) {
            this.exception = e;
            this.done = true;
            this.hardClose();
            this.fireTransferReceiveDoneEvent();
            return false;
        }
    }

    protected void getResumeResponseHeaderValues() throws IOException {
        if (this.getResponseCode() != 206) {
            throw new IOException();
        }
        if (this.lastModifiedTime != this.getLastModifiedTimeFromHeader()) {
            throw new IOException(Messages.HttpClientRetrieveFileTransfer_EXCEPTION_FILE_MODIFIED_SINCE_LAST_ACCESS);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == null) {
            return null;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.filetransfer.IFileTransferPausable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz) && this.isHTTP11()) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    protected void setupProxy(Proxy proxy) {
        if (proxy.getType().equals(Proxy.Type.HTTP)) {
            ProxyAddress address = proxy.getAddress();
            this.httpClient.getHostConfiguration().setProxy(HttpClientRetrieveFileTransfer.getHostFromURL(address.getHostName()), address.getPort());
            String proxyUsername = proxy.getUsername();
            String proxyPassword = proxy.getPassword();
            if (proxyUsername != null) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                AuthScope proxyAuthScope = new AuthScope(address.getHostName(), address.getPort(), AuthScope.ANY_REALM);
                this.httpClient.getState().setProxyCredentials(proxyAuthScope, (Credentials)credentials);
            }
        } else if (proxy.getType().equals(Proxy.Type.SOCKS)) {
            this.proxyHelper.setupProxy(proxy);
        }
    }

    protected NTCredentials createNTLMCredentials(Proxy p) {
        if (p == null) {
            return null;
        }
        String un = this.getNTLMUserName(p);
        String domain = this.getNTLMDomainName(p);
        if (un == null || domain == null) {
            return null;
        }
        return new NTCredentials(un, p.getPassword(), p.getAddress().getHostName(), domain);
    }

    protected String getNTLMDomainName(Proxy p) {
        String domainUsername = p.getUsername();
        int slashloc = domainUsername.indexOf(92);
        if (slashloc == -1) {
            return null;
        }
        return domainUsername.substring(0, slashloc);
    }

    protected String getNTLMUserName(Proxy p) {
        String domainUsername = p.getUsername();
        int slashloc = domainUsername.indexOf(92);
        if (slashloc == -1) {
            return null;
        }
        return domainUsername.substring(slashloc + 1);
    }

    final class ECFCredentialsProvider
    implements CredentialsProvider {
        ECFCredentialsProvider() {
        }

        public Credentials getCredentials(AuthScheme scheme, String host, int port, boolean isProxyAuthenticating) throws CredentialsNotAvailableException {
            if ("ntlm".equalsIgnoreCase(scheme.getSchemeName())) {
                return HttpClientRetrieveFileTransfer.this.createNTLMCredentials(HttpClientRetrieveFileTransfer.this.getProxy());
            }
            return null;
        }
    }

    public class GzipGetMethod
    extends GetMethod {
        private static final String CONTENT_ENCODING = "Content-Encoding";
        private static final String ACCEPT_ENCODING = "Accept-encoding";
        private static final String CONTENT_ENCODING_GZIP = "gzip";
        private static final String CONTENT_ENCODING_ACCEPTED = "gzip";
        private boolean gzipReceived = false;

        public GzipGetMethod(String urlString) {
            super(urlString);
        }

        private boolean isZippedReply() {
            boolean zipped = this.getResponseHeader(CONTENT_ENCODING) != null && this.getResponseHeader(CONTENT_ENCODING).getValue().equals("gzip");
            return zipped;
        }

        public int execute(HttpState state, HttpConnection conn) throws HttpException, IOException {
            this.setRequestHeader(ACCEPT_ENCODING, "gzip");
            int result = super.execute(state, conn);
            if (this.isZippedReply()) {
                this.gzipReceived = true;
            }
            return result;
        }

        public InputStream getResponseBodyAsUnzippedStream() throws IOException {
            InputStream input = super.getResponseBodyAsStream();
            try {
                if (this.gzipReceived) {
                    return new GZIPInputStream(input);
                }
            }
            catch (IOException e) {
                Activator.getDefault().log((IStatus)new Status(2, "org.eclipse.ecf.provider.filetransfer.httpclient", 2, "Exception creating gzip input stream", (Throwable)e));
                throw e;
            }
            return input;
        }
    }
}

