/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jmdns.container;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.ServiceTypeListener;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.events.ContainerConnectedEvent;
import org.eclipse.ecf.core.events.ContainerConnectingEvent;
import org.eclipse.ecf.core.events.ContainerDisconnectedEvent;
import org.eclipse.ecf.core.events.ContainerDisconnectingEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.IIDFactory;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.discovery.AbstractDiscoveryContainerAdapter;
import org.eclipse.ecf.discovery.DiscoveryContainerConfig;
import org.eclipse.ecf.discovery.IServiceEvent;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceProperties;
import org.eclipse.ecf.discovery.IServiceTypeEvent;
import org.eclipse.ecf.discovery.ServiceContainerEvent;
import org.eclipse.ecf.discovery.ServiceProperties;
import org.eclipse.ecf.discovery.ServiceTypeContainerEvent;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.discovery.identity.ServiceID;
import org.eclipse.ecf.discovery.identity.ServiceIDFactory;
import org.eclipse.ecf.discovery.service.IDiscoveryService;
import org.eclipse.ecf.internal.provider.jmdns.JMDNSDebugOptions;
import org.eclipse.ecf.internal.provider.jmdns.JMDNSPlugin;
import org.eclipse.ecf.internal.provider.jmdns.Messages;
import org.eclipse.ecf.internal.provider.jmdns.SimpleFIFOQueue;
import org.eclipse.osgi.util.NLS;

public class JMDNSDiscoveryContainer
extends AbstractDiscoveryContainerAdapter
implements IDiscoveryService,
ServiceListener,
ServiceTypeListener {
    private static final String SCHEME_PROPERTY = "jmdns.ptcl";
    private static final String URI_PATH_PROPERTY = "jmdns.uripath";
    private static final String NAMING_AUTHORITY_PROPERTY = "jmdns.namingauthority";
    public static final int DEFAULT_REQUEST_TIMEOUT = 3000;
    private static int instanceCount = 0;
    private InetAddress intf;
    JmDNS jmdns;
    private ID targetID;
    List serviceTypes;
    boolean disposed;
    Object lock;
    SimpleFIFOQueue queue;
    Thread notificationThread;
    static /* synthetic */ Class class$0;

    public JMDNSDiscoveryContainer(InetAddress addr) {
        IIDFactory iIDFactory = IDFactory.getDefault();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.provider.jmdns.container.JMDNSDiscoveryContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super("ecf.namespace.jmdns", new DiscoveryContainerConfig(iIDFactory.createStringID(String.valueOf(clazz.getName()) + ";" + addr.toString() + ";" + instanceCount++)));
        this.intf = null;
        this.jmdns = null;
        this.targetID = null;
        this.serviceTypes = null;
        this.disposed = false;
        this.lock = new Object();
        this.queue = null;
        this.notificationThread = null;
        Assert.isNotNull((Object)addr);
        this.intf = addr;
        this.serviceTypes = new ArrayList();
    }

    public ID getConnectedID() {
        return this.targetID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.lock;
        synchronized (object) {
            super.dispose();
            this.disposed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(ID targetID1, IConnectContext joinContext) throws ContainerConnectException {
        Object object = this.lock;
        synchronized (object) {
            if (this.disposed) {
                throw new ContainerConnectException(Messages.JMDNSDiscoveryContainer_EXCEPTION_CONTAINER_DISPOSED);
            }
            if (this.targetID != null) {
                throw new ContainerConnectException(Messages.JMDNSDiscoveryContainer_EXCEPTION_ALREADY_CONNECTED);
            }
            this.targetID = targetID1 == null ? this.getConfig().getID() : targetID1;
            this.fireContainerEvent((IContainerEvent)new ContainerConnectingEvent(this.getID(), this.targetID, (Object)joinContext));
            this.initializeQueue();
            try {
                this.jmdns = JmDNS.create((InetAddress)this.intf);
                this.jmdns.addServiceTypeListener((ServiceTypeListener)this);
            }
            catch (IOException e) {
                if (this.jmdns != null) {
                    this.jmdns.close();
                    this.jmdns = null;
                }
                throw new ContainerConnectException(Messages.JMDNSDiscoveryContainer_EXCEPTION_CREATE_JMDNS_INSTANCE, (Throwable)e);
            }
            this.fireContainerEvent((IContainerEvent)new ContainerConnectedEvent(this.getID(), this.targetID));
        }
    }

    private void initializeQueue() {
        this.queue = new SimpleFIFOQueue();
        this.notificationThread = new Thread(new Runnable(){

            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    Runnable runnable = (Runnable)JMDNSDiscoveryContainer.this.queue.dequeue();
                    if (Thread.currentThread().isInterrupted() || runnable == null) break;
                    try {
                        runnable.run();
                    }
                    catch (Throwable t) {
                        JMDNSDiscoveryContainer.this.handleRuntimeException(t);
                    }
                }
            }
        }, "JMDNS Discovery Thread");
        this.notificationThread.start();
    }

    protected void handleRuntimeException(Throwable t) {
        JMDNSPlugin.getDefault().logException("handleRuntimeException", t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.lock;
        synchronized (object) {
            if (this.jmdns != null) {
                ID connectedID = this.getConnectedID();
                this.fireContainerEvent((IContainerEvent)new ContainerDisconnectingEvent(this.getID(), connectedID));
                this.jmdns.close();
                this.jmdns = null;
                this.queue.close();
                this.notificationThread = null;
                this.targetID = null;
                this.serviceTypes.clear();
                this.fireContainerEvent((IContainerEvent)new ContainerDisconnectedEvent(this.getID(), connectedID));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceInfo getServiceInfo(IServiceID service) {
        Assert.isNotNull((Object)service);
        Object object = this.lock;
        synchronized (object) {
            block6: {
                if (this.jmdns == null) break block6;
                try {
                    ServiceInfo serviceInfo = this.jmdns.getServiceInfo(service.getServiceTypeID().getInternal(), service.getServiceName());
                    return serviceInfo == null ? null : this.createIServiceInfoFromServiceInfo(serviceInfo);
                }
                catch (Exception e) {
                    Trace.catching((String)"org.eclipse.ecf.provider.jmdns", (String)JMDNSDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getServiceInfo", (Throwable)e);
                    return null;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceInfo[] getServices() {
        Object object = this.lock;
        synchronized (object) {
            IServiceTypeID[] serviceTypeArray = this.getServiceTypes();
            ArrayList<IServiceInfo> results = new ArrayList<IServiceInfo>();
            int i = 0;
            while (i < serviceTypeArray.length) {
                IServiceTypeID stid = serviceTypeArray[i];
                if (stid != null) {
                    results.addAll(Arrays.asList(this.getServices(stid)));
                }
                ++i;
            }
            return results.toArray(new IServiceInfo[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceInfo[] getServices(IServiceTypeID type) {
        Assert.isNotNull((Object)type);
        ArrayList<IServiceInfo> serviceInfos = new ArrayList<IServiceInfo>();
        Object object = this.lock;
        synchronized (object) {
            Iterator itr = this.serviceTypes.iterator();
            while (itr.hasNext()) {
                IServiceTypeID serviceType = (IServiceTypeID)itr.next();
                if (!Arrays.equals(serviceType.getServices(), type.getServices()) || !Arrays.equals(serviceType.getProtocols(), type.getProtocols()) || !Arrays.equals(serviceType.getScopes(), type.getScopes())) continue;
                ServiceInfo[] infos = this.jmdns.list(type.getInternal());
                int i = 0;
                while (i < infos.length) {
                    try {
                        IServiceInfo si;
                        if (infos[i] != null && (si = this.createIServiceInfoFromServiceInfo(infos[i])) != null) {
                            serviceInfos.add(si);
                        }
                    }
                    catch (Exception e) {
                        Trace.catching((String)"org.eclipse.ecf.provider.jmdns", (String)JMDNSDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getServices", (Throwable)e);
                    }
                    ++i;
                }
            }
            return serviceInfos.toArray(new IServiceInfo[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceTypeID[] getServiceTypes() {
        Object object = this.lock;
        synchronized (object) {
            return this.serviceTypes.toArray(new IServiceTypeID[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerService(IServiceInfo serviceInfo) throws ECFException {
        Assert.isNotNull((Object)serviceInfo);
        ServiceInfo svcInfo = this.createServiceInfoFromIServiceInfo(serviceInfo);
        this.checkServiceInfo(svcInfo);
        JmDNS localJmDNS = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.jmdns == null) {
                throw new ECFException(Messages.JMDNSDiscoveryContainer_DISCOVERY_NOT_INITIALIZED);
            }
            localJmDNS = this.jmdns;
        }
        if (localJmDNS != null) {
            try {
                localJmDNS.registerService(svcInfo);
            }
            catch (IOException e) {
                throw new ECFException(Messages.JMDNSDiscoveryContainer_EXCEPTION_REGISTER_SERVICE, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterService(IServiceInfo serviceInfo) {
        Assert.isNotNull((Object)serviceInfo);
        ServiceInfo si = this.createServiceInfoFromIServiceInfo(serviceInfo);
        JmDNS localJmDNS = null;
        Object object = this.lock;
        synchronized (object) {
            localJmDNS = this.jmdns;
        }
        if (localJmDNS != null) {
            localJmDNS.unregisterService(si);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInThread(Runnable runnable) {
        SimpleFIFOQueue localQueue = null;
        Object object = this.lock;
        synchronized (object) {
            localQueue = this.queue;
        }
        if (localQueue != null) {
            localQueue.enqueue(runnable);
        }
    }

    private void logError(String errorString) {
        JMDNSPlugin.getDefault().logError(errorString);
    }

    public void serviceTypeAdded(ServiceEvent arg0) {
        final String st = arg0.getType();
        if (st == null) {
            this.logError(NLS.bind((String)Messages.JMDNSDiscoveryContainer_NO_JMDNS_SERVICE_TYPE, (Object)arg0));
            return;
        }
        final IServiceTypeID serviceType = this.createServiceTypeID(st);
        if (serviceType == null) {
            this.logError(NLS.bind((String)Messages.JMDNSDiscoveryContainer_NO_SERVICE_TYPE, (Object)arg0, (Object)st));
            return;
        }
        this.runInThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean added = false;
                Object object = JMDNSDiscoveryContainer.this.lock;
                synchronized (object) {
                    if (JMDNSDiscoveryContainer.this.jmdns != null) {
                        JMDNSDiscoveryContainer.this.serviceTypes.add(serviceType);
                        JMDNSDiscoveryContainer.this.jmdns.addServiceListener(st, (ServiceListener)JMDNSDiscoveryContainer.this);
                        added = true;
                    }
                }
                if (added) {
                    try {
                        JMDNSDiscoveryContainer.this.fireTypeDiscovered(serviceType);
                    }
                    catch (Exception e) {
                        Trace.catching((String)"org.eclipse.ecf.provider.jmdns", (String)JMDNSDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"serviceTypeAdded", (Throwable)e);
                    }
                }
            }
        });
    }

    void fireTypeDiscovered(IServiceTypeID serviceType) {
        this.fireServiceTypeDiscovered((IServiceTypeEvent)new ServiceTypeContainerEvent(serviceType, this.getID()));
    }

    public void serviceAdded(final ServiceEvent arg0) {
        Trace.trace((String)"org.eclipse.ecf.provider.jmdns", (String)("serviceAdded(" + arg0 + ")"));
        this.runInThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                JmDNS localJmdns = null;
                Object object = JMDNSDiscoveryContainer.this.lock;
                synchronized (object) {
                    localJmdns = JMDNSDiscoveryContainer.this.jmdns;
                }
                if (localJmdns != null) {
                    String serviceType = arg0.getType();
                    String serviceName = arg0.getName();
                    ServiceInfo info = localJmdns.getServiceInfo(serviceType, serviceName);
                    IServiceInfo aServiceInfo = null;
                    try {
                        aServiceInfo = JMDNSDiscoveryContainer.this.createIServiceInfoFromServiceInfo(info);
                    }
                    catch (Exception exception) {
                        return;
                    }
                    JMDNSDiscoveryContainer.this.fireDiscovered(aServiceInfo);
                }
            }
        });
    }

    Collection getAllListeners(IServiceTypeID serviceTypeID) {
        return super.getListeners(serviceTypeID);
    }

    public void serviceRemoved(final ServiceEvent arg0) {
        Trace.trace((String)"org.eclipse.ecf.provider.jmdns", (String)("serviceRemoved(" + arg0 + ")"));
        this.runInThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                JmDNS localJmdns = null;
                Object object = JMDNSDiscoveryContainer.this.lock;
                synchronized (object) {
                    localJmdns = JMDNSDiscoveryContainer.this.jmdns;
                }
                if (localJmdns != null) {
                    try {
                        JMDNSDiscoveryContainer.this.fireUndiscovered(JMDNSDiscoveryContainer.this.createIServiceInfoFromServiceEvent(arg0));
                    }
                    catch (Exception e) {
                        Trace.catching((String)"org.eclipse.ecf.provider.jmdns", (String)JMDNSDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"serviceRemoved", (Throwable)e);
                    }
                }
            }
        });
    }

    void fireUndiscovered(IServiceInfo serviceInfo) {
        this.fireServiceUndiscovered((IServiceEvent)new ServiceContainerEvent(serviceInfo, this.getID()));
    }

    public void serviceResolved(final ServiceEvent arg0) {
        Trace.trace((String)"org.eclipse.ecf.provider.jmdns", (String)("serviceResolved(" + arg0 + ")"));
        this.runInThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                JmDNS localJmdns = null;
                Object object = JMDNSDiscoveryContainer.this.lock;
                synchronized (object) {
                    localJmdns = JMDNSDiscoveryContainer.this.jmdns;
                }
                if (localJmdns != null) {
                    try {
                        JMDNSDiscoveryContainer.this.fireDiscovered(JMDNSDiscoveryContainer.this.createIServiceInfoFromServiceEvent(arg0));
                    }
                    catch (Exception e) {
                        Trace.catching((String)"org.eclipse.ecf.provider.jmdns", (String)JMDNSDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"serviceResolved", (Throwable)e);
                    }
                }
            }
        });
    }

    void fireDiscovered(IServiceInfo serviceInfo) {
        this.fireServiceDiscovered((IServiceEvent)new ServiceContainerEvent(serviceInfo, this.getID()));
    }

    private void checkServiceInfo(ServiceInfo serviceInfo) throws ECFException {
        String serviceName = serviceInfo.getName();
        if (serviceName == null) {
            throw new ECFException(Messages.JMDNSDiscoveryContainer_SERVICE_NAME_NOT_NULL);
        }
    }

    private IServiceTypeID createServiceTypeID(String type) {
        ServiceID serviceID = this.createServiceID(type, null);
        if (serviceID == null) {
            return null;
        }
        return serviceID.getServiceTypeID();
    }

    IServiceInfo createIServiceInfoFromServiceEvent(ServiceEvent event) throws Exception {
        ServiceInfo si = event.getInfo();
        if (si != null) {
            return this.createIServiceInfoFromServiceInfo(si);
        }
        ServiceID sID = this.createServiceID(event.getType(), event.getName());
        if (sID == null) {
            throw new InvalidObjectException(Messages.JMDNSDiscoveryContainer_EXCEPTION_SERVICEINFO_INVALID);
        }
        return new org.eclipse.ecf.discovery.ServiceInfo(null, null, -1, (IServiceID)sID);
    }

    private IServiceInfo createIServiceInfoFromServiceInfo(ServiceInfo serviceInfo) throws Exception {
        Assert.isNotNull((Object)serviceInfo);
        String st = serviceInfo.getType();
        String n = serviceInfo.getName();
        if (st == null || n == null) {
            throw new InvalidObjectException(Messages.JMDNSDiscoveryContainer_EXCEPTION_SERVICEINFO_INVALID);
        }
        InetAddress addr = serviceInfo.getAddress();
        int port = serviceInfo.getPort();
        int priority = serviceInfo.getPriority();
        int weight = serviceInfo.getWeight();
        Properties props = new Properties();
        String uriProtocol = null;
        String uriPath = "";
        String namingAuthority = "iana";
        Enumeration e = serviceInfo.getPropertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (SCHEME_PROPERTY.equals(name)) {
                uriProtocol = serviceInfo.getPropertyString(name);
                continue;
            }
            if (URI_PATH_PROPERTY.equals(name)) {
                uriPath = serviceInfo.getPropertyString(name);
                continue;
            }
            if (NAMING_AUTHORITY_PROPERTY.equals(name)) {
                namingAuthority = serviceInfo.getPropertyString(name);
                continue;
            }
            Object value = serviceInfo.getPropertyString(name);
            if (value == null) {
                value = serviceInfo.getPropertyBytes(name);
            }
            if (value == null) continue;
            props.put(name, value);
        }
        URI uri = URI.create(String.valueOf(uriProtocol) + "://" + addr.getHostAddress() + ":" + port + uriPath);
        ServiceID sID = this.createServiceID(String.valueOf(serviceInfo.getType()) + "_" + namingAuthority, serviceInfo.getName());
        if (sID == null) {
            throw new InvalidObjectException(Messages.JMDNSDiscoveryContainer_EXCEPTION_SERVICEINFO_INVALID);
        }
        return new org.eclipse.ecf.discovery.ServiceInfo(uri, (IServiceID)sID, priority, weight, (IServiceProperties)new ServiceProperties(props));
    }

    ServiceID createServiceID(String type, String name) {
        ServiceID id = null;
        try {
            id = (ServiceID)ServiceIDFactory.getDefault().createServiceID(this.getServicesNamespace(), type, name);
        }
        catch (IDCreateException e) {
            Trace.catching((String)"org.eclipse.ecf.provider.jmdns", (String)JMDNSDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"createServiceID", (Throwable)e);
        }
        return id;
    }

    private ServiceInfo createServiceInfoFromIServiceInfo(IServiceInfo serviceInfo) {
        if (serviceInfo == null) {
            return null;
        }
        IServiceID sID = serviceInfo.getServiceID();
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        IServiceProperties svcProps = serviceInfo.getServiceProperties();
        if (svcProps != null) {
            Enumeration e = svcProps.getPropertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Object val = svcProps.getProperty(key);
                if (val == null) continue;
                props.put(key, val);
            }
        }
        URI location = serviceInfo.getLocation();
        props.put(SCHEME_PROPERTY, location.getScheme());
        props.put(URI_PATH_PROPERTY, location.getPath());
        props.put(NAMING_AUTHORITY_PROPERTY, serviceInfo.getServiceID().getServiceTypeID().getNamingAuthority());
        int priority = serviceInfo.getPriority() == -1 ? 0 : serviceInfo.getPriority();
        int weight = serviceInfo.getWeight() == -1 ? 0 : serviceInfo.getWeight();
        String serviceName = sID.getServiceName() == null ? location.getHost() : sID.getServiceName();
        ServiceInfo si = ServiceInfo.create((String)sID.getServiceTypeID().getInternal(), (String)serviceName, (int)location.getPort(), (int)weight, (int)priority, props);
        return si;
    }
}

