/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.remoteservices.ui.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.internal.remoteservices.ui.RemoteServiceHandlerUtil;
import org.eclipse.ecf.internal.remoteservices.ui.handlers.ConnectionHandler;
import org.eclipse.osgi.util.NLS;

public class ConnectRemoteServicehandler
extends ConnectionHandler {
    protected Job getJob(final ExecutionEvent event) throws ExecutionException {
        final ID createConnectId = RemoteServiceHandlerUtil.getActiveConnectIDChecked(event);
        return new Job(NLS.bind((String)"Connecting {0}", (Object)createConnectId.getName())){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IContainer container = RemoteServiceHandlerUtil.getActiveIRemoteServiceContainerChecked(event);
                    container.connect(createConnectId, null);
                }
                catch (ContainerConnectException e) {
                    ConnectRemoteServicehandler.this.showException(e);
                    return Status.CANCEL_STATUS;
                }
                catch (ExecutionException e) {
                    ConnectRemoteServicehandler.this.showException(e);
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
    }
}

