/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.sync.doc.cola;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.sync.doc.cola.ColaDeletionTransformationStrategy;
import org.eclipse.ecf.internal.sync.doc.cola.ColaInsertionTransformationStategy;
import org.eclipse.ecf.internal.sync.doc.cola.ColaReplacementTransformationStategy;
import org.eclipse.ecf.internal.sync.doc.cola.ColaTransformationStrategy;
import org.eclipse.ecf.sync.doc.DocumentChangeMessage;

public class ColaDocumentChangeMessage
extends DocumentChangeMessage {
    private static final long serialVersionUID = 2038025022180647210L;
    private final long localOperationsCount;
    private final long remoteOperationsCount;
    private final int transformType;
    private boolean splitUp;
    private List splitUpRepresentation;

    public ColaDocumentChangeMessage(DocumentChangeMessage msg, long localOperationsCount, long remoteOperationsCount) {
        super(msg.getOffset(), msg.getLengthOfReplacedText(), msg.getText());
        this.localOperationsCount = localOperationsCount;
        this.remoteOperationsCount = remoteOperationsCount;
        this.splitUp = false;
        this.splitUpRepresentation = new LinkedList();
        this.transformType = super.getLengthOfReplacedText() == 0 ? 0 : (super.getText().length() == 0 ? 1 : 2);
    }

    public boolean isInsertion() {
        return this.transformType == 0;
    }

    public boolean isDeletion() {
        return this.transformType == 1;
    }

    public boolean isReplacement() {
        return this.transformType == 2;
    }

    public long getLocalOperationsCount() {
        return this.localOperationsCount;
    }

    public long getRemoteOperationsCount() {
        return this.remoteOperationsCount;
    }

    private ColaTransformationStrategy getTransformationStrategy() {
        if (this.isInsertion()) {
            return ColaInsertionTransformationStategy.getInstance();
        }
        if (this.isDeletion()) {
            return ColaDeletionTransformationStrategy.getInstance();
        }
        return ColaReplacementTransformationStategy.getInstance();
    }

    public ColaDocumentChangeMessage transformAgainst(ColaDocumentChangeMessage localMsg, boolean localMsgHighPrio) {
        Trace.entering((String)"org.eclipse.ecf.sync", (String)"org.eclipse.ecf.sync/debug/methods/entering", this.getClass(), (String)"transformAgainst", (Object)localMsg);
        ColaDocumentChangeMessage transformedMsg = this.getTransformationStrategy().getOperationalTransform(this, localMsg, localMsgHighPrio);
        Trace.entering((String)"org.eclipse.ecf.sync", (String)"org.eclipse.ecf.sync/debug/methods/exiting", this.getClass(), (String)"transformAgainst", (Object)transformedMsg);
        return transformedMsg;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("ColaDocumentChangeMessage[");
        buf.append("text=").append(this.getText()).append(";offset=").append(this.getOffset());
        buf.append(";length=").append(this.getLengthOfReplacedText()).append("]");
        buf.append(";operationsCount[local=").append(this.getLocalOperationsCount());
        buf.append(";remote=").append(this.getRemoteOperationsCount()).append("]]");
        return buf.toString();
    }

    public void setSplitUp(boolean toBeSplitUp) {
        this.splitUp = toBeSplitUp;
    }

    public boolean isSplitUp() {
        return this.splitUp;
    }

    public void setSplitUpRepresentation(List splitUpRepresentation) {
        this.splitUpRepresentation = splitUpRepresentation;
    }

    public List getSplitUpRepresentation() {
        return this.splitUpRepresentation;
    }

    public void addToSplitUpRepresentation(ColaDocumentChangeMessage splitUpRepresentationPart) {
        this.splitUpRepresentation.add(splitUpRepresentationPart);
    }
}

