/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.util.CanceledException;
import org.eclipse.ecf.core.util.IFutureCallable;
import org.eclipse.ecf.core.util.IFutureStatus;
import org.eclipse.ecf.core.util.TimeoutException;

public class FutureStatus
extends Status
implements IFutureStatus {
    private Object resultValue = null;
    private boolean resultReady = false;
    private int futureSeverity;
    private IProgressMonitor progressMonitor = null;

    public FutureStatus(String pluginId, String message, IProgressMonitor progressMonitor) {
        super(0, pluginId, message);
        this.progressMonitor = new FutureStatusProgressMonitor((IProgressMonitor)(progressMonitor == null ? new NullProgressMonitor() : progressMonitor));
        this.setSeverity(16);
    }

    public FutureStatus(String message, IProgressMonitor progressMonitor) {
        this("org.eclipse.ecf", message, progressMonitor);
    }

    public FutureStatus(IProgressMonitor progressMonitor) {
        this(null, progressMonitor);
    }

    public FutureStatus() {
        this(null);
    }

    private void throwIfCanceled() throws CanceledException {
        IProgressMonitor pm = this.getProgressMonitor();
        if (pm != null && pm.isCanceled()) {
            throw new CanceledException(this);
        }
    }

    public synchronized Object get() throws InterruptedException, CanceledException {
        this.throwIfCanceled();
        while (!this.resultReady) {
            this.wait();
        }
        this.throwIfCanceled();
        return this.resultValue;
    }

    public synchronized Object get(long waitTimeInMillis) throws InterruptedException, TimeoutException, CanceledException {
        long startTime = waitTimeInMillis <= 0L ? 0L : System.currentTimeMillis();
        long waitTime = waitTimeInMillis;
        this.throwIfCanceled();
        if (this.resultReady) {
            return this.resultValue;
        }
        if (waitTime <= 0L) {
            throw new TimeoutException(waitTimeInMillis);
        }
        do {
            this.wait(waitTime);
            this.throwIfCanceled();
            if (!this.resultReady) continue;
            return this.resultValue;
        } while ((waitTime = waitTimeInMillis - (System.currentTimeMillis() - startTime)) > 0L);
        throw new TimeoutException(waitTimeInMillis);
    }

    public IProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public synchronized boolean isDone() {
        return this.resultReady;
    }

    synchronized void setCanceled() {
        this.resultReady = true;
        this.notifyAll();
    }

    public Runnable setter(final IFutureCallable function) {
        return new Runnable(){

            public void run() {
                try {
                    FutureStatus.this.set(function.call(FutureStatus.this.getProgressMonitor()));
                }
                catch (Throwable ex) {
                    FutureStatus.this.setException(ex);
                }
            }
        };
    }

    protected synchronized void setSeverity(int severity) {
        Assert.isTrue((severity == 0 || severity == 8 || severity == 4 || severity == 1 || severity == 2 || severity == 16 ? 1 : 0) != 0);
        this.futureSeverity = severity;
    }

    public synchronized int getSeverity() {
        return this.futureSeverity;
    }

    protected synchronized void setException(Throwable ex) {
        super.setException(ex);
        this.resultReady = true;
        this.setSeverity(4);
        this.notifyAll();
    }

    synchronized void set(Object newValue) {
        this.resultValue = newValue;
        this.resultReady = true;
        this.setSeverity(0);
        this.notifyAll();
    }

    class FutureStatusProgressMonitor
    implements IProgressMonitor {
        private final IProgressMonitor monitor;

        public FutureStatusProgressMonitor(IProgressMonitor progressMonitor) {
            this.monitor = progressMonitor;
        }

        public void beginTask(String name, int totalWork) {
            this.monitor.beginTask(name, totalWork);
        }

        public void done() {
            this.monitor.done();
        }

        public void internalWorked(double work) {
            this.monitor.internalWorked(work);
        }

        public boolean isCanceled() {
            return this.monitor.isCanceled();
        }

        public void setCanceled(boolean value) {
            this.monitor.setCanceled(value);
            if (value) {
                FutureStatus.this.setCanceled();
            }
        }

        public void setTaskName(String name) {
            this.monitor.setTaskName(name);
        }

        public void subTask(String name) {
            this.monitor.subTask(name);
        }

        public void worked(int work) {
            this.monitor.worked(work);
        }
    }
}

