/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp;

import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.ServiceType;
import ch.ethz.iks.slp.impl.AuthenticatedURL;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public final class ServiceURL
extends AuthenticatedURL
implements Serializable {
    private static final long serialVersionUID = 9181946114021582389L;
    public static final int NO_PORT = 0;
    public static final int LIFETIME_NONE = 0;
    public static final int LIFETIME_DEFAULT = 10800;
    public static final int LIFETIME_MAXIMUM = 65535;
    public static final int LIFETIME_PERMANENT = -1;
    private String url = null;
    private int lifetime = 0;
    private ServiceType type = null;
    private String host = null;
    private String userInfo = null;
    private String protocol = null;
    private int port = 0;
    private String path = null;

    private ServiceURL() {
    }

    public ServiceURL(String serviceURL, int lifeTime) throws ServiceLocationException {
        this.url = serviceURL;
        this.lifetime = lifeTime;
        try {
            this.parse();
        }
        catch (Exception exception) {
            throw new ServiceLocationException(2, "service url is malformed: [" + this.url + "]. ");
        }
    }

    private void parse() {
        int pathStart;
        int hostEnd;
        int pos1 = this.url.indexOf("://");
        this.type = new ServiceType(this.url.substring(0, pos1++));
        int pos2 = this.url.indexOf("://", pos1 + 1);
        if (pos2 > -1) {
            this.protocol = this.url.substring(pos1 + 2, pos2);
            pos1 = pos2 + 1;
        }
        if ((hostEnd = this.url.indexOf(":", pos1 + 2)) == -1) {
            this.port = 0;
            pathStart = hostEnd = this.url.indexOf("/", pos1 + 2);
        } else {
            pathStart = this.url.indexOf("/", hostEnd + 1);
            this.port = pathStart == -1 ? Integer.parseInt(this.url.substring(hostEnd + 1)) : Integer.parseInt(this.url.substring(hostEnd + 1, pathStart));
        }
        int pos3 = this.url.indexOf("@");
        if (pos3 > -1) {
            this.userInfo = this.url.substring(pos1 + 2, pos3);
            pos1 = pos3 - 1;
        } else {
            this.userInfo = "";
        }
        this.host = hostEnd == -1 ? this.url.substring(pos1 + 2) : this.url.substring(pos1 + 2, hostEnd);
        this.path = pathStart == -1 ? "" : this.url.substring(pathStart);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServiceURL) {
            ServiceURL u = (ServiceURL)obj;
            return this.type.equals(u.type) && this.host.equals(u.host) && this.port == u.port && (this.protocol == null && u.protocol == null || this.protocol.equals(u.protocol)) && this.path.equals(u.path);
        }
        return false;
    }

    public boolean matches(Object obj) {
        if (obj instanceof ServiceURL) {
            return this.equals(obj);
        }
        if (obj instanceof ServiceType) {
            return this.type.matches(obj);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.type.toString()) + "://" + (this.protocol != null ? String.valueOf(this.protocol) + "://" : "") + ("".equals(this.userInfo) ? "" : String.valueOf(this.userInfo) + "@") + this.host + (this.port != 0 ? ":" + this.port : "") + this.path;
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public ServiceType getServiceType() {
        return this.type;
    }

    public String getTransport() {
        return "";
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public int getPort() {
        return this.port;
    }

    public String getURLPath() {
        return this.path;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public void writeTo(DataOutputStream out) throws IOException {
        out.write(0);
        out.writeShort((short)this.lifetime);
        out.writeUTF(this.toString());
        this.writeAuthBlock(out);
    }

    public int getLength() {
        return 5 + this.toString().length() + this.getAuthBlockLength();
    }

    public static ServiceURL fromBytes(DataInputStream input) throws ServiceLocationException, IOException {
        ServiceURL surl = new ServiceURL();
        input.readByte();
        surl.lifetime = input.readShort();
        surl.url = input.readUTF();
        surl.authBlocks = ServiceURL.parseAuthBlock(input);
        surl.parse();
        return surl;
    }
}

