/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.example.collab.ui.hyperlink;

import org.eclipse.ecf.example.collab.share.EclipseCollabSharedObject;
import org.eclipse.ecf.internal.example.collab.ui.hyperlink.EclipseCollabHyperlink;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;

public class EclipseCollabHyperlinkDetector
extends AbstractHyperlinkDetector {
    public static final String SHARE_FILE_HYPERLINK_END = "/>";
    public static final String SHARE_FILE_HYPERLINK_START = "<open file=\"";
    public static final String SHARE_FILE_HYPERLINK_SELECTION = " selection=";

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        String line;
        IRegion lineInfo;
        if (region == null || textViewer == null) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return null;
        }
        int offset = region.getOffset();
        try {
            lineInfo = document.getLineInformationOfOffset(offset);
            line = document.get(lineInfo.getOffset(), lineInfo.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        IRegion detectedRegion = this.detectSubRegion(lineInfo, line);
        if (detectedRegion == null) {
            return null;
        }
        int detectedStart = detectedRegion.getOffset() - lineInfo.getOffset();
        String substring = line.substring(detectedStart, detectedStart + detectedRegion.getLength());
        String fileName = this.detectFileName(substring);
        if (fileName == null) {
            return null;
        }
        Selection selection = this.detectSelection(substring);
        return new IHyperlink[]{new EclipseCollabHyperlink(detectedRegion, fileName, selection)};
    }

    private Selection detectSelection(String linkString) {
        int beginIndex = linkString.indexOf(SHARE_FILE_HYPERLINK_SELECTION);
        if (beginIndex == -1) {
            return null;
        }
        int endIndex = linkString.indexOf(SHARE_FILE_HYPERLINK_END);
        if (endIndex == -1) {
            return null;
        }
        String selection = linkString.substring(beginIndex + SHARE_FILE_HYPERLINK_SELECTION.length(), endIndex);
        int dashIndex = selection.indexOf("-");
        if (dashIndex == -1) {
            return null;
        }
        try {
            int start = Integer.parseInt(selection.substring(0, dashIndex));
            int end = Integer.parseInt(selection.substring(dashIndex + 1));
            return new Selection(start, end);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private String detectFileName(String substring) {
        int startIndex = substring.indexOf("\"");
        if (startIndex == -1) {
            return null;
        }
        int endIndex = substring.indexOf("\"", startIndex + 1);
        if (endIndex == -1) {
            return null;
        }
        return substring.substring(startIndex + 1, endIndex);
    }

    protected IRegion detectSubRegion(IRegion lineInfo, String fromLine) {
        int startIndex = fromLine.indexOf(SHARE_FILE_HYPERLINK_START);
        if (startIndex == -1) {
            return null;
        }
        int endIndex = fromLine.indexOf(SHARE_FILE_HYPERLINK_END, startIndex);
        if (endIndex == -1) {
            return null;
        }
        return new Region(lineInfo.getOffset() + startIndex, endIndex - startIndex + SHARE_FILE_HYPERLINK_END.length());
    }

    public static String createDisplayStringForEditorOpen(String resourceName, EclipseCollabSharedObject.SharedMarker marker) {
        StringBuffer se = new StringBuffer(SHARE_FILE_HYPERLINK_START);
        se.append(resourceName).append("\"");
        if (marker != null) {
            int start = marker.getOffset();
            int length = marker.getLength();
            if (length > 0) {
                se.append(SHARE_FILE_HYPERLINK_SELECTION);
                se.append(start).append("-").append(start + length);
            }
        }
        se.append(SHARE_FILE_HYPERLINK_END);
        return se.toString();
    }

    class Selection {
        int start;
        int end;

        public Selection(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }
}

