/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.presence.ui.handlers;

import java.text.Collator;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.internal.presence.ui.Activator;
import org.eclipse.ecf.internal.presence.ui.Messages;
import org.eclipse.ecf.presence.IPresence;
import org.eclipse.ecf.presence.IPresenceContainerAdapter;
import org.eclipse.ecf.presence.roster.IRoster;
import org.eclipse.ecf.presence.roster.IRosterEntry;
import org.eclipse.ecf.presence.roster.IRosterGroup;
import org.eclipse.ecf.presence.roster.IRosterItem;
import org.eclipse.ecf.presence.roster.IRosterManager;
import org.eclipse.ecf.ui.SharedImages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class BrowseDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "org.eclipse.ecf.presence.ui.dialogs.BrowseDialog";
    private static final String SHOW_ONLINE_ONLY = "showOnlineOnly";
    private IContainer[] containers = null;
    private RosterItemLabelProvider rosterItemLabelProvider;
    private RosterItemDetailsLabelProvider rosterItemDetailsLabelProvider;
    private ToggleOnlineOnlyAction toggleOnlineOnlyAction;
    private OnlineOnlyViewerFilter onlineOnlyFilter = new OnlineOnlyViewerFilter();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public BrowseDialog(Shell shell, IContainer[] containers) {
        super(shell, false);
        this.containers = containers;
        this.setSelectionHistory(new RosterItemSelectionHistory());
        this.setTitle(Messages.BrowseDialog_title);
        this.setMessage(Messages.BrowseDialog_message);
        this.setImage(SharedImages.getImage((String)"IMG_COMMUNICATIONS"));
        this.rosterItemLabelProvider = new RosterItemLabelProvider();
        this.setListLabelProvider((ILabelProvider)this.rosterItemLabelProvider);
        this.rosterItemDetailsLabelProvider = new RosterItemDetailsLabelProvider();
        this.setDetailsLabelProvider((ILabelProvider)this.rosterItemDetailsLabelProvider);
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new RosterItemsFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        progressMonitor.beginTask(Messages.BrowseDialog_scanning, this.containers.length);
        int i = 0;
        while (i < this.containers.length) {
            IRosterManager manager;
            IPresenceContainerAdapter presenceContainer;
            IContainer container = this.containers[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.ecf.presence.IPresenceContainerAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((presenceContainer = (IPresenceContainerAdapter)container.getAdapter((Class)clazz)) != null && (manager = presenceContainer.getRosterManager()) != null) {
                Collection items = manager.getRoster().getItems();
                Iterator it = items.iterator();
                while (it.hasNext()) {
                    IRosterItem item = (IRosterItem)it.next();
                    this.addRosterItem(item, contentProvider, itemsFilter);
                }
            }
            progressMonitor.worked(1);
            ++i;
        }
        progressMonitor.done();
    }

    private void addRosterItem(IRosterItem item, FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter) {
        if (item instanceof IRosterGroup) {
            IRosterGroup group = (IRosterGroup)item;
            Iterator it = group.getEntries().iterator();
            while (it.hasNext()) {
                this.addRosterItem((IRosterItem)it.next(), contentProvider, itemsFilter);
            }
        }
        contentProvider.add((Object)item, itemsFilter);
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    public String getElementName(Object item) {
        IRosterItem rosterItem = (IRosterItem)item;
        return rosterItem.getName();
    }

    protected Comparator getItemsComparator() {
        return new RosterItemsComparator();
    }

    protected IStatus validateItem(Object item) {
        return new Status(0, "org.eclipse.ecf.presence.ui", 0, "", null);
    }

    protected void fillViewMenu(IMenuManager menuManager) {
        super.fillViewMenu(menuManager);
        this.toggleOnlineOnlyAction = new ToggleOnlineOnlyAction();
        menuManager.add((IAction)this.toggleOnlineOnlyAction);
    }

    protected void restoreDialog(IDialogSettings settings) {
        super.restoreDialog(settings);
        if (settings.get(SHOW_ONLINE_ONLY) != null) {
            boolean showOnlineOnly = settings.getBoolean(SHOW_ONLINE_ONLY);
            this.toggleOnlineOnlyAction.setChecked(showOnlineOnly);
        }
        this.addListFilter(this.onlineOnlyFilter);
        this.applyFilter();
    }

    protected void storeDialog(IDialogSettings settings) {
        super.storeDialog(settings);
        settings.put(SHOW_ONLINE_ONLY, this.toggleOnlineOnlyAction.isChecked());
    }

    protected IWorkbenchAdapter getAdapter(Object element) {
        IWorkbenchAdapter adapter = null;
        if (element instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz);
        }
        if (element != null && adapter == null) {
            IAdapterManager iAdapterManager = Platform.getAdapterManager();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (IWorkbenchAdapter)iAdapterManager.loadAdapter(element, clazz.getName());
        }
        return adapter;
    }

    private class OnlineOnlyViewerFilter
    extends ViewerFilter {
        private boolean online = true;

        private OnlineOnlyViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!(element instanceof IRosterEntry)) {
                return false;
            }
            IRosterEntry entry = (IRosterEntry)element;
            return !this.online || entry.getPresence() == null || IPresence.Type.UNAVAILABLE != entry.getPresence().getType();
        }

        public void setOnlineOnly(boolean show) {
            this.online = show;
        }
    }

    public class RosterItemDetailsLabelProvider
    extends LabelProvider {
        private Map imageTable = new HashMap(7);

        public Image getImage(Object element) {
            IRosterItem item = (IRosterItem)element;
            IRoster roster = item.getRoster();
            IWorkbenchAdapter adapter = BrowseDialog.this.getAdapter(roster);
            if (adapter == null) {
                return null;
            }
            ImageDescriptor descriptor = adapter.getImageDescriptor((Object)roster);
            if (descriptor == null) {
                return null;
            }
            Image image = (Image)this.imageTable.get(descriptor);
            if (image == null) {
                image = descriptor.createImage();
                this.imageTable.put(descriptor, image);
            }
            return image;
        }

        public String getText(Object element) {
            IRosterItem item = (IRosterItem)element;
            return item.getRoster().getName();
        }
    }

    public class RosterItemLabelProvider
    extends LabelProvider {
        private Map imageTable = new HashMap(7);

        public Image getImage(Object element) {
            IWorkbenchAdapter adapter = BrowseDialog.this.getAdapter(element);
            if (adapter == null) {
                return null;
            }
            ImageDescriptor descriptor = adapter.getImageDescriptor(element);
            if (descriptor == null) {
                return null;
            }
            Image image = (Image)this.imageTable.get(descriptor);
            if (image == null) {
                image = descriptor.createImage();
                this.imageTable.put(descriptor, image);
            }
            return image;
        }

        public String getText(Object element) {
            IRosterItem item = (IRosterItem)element;
            if (item == null) {
                return "";
            }
            IRoster roster = item.getRoster();
            return roster != null ? String.valueOf(item.getName()) + " - " + roster.getName() : "";
        }

        public void dispose() {
            if (this.imageTable != null) {
                Iterator i = this.imageTable.values().iterator();
                while (i.hasNext()) {
                    ((Image)i.next()).dispose();
                }
                this.imageTable = null;
            }
        }
    }

    private class RosterItemSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        private RosterItemSelectionHistory() {
        }

        protected Object restoreItemFromMemento(IMemento memento) {
            return null;
        }

        protected void storeItemToMemento(Object item, IMemento memento) {
        }
    }

    private class RosterItemsComparator
    implements Comparator {
        private RosterItemsComparator() {
        }

        public int compare(Object o1, Object o2) {
            Collator collator = Collator.getInstance();
            IRosterItem item1 = (IRosterItem)o1;
            IRosterItem item2 = (IRosterItem)o2;
            String s1 = item1.getName();
            String s2 = item2.getName();
            int comparability = collator.compare(s1, s2);
            return comparability;
        }
    }

    private class RosterItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private RosterItemsFilter() {
            super((FilteredItemsSelectionDialog)BrowseDialog.this);
        }

        public boolean isConsistentItem(Object item) {
            return false;
        }

        public boolean matchItem(Object item) {
            if (!(item instanceof IRosterEntry)) {
                return false;
            }
            IRosterEntry rosterItem = (IRosterEntry)item;
            return this.matches(rosterItem.getName());
        }
    }

    private class ToggleOnlineOnlyAction
    extends Action {
        public ToggleOnlineOnlyAction() {
            super(Messages.ToggleOnlineOnlyAction_title, 2);
            this.setChecked(true);
        }

        public void run() {
            BrowseDialog.this.onlineOnlyFilter.setOnlineOnly(this.isChecked());
            BrowseDialog.this.scheduleRefresh();
        }
    }
}

