/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.protocol.msn;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import org.eclipse.ecf.protocol.msn.MsnClient;

abstract class Session {
    final MsnClient client;
    ArrayList listeners;
    private final byte[] buffer = new byte[1024];
    private Socket socket;
    private InputStream is;
    private OutputStream os;
    private long transactionID = 0L;
    private IdleThread idleThread;
    private boolean closed = false;

    Session(MsnClient client) {
        this.client = client;
    }

    Session(String host, MsnClient client) throws IOException {
        this.client = client;
        this.openSocket(host);
    }

    Session(String ip, int port, MsnClient client) throws IOException {
        this.client = client;
        this.openSocket(ip, port);
    }

    final void openSocket(String host) throws IOException {
        this.closed = false;
        int index = host.indexOf(58);
        this.openSocket(host.substring(0, index), Integer.parseInt(host.substring(index + 1)));
    }

    final void openSocket(String ip, int port) throws IOException {
        this.closed = false;
        this.socket = new Socket(ip, port);
        this.is = this.socket.getInputStream();
        this.os = this.socket.getOutputStream();
    }

    final InputStream getInputStream() {
        return this.is;
    }

    String read() throws IOException {
        int read = this.is.read(this.buffer);
        if (read < 1) {
            return null;
        }
        return new String(this.buffer, 0, read, "UTF-8");
    }

    private final void write(String input, boolean newline) throws IOException {
        byte[] bytes = newline ? (String.valueOf(input) + "\r\n").getBytes("UTF-8") : input.getBytes("UTF-8");
        this.os.write(bytes);
        this.os.flush();
    }

    final void write(String input) throws IOException {
        this.write(input, true);
    }

    final void write(String command, String parameters, boolean newline) throws IOException {
        ++this.transactionID;
        this.write(String.valueOf(command) + ' ' + this.transactionID + ' ' + parameters, newline);
    }

    final void write(String command, String parameters) throws IOException {
        this.write(command, parameters, true);
    }

    void close() {
        this.closed = true;
        if (this.idleThread != null) {
            this.idleThread.interrupt();
            this.idleThread = null;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {}
            this.socket = null;
        }
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (Exception exception) {}
            this.is = null;
        }
        if (this.os != null) {
            try {
                this.os.close();
            }
            catch (Exception exception) {}
            this.os = null;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    final void idle() {
        if (this.idleThread == null || !this.idleThread.isAlive()) {
            this.idleThread = new IdleThread();
            this.idleThread.start();
        }
    }

    final boolean isClosed() {
        return this.closed;
    }

    private class IdleThread
    extends Thread {
        private IdleThread() {
        }

        public void run() {
            while (!this.isInterrupted()) {
                try {
                    IdleThread.sleep(50L);
                    Session.this.read();
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                catch (IOException iOException) {
                    return;
                }
                catch (RuntimeException e) {
                    System.out.println("Exception occurred: ");
                    e.printStackTrace();
                }
            }
        }
    }
}

