/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.impl.PlatformAbstraction;
import ch.ethz.iks.slp.impl.SLPCore;
import ch.ethz.iks.slp.impl.filter.Filter;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class OSGiPlatformAbstraction
implements PlatformAbstraction,
ServiceListener {
    private final BundleContext context;
    private LogService log = new NullPatternLogService();
    static /* synthetic */ Class class$0;

    OSGiPlatformAbstraction(BundleContext context) throws InvalidSyntaxException {
        ServiceReference sref;
        this.context = context;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.log.LogService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((sref = context.getServiceReference(clazz.getName())) != null) {
            this.log = (LogService)context.getService(sref);
        }
        StringBuffer stringBuffer = new StringBuffer("(objectClass=");
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.osgi.service.log.LogService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        context.addServiceListener((ServiceListener)this, stringBuffer.append(clazz2.getName()).append(")").toString());
        this.logDebug("jSLP OSGi started.");
    }

    public Filter createFilter(String filterString) {
        try {
            final org.osgi.framework.Filter filter = this.context.createFilter(filterString);
            return new Filter(){

                public boolean match(Dictionary values) {
                    return filter.match(values);
                }

                public String toString() {
                    return filter.toString();
                }
            };
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void logDebug(String message) {
        if (SLPCore.CONFIG.getDebugEnabled()) {
            this.log.log(4, message);
        }
    }

    public void logDebug(String message, Throwable exception) {
        if (SLPCore.CONFIG.getDebugEnabled()) {
            this.log.log(4, message, exception);
        }
    }

    public void logError(String message) {
        this.log.log(1, message);
    }

    public void logError(String message, Throwable exception) {
        this.log.log(1, message, exception);
    }

    public void logTraceMessage(String message) {
        if (SLPCore.CONFIG.getTraceMessage()) {
            this.log.log(3, message);
        }
    }

    public void logTraceDrop(String message) {
        if (SLPCore.CONFIG.getTraceDrop()) {
            this.log.log(3, message);
        }
    }

    public void logTraceReg(String message) {
        if (SLPCore.CONFIG.getTraceReg()) {
            this.log.log(3, message);
        }
    }

    public void logWarning(String message) {
        this.log.log(2, message);
    }

    public void logWarning(String message, Throwable exception) {
        this.log.log(2, message, exception);
    }

    public void serviceChanged(ServiceEvent event) {
        switch (event.getType()) {
            case 1: {
                this.log = (LogService)this.context.getService(event.getServiceReference());
                return;
            }
            case 4: {
                this.log = new NullPatternLogService();
            }
        }
    }

    private class NullPatternLogService
    implements LogService {
        private NullPatternLogService() {
        }

        public void log(int level, String message) {
            if (level == 1 || level == 2) {
                System.err.println(message);
            } else {
                System.out.println(message);
            }
        }

        public void log(int level, String message, Throwable exception) {
            this.log(level, String.valueOf(message) + exception.getMessage());
        }

        public void log(ServiceReference sr, int level, String message) {
            this.log(null, level, message);
        }

        public void log(ServiceReference sr, int level, String message, Throwable t) {
            this.log(null, level, message, t);
        }
    }
}

