/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.discovery.ui;

import java.util.ArrayList;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.internal.discovery.ui.ViewTreeObject;

public class ViewTreeService
extends ViewTreeObject {
    private final ArrayList children;
    private final IServiceID id;
    private final IServiceInfo serviceInfo;

    public ViewTreeService(IServiceID id, String name, IServiceInfo svcInfo) {
        super(name);
        this.id = id;
        this.children = new ArrayList();
        this.serviceInfo = svcInfo;
    }

    public IServiceInfo getServiceInfo() {
        return this.serviceInfo;
    }

    public IServiceID getID() {
        return this.id;
    }

    public void addChild(ViewTreeObject child) {
        this.children.add(child);
        child.setParent(this);
    }

    public void removeChild(ViewTreeObject child) {
        this.children.remove(child);
        child.setParent(null);
    }

    public ViewTreeObject[] getChildren() {
        return this.children.toArray(new ViewTreeObject[this.children.size()]);
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public void clearChildren() {
        this.children.clear();
    }
}

