/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.examples.updatesite;

import java.net.URL;
import java.security.InvalidParameterException;
import java.util.Map;
import javax.naming.ServiceUnavailableException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.discovery.IDiscoveryContainerAdapter;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceProperties;
import org.eclipse.ecf.discovery.ServiceInfo;
import org.eclipse.ecf.discovery.ServiceProperties;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.discovery.identity.ServiceIDFactory;
import org.eclipse.ecf.internal.examples.updatesite.Activator;
import org.eclipse.ecf.internal.examples.updatesite.UpdateSiteContext;
import org.eclipse.ecf.internal.examples.updatesite.UpdateSiteProperties;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

public class DiscoverableServer
implements IApplication {
    static final String DEFAULT_UPDATE_SITE_SERVICE_TYPE = "updatesite";
    private String username;
    protected String serviceType;
    private String serviceName;
    private String servicePath;
    private String updateSiteName;
    private URL updateSiteLocation;
    private IDiscoveryContainerAdapter discovery;
    private IServiceInfo serviceInfo;
    private boolean done = false;

    private String getCompleteServiceType() {
        return "_" + this.serviceType + "._http._tcp.local.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object start(IApplicationContext ctxt) throws Exception {
        Map args = ctxt.getArguments();
        this.initializeFromArguments((String[])args.get("application.args"));
        ContainerFactory.getDefault().getDescriptions();
        this.discovery = Activator.getDefault().waitForDiscoveryService(5000);
        if (this.discovery == null) {
            throw new ServiceUnavailableException("Discovery service not found.");
        }
        IServiceID serviceID = ServiceIDFactory.getDefault().createServiceID(this.discovery.getServicesNamespace(), this.getCompleteServiceType(), this.serviceName);
        this.serviceInfo = new ServiceInfo(this.serviceType, null, this.getServicePort(), serviceID, (IServiceProperties)new ServiceProperties(new UpdateSiteProperties(this.serviceName, this.servicePath).toProperties()));
        HttpService httpService = Activator.getDefault().waitForHttpService(2000);
        if (httpService == null) {
            throw new ServiceUnavailableException("Http service not found.");
        }
        httpService.registerResources(this.servicePath, "/", (HttpContext)new UpdateSiteContext(httpService.createDefaultHttpContext(), this.updateSiteLocation));
        System.out.println("http server\n\tupdateSiteLocation=" + this.updateSiteLocation + "\n\turl=" + this.serviceInfo.getLocation() + this.servicePath);
        this.discovery.registerService(this.serviceInfo);
        System.out.println("discovery publish\n\tserviceName=" + serviceID.getServiceName() + "\n\tserviceTypeID=" + serviceID.getServiceTypeID());
        DiscoverableServer discoverableServer = this;
        synchronized (discoverableServer) {
            while (!this.done) {
                this.wait();
            }
        }
        return new Integer(0);
    }

    private int getServicePort() {
        String osgiPort = System.getProperty("org.osgi.service.http.port");
        Integer servicePort = new Integer(80);
        if (osgiPort != null) {
            servicePort = Integer.valueOf(osgiPort);
        }
        return servicePort;
    }

    private void initializeFromArguments(String[] args) throws Exception {
        if (args == null) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            if (!args[i].startsWith("-")) {
                String arg;
                if (!(arg = args[i++]).endsWith("/")) {
                    arg = String.valueOf(arg) + "/";
                }
                this.updateSiteLocation = new URL(arg);
            } else if (args[i - 1].equalsIgnoreCase("-username")) {
                this.username = args[++i];
            } else if (args[i - 1].equalsIgnoreCase("-serviceType")) {
                this.serviceType = args[++i];
            } else if (args[i - 1].equalsIgnoreCase("-serviceName")) {
                this.serviceName = args[++i];
            } else if (args[i - 1].equalsIgnoreCase("-servicePath")) {
                this.servicePath = args[++i];
            } else if (args[i - 1].equalsIgnoreCase("-updateSiteName")) {
                this.updateSiteName = args[++i];
            }
            ++i;
        }
        if (this.updateSiteLocation == null) {
            this.usage();
            throw new InvalidParameterException("updateSiteDirectoryURL required");
        }
        this.username = this.username == null ? System.getProperty("user.name") : this.username;
        this.serviceType = this.serviceType == null ? DEFAULT_UPDATE_SITE_SERVICE_TYPE : this.serviceType;
        this.serviceName = this.serviceName == null ? String.valueOf(this.username) + " update site" : this.serviceName;
        this.servicePath = this.servicePath == null ? "/update" : this.servicePath;
        this.updateSiteName = this.updateSiteName == null ? System.getProperty("updateSiteName", String.valueOf(this.username) + " update site") : this.updateSiteName;
    }

    private void usage() {
        System.out.println("usage: eclipse -console [options] -application org.eclipse.ecf.examples.updatesite.server.updateSiteServer <updateSiteDirectoryURL>");
        System.out.println("   options: [-username <username>] default=<current user>");
        System.out.println("            [-serviceType <servicetype>] default=updatesite");
        System.out.println("            [-serviceName <name>] default=<current user> update site");
        System.out.println("            [-servicePath <path>] default=/update");
        System.out.println("            [-updateSiteName <name>] default=<current user> update site");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.discovery != null && this.serviceInfo != null) {
            try {
                this.discovery.unregisterService(this.serviceInfo);
            }
            catch (ECFException e) {
                e.printStackTrace();
            }
            this.discovery = null;
            this.serviceInfo = null;
        }
        DiscoverableServer discoverableServer = this;
        synchronized (discoverableServer) {
            this.done = true;
            this.notifyAll();
        }
    }
}

