/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.server.generic.app;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.security.IConnectHandlerPolicy;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainerConfig;
import org.eclipse.ecf.provider.generic.SOContainerConfig;
import org.eclipse.ecf.provider.generic.TCPServerSOContainer;
import org.eclipse.ecf.provider.generic.TCPServerSOContainerGroup;
import org.eclipse.ecf.server.generic.app.Connector;
import org.eclipse.ecf.server.generic.app.NamedGroup;
import org.eclipse.ecf.server.generic.app.ServerConfigParser;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;

public class GenericServer
implements IApplication {
    private static Map serverGroups = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object start(IApplicationContext context) throws Exception {
        try {
            block18: {
                String[] args = this.mungeArguments((String[])context.getArguments().get("application.args"));
                if (args.length == 1 && (args[0].equals("-help") || args[0].equals("-h"))) {
                    this.usage();
                    return IApplication.EXIT_OK;
                }
                if (args.length == 2 && (args[0].equals("-config") || args[0].equals("-c"))) {
                    FileInputStream fis = null;
                    try {
                        fis = new FileInputStream(args[1]);
                        this.setupServerFromConfig(new ServerConfigParser().load(fis));
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        if (fis == null) throw throwable;
                        fis.close();
                        throw throwable;
                    }
                    {
                        Object var4_8 = null;
                        if (fis != null) {
                            fis.close();
                        }
                        break block18;
                    }
                }
                String hostname = "localhost";
                int port = 3282;
                String name = "/server";
                int keepAlive = 30000;
                switch (args.length) {
                    case 4: {
                        keepAlive = Integer.parseInt(args[3]);
                    }
                    case 3: {
                        hostname = args[2];
                    }
                    case 2: {
                        name = args[1];
                        if (!name.startsWith("/")) {
                            name = "/" + name;
                        }
                    }
                    case 1: {
                        port = Integer.parseInt(args[0]);
                        break;
                    }
                }
                this.setupServerFromParameters(hostname, port, name, keepAlive);
            }
            GenericServer genericServer = this;
            synchronized (genericServer) {
                this.wait();
                return IApplication.EXIT_OK;
            }
        }
        catch (Exception e) {
            this.stop();
            throw e;
        }
    }

    private void usage() {
        System.out.println("Usage: eclipse.exe -application " + this.getClass().getName() + "[port [groupname [hostname [keepAlive]]]] | [-config|-c <configfile.xml>]");
        System.out.println("   Examples: eclipse -application org.eclipse.ecf.provider.GenericServer");
        System.out.println("             eclipse -application org.eclipse.ecf.provider.GenericServer 7777");
        System.out.println("             eclipse -application org.eclipse.ecf.provider.GenericServer 7777 mygroup foobarhost.wherever.com 35000");
        System.out.println("             eclipse -application org.eclipse.ecf.provider.GenericServer -c myconfig.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupServerFromParameters(String hostname, int port, String name, int keepAlive) throws IOException, IDCreateException {
        String hostnamePort = String.valueOf(hostname) + ":" + port;
        Map map = serverGroups;
        synchronized (map) {
            TCPServerSOContainerGroup serverGroup = (TCPServerSOContainerGroup)serverGroups.get(hostnamePort);
            if (serverGroup == null) {
                System.out.println("Putting server " + hostnamePort + " on the air...");
                try {
                    serverGroup = new TCPServerSOContainerGroup(hostname, port);
                    String url = "ecftcp://" + hostnamePort + name;
                    TCPServerSOContainer container = GenericServer.createServerContainer(url, serverGroup, name, keepAlive);
                    this.configureServerContainer(container);
                    serverGroup.putOnTheAir();
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                    throw e;
                }
                catch (IDCreateException e) {
                    e.printStackTrace(System.err);
                    throw e;
                }
                serverGroups.put(hostnamePort, serverGroup);
                System.out.println("GenericServerContainer " + hostnamePort + " on the air.");
            } else {
                System.out.println("GenericServerContainer " + hostnamePort + " already on the air.  No changes made.");
            }
        }
    }

    protected void configureServerContainer(TCPServerSOContainer container) {
        container.setConnectPolicy((IConnectHandlerPolicy)new JoinListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupServerFromConfig(List connectors) throws IOException, IDCreateException {
        Iterator i = connectors.iterator();
        while (i.hasNext()) {
            Connector connector = (Connector)i.next();
            String hostname = connector.getHostname();
            int port = connector.getPort();
            String hostnamePort = String.valueOf(hostname) + ":" + port;
            TCPServerSOContainerGroup serverGroup = null;
            Map map = serverGroups;
            synchronized (map) {
                serverGroup = (TCPServerSOContainerGroup)serverGroups.get(hostnamePort);
                if (serverGroup == null) {
                    System.out.println("Putting server " + hostnamePort + " on the air...");
                    serverGroup = new TCPServerSOContainerGroup(hostname, port);
                    List groups = connector.getGroups();
                    Iterator g = groups.iterator();
                    while (g.hasNext()) {
                        NamedGroup group = (NamedGroup)g.next();
                        TCPServerSOContainer container = GenericServer.createServerContainer(group.getIDForGroup(), serverGroup, group.getName(), connector.getTimeout());
                        this.configureServerContainer(container);
                    }
                    serverGroup.putOnTheAir();
                    serverGroups.put(hostnamePort, serverGroup);
                    System.out.println("GenericServerContainer " + hostnamePort + " on the air.");
                } else {
                    System.out.println("GenericServerContainer " + hostnamePort + " already on the air.  No changes made.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = serverGroups;
        synchronized (object) {
            Iterator i = serverGroups.keySet().iterator();
            while (i.hasNext()) {
                TCPServerSOContainerGroup serverGroup = (TCPServerSOContainerGroup)serverGroups.get(i.next());
                serverGroup.takeOffTheAir();
                System.out.println("Taking " + serverGroup.getName() + ":" + serverGroup.getPort() + " off the air");
                Iterator iter = serverGroup.elements();
                while (iter.hasNext()) {
                    TCPServerSOContainer container = (TCPServerSOContainer)iter.next();
                    container.dispose();
                }
            }
        }
        serverGroups.clear();
        object = this;
        synchronized (object) {
            this.notify();
        }
    }

    private String[] mungeArguments(String[] originalArgs) {
        if (originalArgs == null) {
            return new String[0];
        }
        ArrayList<String> l = new ArrayList<String>();
        int i = 0;
        while (i < originalArgs.length) {
            if (!originalArgs[i].equals("-pdelaunch")) {
                l.add(originalArgs[i]);
            }
            ++i;
        }
        return l.toArray(new String[0]);
    }

    private static TCPServerSOContainer createServerContainer(String id, TCPServerSOContainerGroup group, String path, int keepAlive) throws IDCreateException {
        System.out.println("  Creating container with id=" + id + " keepAlive=" + keepAlive);
        ID newServerID = IDFactory.getDefault().createStringID(id);
        SOContainerConfig config = new SOContainerConfig(newServerID);
        return new TCPServerSOContainer((ISharedObjectContainerConfig)config, group, path, keepAlive);
    }

    static class JoinListener
    implements IConnectHandlerPolicy {
        JoinListener() {
        }

        public PermissionCollection checkConnect(Object addr, ID fromID, ID targetID, String targetGroup, Object joinData) throws Exception {
            System.out.println("CLIENT CONNECT: fromAddress=" + addr + ";fromID=" + fromID + ";targetGroup=" + targetGroup);
            return null;
        }

        public void refresh() {
        }
    }
}

