/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.example.clients.applications;

import java.util.HashMap;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.example.clients.IMessageReceiver;
import org.eclipse.ecf.example.clients.XMPPChatClient;
import org.eclipse.ecf.presence.im.IChatMessage;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;

public class ChatRobotApplication
implements IApplication,
IMessageReceiver {
    public static final int WAIT_TIME = 10000;
    public static final int WAIT_COUNT = 10;
    private boolean running = false;
    private String userName;
    private XMPPChatClient client;

    public Object start(IApplicationContext context) throws Exception {
        Object[] args = context.getArguments().values().toArray();
        while (args[0] instanceof Object[]) {
            args = (Object[])args[0];
        }
        Object[] arguments = args;
        int l = arguments.length;
        if (arguments[l - 1] instanceof String && arguments[l - 2] instanceof String && arguments[l - 3] instanceof String && arguments[l - 4] instanceof String) {
            this.userName = (String)arguments[l - 4];
            String hostName = (String)arguments[l - 3];
            String password = (String)arguments[l - 2];
            String targetName = (String)arguments[l - 1];
            this.runRobot(hostName, password, targetName);
            return new Integer(0);
        }
        System.out.println("Usage: pass in four arguments (username, hostname, password, targetIMUser)");
        return new Integer(-1);
    }

    public void stop() {
    }

    private void runRobot(String hostName, String password, String targetIMUser) throws ECFException, Exception, InterruptedException {
        this.client = new XMPPChatClient(this);
        this.client.setupContainer();
        this.client.setupPresence();
        String connectTarget = String.valueOf(this.userName) + "@" + hostName;
        this.client.doConnect(connectTarget, password);
        System.out.println("ECF chat robot (" + connectTarget + ")");
        this.client.sendChat(targetIMUser, "Hi, I'm an ECF chat robot.");
        this.running = true;
        int count = 0;
        while (this.running && count++ < 10) {
            this.wait(10000L);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("message", "howdy");
            this.client.sendProperties(targetIMUser, properties);
        }
    }

    public synchronized void handleMessage(IChatMessage chatMessage) {
        System.out.println("handleMessage(" + chatMessage + ")");
    }
}

