/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.discovery;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceProperties;
import org.eclipse.ecf.internal.osgi.services.discovery.ServicePropertyUtils;
import org.osgi.service.discovery.ServiceEndpointDescription;

public class ServiceEndpointDescriptionImpl
implements ServiceEndpointDescription {
    private final IServiceInfo serviceInfo;

    public ServiceEndpointDescriptionImpl(ID localContainerID, IServiceInfo serviceInfo) {
        this.serviceInfo = serviceInfo;
        this.serviceInfo.getServiceProperties().setProperty("ecf.containerid", (Object)localContainerID);
    }

    public String getEndpointID() {
        return ServicePropertyUtils.getStringProperty(this.serviceInfo.getServiceProperties(), "osgi.remote.endpoint.id");
    }

    public String getEndpointInterfaceName(String interfaceName) {
        if (interfaceName == null) {
            return null;
        }
        String intfNames = this.serviceInfo.getServiceProperties().getPropertyString("osgi.remote.endpoint.interface");
        if (intfNames == null) {
            return null;
        }
        Collection c = ServicePropertyUtils.createCollectionFromString(intfNames);
        if (c == null) {
            return null;
        }
        Iterator i = c.iterator();
        while (i.hasNext()) {
            String intfName = (String)i.next();
            if (intfName == null || !intfName.startsWith(interfaceName)) continue;
            return intfName.substring(intfName.length() + ":".length()).trim();
        }
        return null;
    }

    public URL getLocation() {
        String urlExternalForm = ServicePropertyUtils.getStringProperty(this.serviceInfo.getServiceProperties(), "osgi.remote.endpoint.location");
        if (urlExternalForm == null) {
            return null;
        }
        URL url = null;
        try {
            url = new URL(urlExternalForm);
        }
        catch (MalformedURLException malformedURLException) {}
        return url;
    }

    public Map getProperties() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        IServiceProperties serviceProperties = this.serviceInfo.getServiceProperties();
        if (serviceProperties != null) {
            Enumeration e = serviceProperties.getPropertyNames();
            while (e.hasMoreElements()) {
                String propName = (String)e.nextElement();
                Object val = serviceProperties.getProperty(propName);
                result.put(propName, val);
            }
        }
        return result;
    }

    public Object getProperty(String key) {
        IServiceProperties serviceProperties = this.serviceInfo.getServiceProperties();
        if (key == null) {
            return null;
        }
        return serviceProperties.getProperty(key);
    }

    public Collection getPropertyKeys() {
        IServiceProperties serviceProperties = this.serviceInfo.getServiceProperties();
        ArrayList<String> result = new ArrayList<String>();
        Enumeration e = serviceProperties.getPropertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            result.add(name);
        }
        return result;
    }

    public Collection getProvidedInterfaces() {
        String providedInterfacesStr = this.serviceInfo.getServiceProperties().getPropertyString("service.interface");
        return ServicePropertyUtils.createCollectionFromString(providedInterfacesStr);
    }

    public String getVersion(String interfaceName) {
        String intfNames = this.serviceInfo.getServiceProperties().getPropertyString("service.interface.version");
        if (intfNames == null) {
            return null;
        }
        Collection c = ServicePropertyUtils.createCollectionFromString(intfNames);
        if (c == null) {
            return null;
        }
        Iterator i = c.iterator();
        while (i.hasNext()) {
            String intfName = (String)i.next();
            if (intfName == null || !intfName.startsWith(interfaceName)) continue;
            return intfName.substring(intfName.length() + ":".length()).trim();
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ServiceEndpointDescriptionImpl[");
        sb.append("providedinterfaces=").append(this.getProvidedInterfaces());
        sb.append(";location=").append(this.getLocation());
        sb.append(";props=").append(this.getProperties()).append("]");
        return sb.toString();
    }
}

