/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.distribution;

import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.internal.osgi.services.distribution.DistributionProviderImpl;
import org.eclipse.ecf.internal.osgi.services.distribution.ECFEventHookImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.ecf.osgi.services.distribution";
    private static Activator plugin;
    private BundleContext context;
    private ServiceRegistration eventHookRegistration;
    private ServiceRegistration distributionProviderRegistration;
    private DistributionProviderImpl distributionProvider;
    private ServiceTracker containerManagerTracker;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static Activator getDefault() {
        return plugin;
    }

    public BundleContext getContext() {
        return this.context;
    }

    public void start(BundleContext ctxt) throws Exception {
        plugin = this;
        this.context = ctxt;
        this.distributionProvider = new DistributionProviderImpl();
        this.addServiceRegistryHooks();
        this.addDistributionProvider();
    }

    private void addServiceRegistryHooks() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.framework.hooks.service.EventHook");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.eventHookRegistration = this.context.registerService(clazz.getName(), (Object)new ECFEventHookImpl(this.distributionProvider), null);
    }

    private void addDistributionProvider() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.osgi.service.distribution.DistributionProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.distributionProviderRegistration = this.context.registerService(clazz.getName(), (Object)this.distributionProvider, null);
    }

    private void removeServiceRegistryHooks() {
        if (this.eventHookRegistration != null) {
            this.eventHookRegistration.unregister();
            this.eventHookRegistration = null;
        }
    }

    private void removeDistributionProvider() {
        if (this.distributionProviderRegistration != null) {
            this.distributionProviderRegistration.unregister();
            this.distributionProviderRegistration = null;
        }
    }

    public void stop(BundleContext ctxt) throws Exception {
        this.removeDistributionProvider();
        this.removeServiceRegistryHooks();
        if (this.containerManagerTracker != null) {
            this.containerManagerTracker.close();
            this.containerManagerTracker = null;
        }
        this.distributionProvider = null;
        this.context = null;
        plugin = null;
    }

    public IContainerManager getContainerManager() {
        if (this.containerManagerTracker == null) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.ecf.core.IContainerManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.containerManagerTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.containerManagerTracker.open();
        }
        return (IContainerManager)this.containerManagerTracker.getService();
    }
}

