/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.distribution;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.internal.osgi.services.discovery.Activator;
import org.osgi.framework.ServiceReference;
import org.osgi.service.distribution.DistributionProvider;

public class DistributionProviderImpl
implements DistributionProvider {
    Map exposedServices = Collections.synchronizedMap(new HashMap());
    Map remoteServices = Collections.synchronizedMap(new HashMap());

    Long getServiceId(ServiceReference sr) {
        return (Long)sr.getProperty("service.id");
    }

    ServiceReference addExposedService(ServiceReference sr) {
        if (sr == null) {
            return null;
        }
        return this.exposedServices.put(this.getServiceId(sr), sr);
    }

    ServiceReference addRemoteService(ServiceReference sr) {
        if (sr == null) {
            return null;
        }
        return this.remoteServices.put(this.getServiceId(sr), sr);
    }

    ServiceReference removeExposedService(Long sid) {
        if (sid == null) {
            return null;
        }
        return (ServiceReference)this.exposedServices.remove(sid);
    }

    ServiceReference removeExposedService(ServiceReference sr) {
        return this.removeExposedService(this.getServiceId(sr));
    }

    ServiceReference removeRemoteService(Long sid) {
        if (sid == null) {
            return null;
        }
        return (ServiceReference)this.remoteServices.remove(sid);
    }

    ServiceReference removeRemoteService(ServiceReference sr) {
        return this.removeRemoteService(this.getServiceId(sr));
    }

    boolean containsExposedService(Long sid) {
        if (sid == null) {
            return false;
        }
        return this.exposedServices.containsKey(sid);
    }

    boolean containsRemoteService(Long sid) {
        if (sid == null) {
            return false;
        }
        return this.remoteServices.containsKey(sid);
    }

    ServiceReference getExposedService(Long sid) {
        if (sid == null) {
            return null;
        }
        return (ServiceReference)this.exposedServices.get(sid);
    }

    ServiceReference getRemoteService(Long sid) {
        if (sid == null) {
            return null;
        }
        return (ServiceReference)this.remoteServices.get(sid);
    }

    public ServiceReference[] getExposedServices() {
        return this.exposedServices.entrySet().toArray(new ServiceReference[0]);
    }

    public Map getPublicationProperties(ServiceReference sr) {
        HashMap result = new HashMap();
        if (sr == null) {
            return result;
        }
        ServiceReference publishedService = this.getPublishedService(sr);
        if (publishedService == null) {
            return result;
        }
        return this.getPropertyMap(result, publishedService);
    }

    private ServiceReference getPublishedService(ServiceReference sr) {
        List<ServiceReference> l = Arrays.asList(this.getPublishedServices());
        if (l.contains(sr)) {
            return sr;
        }
        return null;
    }

    private Map getPropertyMap(Map result, ServiceReference sr) {
        String[] propKeys = sr.getPropertyKeys();
        if (propKeys != null) {
            int i = 0;
            while (i < propKeys.length) {
                result.put(propKeys[i], sr.getProperty(propKeys[i]));
                ++i;
            }
        }
        return result;
    }

    public ServiceReference[] getPublishedServices() {
        return Activator.getDefault().getServicePublicationHandler().getPublishedServices();
    }

    public ServiceReference[] getRemoteServices() {
        return this.remoteServices.entrySet().toArray(new ServiceReference[0]);
    }
}

