/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.distribution;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.osgi.services.distribution.AbstractEventHookImpl;
import org.eclipse.ecf.internal.osgi.services.distribution.Activator;
import org.eclipse.ecf.internal.osgi.services.distribution.DistributionProviderImpl;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.IRemoteServiceRegistration;
import org.osgi.framework.ServiceReference;

public class ECFEventHookImpl
extends AbstractEventHookImpl {
    static /* synthetic */ Class class$0;

    public ECFEventHookImpl(DistributionProviderImpl distributionProvider) {
        super(distributionProvider);
    }

    protected void registerRemoteService(ServiceReference serviceReference, String[] remoteInterfaces, String[] remoteConfigurationType) {
        if (remoteConfigurationType == null || remoteConfigurationType.length == 0) {
            this.trace("registerRemoteService", "remoteConfigurationType is null or empty so does not match ECF remote configuration type");
            return;
        }
        if (!remoteConfigurationType[0].equals("ecf")) {
            this.trace("registerRemoteService", "remoteConfigurationType not ECF type");
            return;
        }
        Map ecfConfiguration = this.parseECFConfigurationType(remoteConfigurationType);
        IRemoteServiceContainerAdapter[] rscas = this.findRemoteServiceContainerAdapters(serviceReference, ecfConfiguration);
        if (rscas == null) {
            this.trace("registerRemoteService", "No remote service container adapters found for serviceReference=" + serviceReference + " and configuration=" + ecfConfiguration);
            return;
        }
        this.registerRemoteService(rscas, remoteInterfaces, serviceReference);
    }

    private Map parseECFConfigurationType(String[] remoteConfigurationType) {
        HashMap results = new HashMap();
        return results;
    }

    protected void registerRemoteService(IRemoteServiceContainerAdapter[] rscas, String[] remoteInterfaces, ServiceReference sr) {
        int i = 0;
        while (i < rscas.length) {
            IRemoteServiceRegistration remoteRegistration = rscas[i].registerRemoteService(remoteInterfaces, this.getService(sr), this.createPropertiesForRemoteService(rscas[i], remoteInterfaces, sr));
            this.trace("registerRemoteService", "REGISTERED REMOTE SERVICE serviceReference=" + sr + " remoteRegistration=" + remoteRegistration);
            this.fireRemoteServiceRegistered(sr, remoteRegistration);
            ++i;
        }
    }

    protected Dictionary createPropertiesForRemoteService(IRemoteServiceContainerAdapter iRemoteServiceContainerAdapter, String[] remotes, ServiceReference sr) {
        String[] propKeys = sr.getPropertyKeys();
        Properties newProps = new Properties();
        int i = 0;
        while (i < propKeys.length) {
            newProps.put(propKeys[i], sr.getProperty(propKeys[i]));
            ++i;
        }
        return newProps;
    }

    protected IRemoteServiceContainerAdapter[] findRemoteServiceContainerAdapters(ServiceReference serviceReference, Map ecfConfiguration) {
        IContainerManager containerManager = Activator.getDefault().getContainerManager();
        return containerManager != null ? this.getRSCAsFromContainers(containerManager.getAllContainers(), serviceReference, ecfConfiguration) : null;
    }

    private IRemoteServiceContainerAdapter[] getRSCAsFromContainers(IContainer[] containers, ServiceReference serviceReference, Map ecfConfiguration) {
        if (containers == null) {
            return null;
        }
        ArrayList<IRemoteServiceContainerAdapter> rscas = new ArrayList<IRemoteServiceContainerAdapter>();
        int i = 0;
        while (i < containers.length) {
            IRemoteServiceContainerAdapter rsca;
            IContainer iContainer = containers[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((rsca = (IRemoteServiceContainerAdapter)iContainer.getAdapter((Class)clazz)) == null) {
                Trace.trace((String)"org.eclipse.ecf.osgi.services.distribution", (String)"org.eclipse.ecf.osgi.services.distribution/debug", this.getClass(), (String)"getRCSAsFromContainers", (String)("Container=" + containers[i] + " not an IRemoteServiceContainerAdapter. Excluding rsca=" + rsca + " from remote registration"));
            } else if (this.includeContainer(containers[i], rsca, serviceReference, ecfConfiguration)) {
                rscas.add(rsca);
            }
            ++i;
        }
        return rscas.toArray(new IRemoteServiceContainerAdapter[0]);
    }

    protected boolean includeContainer(IContainer container, IRemoteServiceContainerAdapter rsca, ServiceReference serviceReference, Map ecfConfiguration) {
        Object cID = serviceReference.getProperty("org.eclipse.ecf.containerID");
        if (cID == null || !(cID instanceof ID)) {
            Trace.trace((String)"org.eclipse.ecf.osgi.services.distribution", (String)"org.eclipse.ecf.osgi.services.distribution/debug", this.getClass(), (String)"includeContainer", (String)("serviceReference=" + serviceReference + " does not set remote service container id service property.  INCLUDING containerID=" + container.getID() + " in remote registration"));
            return true;
        }
        ID containerID = (ID)cID;
        if (container.getID().equals((Object)containerID)) {
            Trace.trace((String)"org.eclipse.ecf.osgi.services.distribution", (String)"org.eclipse.ecf.osgi.services.distribution/debug", this.getClass(), (String)"includeContainer", (String)("serviceReference=" + serviceReference + " has MATCHING container id=" + containerID + ".  INCLUDING rsca=" + rsca + " in remote registration"));
            return true;
        }
        Trace.trace((String)"org.eclipse.ecf.osgi.services.distribution", (String)"org.eclipse.ecf.osgi.services.distribution/debug", this.getClass(), (String)"includeContainer", (String)("serviceReference=" + serviceReference + " has non-matching container id=" + containerID + ".  EXCLUDING rsca=" + rsca + " in remote registration"));
        return false;
    }
}

