/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.presence.bot.impl;

import java.util.List;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.ConnectContextFactory;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.internal.presence.bot.Messages;
import org.eclipse.ecf.presence.IIMMessageEvent;
import org.eclipse.ecf.presence.IIMMessageListener;
import org.eclipse.ecf.presence.bot.IChatRoomBotEntry;
import org.eclipse.ecf.presence.bot.IChatRoomMessageHandlerEntry;
import org.eclipse.ecf.presence.chatroom.IChatRoomContainer;
import org.eclipse.ecf.presence.chatroom.IChatRoomInfo;
import org.eclipse.ecf.presence.chatroom.IChatRoomManager;
import org.eclipse.ecf.presence.chatroom.IChatRoomMessage;
import org.eclipse.ecf.presence.chatroom.IChatRoomMessageEvent;

public class ChatRoomBot
implements IIMMessageListener {
    protected IChatRoomBotEntry bot;
    protected IContainer container;
    protected ID targetID;
    protected IChatRoomContainer roomContainer;
    protected ID roomID;
    static /* synthetic */ Class class$0;

    public ChatRoomBot(IChatRoomBotEntry bot) {
        this.bot = bot;
    }

    protected void fireInitBot() {
        List commands = this.bot.getCommands();
        int i = 0;
        while (i < commands.size()) {
            IChatRoomMessageHandlerEntry entry = (IChatRoomMessageHandlerEntry)commands.get(i);
            entry.getHandler().init(this.bot);
            ++i;
        }
    }

    protected void firePreConnect() {
        List commands = this.bot.getCommands();
        int i = 0;
        while (i < commands.size()) {
            IChatRoomMessageHandlerEntry entry = (IChatRoomMessageHandlerEntry)commands.get(i);
            entry.getHandler().preContainerConnect(this.container, this.targetID);
            ++i;
        }
    }

    protected void firePreRoomConnect() {
        List commands = this.bot.getCommands();
        int i = 0;
        while (i < commands.size()) {
            IChatRoomMessageHandlerEntry entry = (IChatRoomMessageHandlerEntry)commands.get(i);
            entry.getHandler().preChatRoomConnect(this.roomContainer, this.roomID);
            ++i;
        }
    }

    public synchronized void connect() throws ECFException {
        this.fireInitBot();
        try {
            IChatRoomManager manager;
            Namespace namespace = null;
            if (this.container != null) {
                throw new ContainerConnectException(Messages.DefaultChatRoomBot_EXCEPTION_ALREADY_CONNECTED);
            }
            this.container = ContainerFactory.getDefault().createContainer(this.bot.getContainerFactoryName());
            namespace = this.container.getConnectNamespace();
            this.targetID = IDFactory.getDefault().createID(namespace, this.bot.getConnectID());
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ecf.presence.chatroom.IChatRoomManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((manager = (IChatRoomManager)this.container.getAdapter((Class)clazz)) == null) {
                throw new ECFException(Messages.DefaultChatRoomBot_EXCEPTION_NO_CHAT_ROOM);
            }
            this.firePreConnect();
            String password = this.bot.getPassword();
            IConnectContext context = password == null ? null : ConnectContextFactory.createPasswordConnectContext((String)password);
            this.container.connect(this.targetID, context);
            String[] roomNames = this.bot.getChatRooms();
            String[] roomPasswords = this.bot.getChatRoomPasswords();
            int i = 0;
            while (i < roomNames.length) {
                IChatRoomInfo room = manager.getChatRoomInfo(roomNames[i]);
                this.roomContainer = room.createChatRoomContainer();
                this.roomID = room.getRoomID();
                this.firePreRoomConnect();
                this.roomContainer.addMessageListener((IIMMessageListener)this);
                IConnectContext roomContext = roomPasswords[i] == null ? null : ConnectContextFactory.createPasswordConnectContext((String)roomPasswords[i]);
                this.roomContainer.connect(this.roomID, roomContext);
                ++i;
            }
        }
        catch (ECFException e) {
            if (this.container != null) {
                if (this.container.getConnectedID() != null) {
                    this.container.disconnect();
                }
                this.container.dispose();
            }
            this.container = null;
            throw e;
        }
    }

    public void handleMessageEvent(IIMMessageEvent event) {
        if (event instanceof IChatRoomMessageEvent) {
            IChatRoomMessageEvent roomEvent = (IChatRoomMessageEvent)event;
            IChatRoomMessage message = roomEvent.getChatRoomMessage();
            List commands = this.bot.getCommands();
            int i = 0;
            while (i < commands.size()) {
                IChatRoomMessageHandlerEntry entry = (IChatRoomMessageHandlerEntry)commands.get(i);
                entry.handleRoomMessage(message);
                ++i;
            }
        }
    }
}

