/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.filetransfer.httpclient.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient.Activator;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient.ISSLSocketFactoryModifier;

public class SSLSocketFactoryModifier
implements ISSLSocketFactoryModifier,
SecureProtocolSocketFactory {
    public void dispose() {
        Protocol.unregisterProtocol((String)"https");
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SSLSocketFactory factory = this.getSSLSocketFactory();
        return factory.createSocket(host, port);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        SSLSocketFactory factory = this.getSSLSocketFactory();
        return factory.createSocket(host, port, localAddress, localPort);
    }

    private SSLSocketFactory getSSLSocketFactory() throws IOException {
        SSLSocketFactory factory = Activator.getDefault().getSSLSocketFactory();
        if (factory == null) {
            throw new IOException("Cannot get socket factory");
        }
        return factory;
    }

    public Socket createSocket(String remoteHost, int remotePort, InetAddress clientHost, int clientPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        SSLSocketFactory factory = this.getSSLSocketFactory();
        if (params == null || params.getConnectionTimeout() == 0) {
            return factory.createSocket(remoteHost, remotePort, clientHost, clientPort);
        }
        Socket socket = factory.createSocket(remoteHost, remotePort, clientHost, clientPort);
        return socket;
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        SSLSocketFactory factory = this.getSSLSocketFactory();
        return factory.createSocket(socket, host, port, autoClose);
    }

    public SecureProtocolSocketFactory getProtocolSocketFactory() {
        return this;
    }
}

