/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.filetransfer;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.util.LogHelper;
import org.eclipse.ecf.core.util.PlatformHelper;
import org.eclipse.ecf.filetransfer.service.IRemoteFileSystemBrowser;
import org.eclipse.ecf.filetransfer.service.IRemoteFileSystemBrowserFactory;
import org.eclipse.ecf.filetransfer.service.IRetrieveFileTransfer;
import org.eclipse.ecf.filetransfer.service.IRetrieveFileTransferFactory;
import org.eclipse.ecf.filetransfer.service.ISendFileTransfer;
import org.eclipse.ecf.filetransfer.service.ISendFileTransferFactory;
import org.eclipse.ecf.internal.provider.filetransfer.IURLConnectionModifier;
import org.eclipse.ecf.internal.provider.filetransfer.Messages;
import org.eclipse.ecf.provider.filetransfer.retrieve.MultiProtocolRetrieveAdapter;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogService;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_EXCLUDED_SYS_PROP_NAME = "org.eclipse.ecf.provider.filetransfer.excludeContributors";
    private static final String CLASS_ATTR = "class";
    private static final String PRIORITY_ATTR = "priority";
    private static final int DEFAULT_PRIORITY = 100;
    private static final String PROTOCOL_ATTR = "protocol";
    private static final String[] jvmSchemes = new String[]{Messages.FileTransferNamespace_Http_Protocol, Messages.FileTransferNamespace_Ftp_Protocol, Messages.FileTransferNamespace_File_Protocol, Messages.FileTransferNamespace_Jar_Protocol, Messages.FileTransferNamespace_Https_Protocol, Messages.FileTransferNamespace_Mailto_Protocol, Messages.FileTransferNamespace_Gopher_Protocol};
    private static final String URL_HANDLER_PROTOCOL_NAME = "url.handler.protocol";
    private static final String URLSTREAM_HANDLER_SERVICE_NAME = "org.osgi.service.url.URLStreamHandlerService";
    public static final String PLUGIN_ID = "org.eclipse.ecf.provider.filetransfer";
    private static final String RETRIEVE_FILETRANSFER_PROTOCOL_FACTORY_EPOINT_NAME = "retrieveFileTransferProtocolFactory";
    private static final String RETRIEVE_FILETRANSFER_PROTOCOL_FACTORY_EPOINT = "org.eclipse.ecf.provider.filetransfer.retrieveFileTransferProtocolFactory";
    private static final String SEND_FILETRANSFER_PROTOCOL_FACTORY_EPOINT_NAME = "sendFileTransferProtocolFactory";
    private static final String SEND_FILETRANSFER_PROTOCOL_FACTORY_EPOINT = "org.eclipse.ecf.provider.filetransfer.sendFileTransferProtocolFactory";
    private static final String BROWSE_FILETRANSFER_PROTOCOL_FACTORY_EPOINT_NAME = "browseFileTransferProtocolFactory";
    private static final String BROWSE_FILETRANSFER_PROTOCOL_FACTORY_EPOINT = "org.eclipse.ecf.provider.filetransfer.browseFileTransferProtocolFactory";
    private static Activator plugin;
    private BundleContext context = null;
    private ServiceRegistration fileTransferServiceRegistration;
    private ServiceTracker logServiceTracker = null;
    private ServiceTracker extensionRegistryTracker = null;
    private Map retrieveFileTransferProtocolMap = null;
    private Map sendFileTransferProtocolMap = null;
    private Map browseFileTransferProtocolMap = null;
    private ServiceTracker adapterManagerTracker = null;
    private ServiceTracker proxyServiceTracker = null;
    private IURLConnectionModifier urlConnectionModifier = null;
    private String[] excludedPlugins = null;
    private IRegistryChangeListener registryChangeListener = new IRegistryChangeListener(){

        public void registryChanged(IRegistryChangeEvent event) {
            IExtensionDelta[] retrieveDelta = event.getExtensionDeltas(Activator.PLUGIN_ID, Activator.RETRIEVE_FILETRANSFER_PROTOCOL_FACTORY_EPOINT_NAME);
            int i = 0;
            while (i < retrieveDelta.length) {
                switch (retrieveDelta[i].getKind()) {
                    case 1: {
                        Activator.this.addRetrieveExtensions(retrieveDelta[i].getExtension().getConfigurationElements());
                        break;
                    }
                    case 2: {
                        Activator.this.removeRetrieveExtensions(retrieveDelta[i].getExtension().getConfigurationElements());
                    }
                }
                ++i;
            }
            IExtensionDelta[] sendDelta = event.getExtensionDeltas(Activator.PLUGIN_ID, Activator.SEND_FILETRANSFER_PROTOCOL_FACTORY_EPOINT_NAME);
            int i2 = 0;
            while (i2 < sendDelta.length) {
                switch (sendDelta[i2].getKind()) {
                    case 1: {
                        Activator.this.addSendExtensions(sendDelta[i2].getExtension().getConfigurationElements());
                        break;
                    }
                    case 2: {
                        Activator.this.removeSendExtensions(sendDelta[i2].getExtension().getConfigurationElements());
                    }
                }
                ++i2;
            }
            IExtensionDelta[] browseDelta = event.getExtensionDeltas(Activator.PLUGIN_ID, Activator.BROWSE_FILETRANSFER_PROTOCOL_FACTORY_EPOINT_NAME);
            int i3 = 0;
            while (i3 < browseDelta.length) {
                switch (browseDelta[i3].getKind()) {
                    case 1: {
                        Activator.this.addBrowseExtensions(browseDelta[i3].getExtension().getConfigurationElements());
                        break;
                    }
                    case 2: {
                        Activator.this.removeBrowseExtensions(browseDelta[i3].getExtension().getConfigurationElements());
                    }
                }
                ++i3;
            }
        }
    };
    private final DummyURLStreamHandlerService dummyService = new DummyURLStreamHandlerService();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    private String[] parseExcludedPlugins() {
        String prop = System.getProperty(PLUGIN_EXCLUDED_SYS_PROP_NAME);
        if (prop == null) {
            return new String[0];
        }
        StringTokenizer tok = new StringTokenizer(prop, ",");
        int count = tok.countTokens();
        String[] results = new String[count];
        int i = 0;
        while (i < count) {
            results[i] = tok.nextToken();
            ++i;
        }
        return results;
    }

    protected LogService getLogService() {
        if (this.logServiceTracker == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.osgi.service.log.LogService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.logServiceTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.logServiceTracker.open();
        }
        return (LogService)this.logServiceTracker.getService();
    }

    public IProxyService getProxyService() {
        try {
            if (this.proxyServiceTracker == null) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.core.net.proxy.IProxyService");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.proxyServiceTracker = new ServiceTracker(this.context, clazz.getName(), null);
                this.proxyServiceTracker.open();
            }
            return (IProxyService)this.proxyServiceTracker.getService();
        }
        catch (Exception e) {
            Activator.logNoProxyWarning(e);
        }
        catch (NoClassDefFoundError e) {
            Activator.logNoProxyWarning(e);
        }
        return null;
    }

    public static void logNoProxyWarning(Throwable e) {
        Activator.getDefault().log((IStatus)new Status(2, PLUGIN_ID, 4, "Warning: Platform proxy API not available", e));
    }

    public void log(IStatus status) {
        LogService logService = this.getLogService();
        if (logService != null) {
            logService.log(LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
        }
    }

    public Bundle getBundle() {
        if (this.context == null) {
            return null;
        }
        return this.context.getBundle();
    }

    public void start(BundleContext ctxt) throws Exception {
        Class<?> clazz;
        plugin = this;
        this.context = ctxt;
        try {
            Class<?> urlConnectionModifierClass = Class.forName("org.eclipse.ecf.internal.provider.filetransfer.ssl.ECFURLConnectionModifier");
            this.urlConnectionModifier = (IURLConnectionModifier)urlConnectionModifierClass.newInstance();
            this.urlConnectionModifier.init(ctxt);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Throwable t) {
            this.log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Unexpected Error in Activator.start", t));
        }
        if ((clazz = class$2) == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ecf.filetransfer.service.IRetrieveFileTransferFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fileTransferServiceRegistration = ctxt.registerService(clazz.getName(), (Object)new IRetrieveFileTransferFactory(){

            public IRetrieveFileTransfer newInstance() {
                return new MultiProtocolRetrieveAdapter();
            }
        }, null);
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("org.eclipse.core.runtime.IExtensionRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.extensionRegistryTracker = new ServiceTracker(ctxt, clazz2.getName(), null);
        this.extensionRegistryTracker.open();
        IExtensionRegistry registry = this.getExtensionRegistry();
        if (registry != null) {
            registry.addRegistryChangeListener(this.registryChangeListener);
        }
        this.loadProtocolHandlers();
    }

    public void stop(BundleContext ctxt) throws Exception {
        plugin = null;
        this.context = null;
        IExtensionRegistry registry = this.getExtensionRegistry();
        if (registry != null) {
            registry.removeRegistryChangeListener(this.registryChangeListener);
        }
        if (this.urlConnectionModifier != null) {
            this.urlConnectionModifier.dispose();
            this.urlConnectionModifier = null;
        }
        if (this.extensionRegistryTracker != null) {
            this.extensionRegistryTracker.close();
            this.extensionRegistryTracker = null;
        }
        if (this.fileTransferServiceRegistration != null) {
            this.fileTransferServiceRegistration.unregister();
            this.fileTransferServiceRegistration = null;
        }
        if (this.adapterManagerTracker != null) {
            this.adapterManagerTracker.close();
            this.adapterManagerTracker = null;
        }
        if (this.proxyServiceTracker != null) {
            this.proxyServiceTracker.close();
            this.proxyServiceTracker = null;
        }
        this.context = null;
        if (this.retrieveFileTransferProtocolMap != null) {
            this.retrieveFileTransferProtocolMap.clear();
            this.retrieveFileTransferProtocolMap = null;
        }
        if (this.sendFileTransferProtocolMap != null) {
            this.sendFileTransferProtocolMap.clear();
            this.sendFileTransferProtocolMap = null;
        }
        if (this.browseFileTransferProtocolMap != null) {
            this.browseFileTransferProtocolMap.clear();
            this.browseFileTransferProtocolMap = null;
        }
    }

    public static synchronized Activator getDefault() {
        if (plugin == null) {
            plugin = new Activator();
        }
        return plugin;
    }

    public String[] getPlatformSupportedSchemes() {
        int i;
        ServiceTracker handlers = new ServiceTracker(this.context, URLSTREAM_HANDLER_SERVICE_NAME, null);
        handlers.open();
        ServiceReference[] refs = handlers.getServiceReferences();
        HashSet<Object> protocols = new HashSet<Object>();
        if (refs != null) {
            i = 0;
            while (i < refs.length) {
                Object protocol = refs[i].getProperty(URL_HANDLER_PROTOCOL_NAME);
                if (protocol instanceof String) {
                    protocols.add(protocol);
                } else if (protocol instanceof String[]) {
                    String[] ps = (String[])protocol;
                    int j = 0;
                    while (j < ps.length) {
                        protocols.add(ps[j]);
                        ++j;
                    }
                }
                ++i;
            }
        }
        handlers.close();
        i = 0;
        while (i < jvmSchemes.length) {
            protocols.add(jvmSchemes[i]);
            ++i;
        }
        return protocols.toArray(new String[0]);
    }

    public IExtensionRegistry getExtensionRegistry() {
        if (this.extensionRegistryTracker == null) {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.core.runtime.IExtensionRegistry");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.extensionRegistryTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.extensionRegistryTracker.open();
        }
        return (IExtensionRegistry)this.extensionRegistryTracker.getService();
    }

    private int getPriority(IConfigurationElement configElement, String warning, String protocol) {
        String priorityString = configElement.getAttribute(PRIORITY_ATTR);
        int priority = 100;
        if (priorityString != null) {
            try {
                priority = new Integer(priorityString);
                priority = priority < 0 ? 0 : priority;
            }
            catch (NumberFormatException numberFormatException) {
                Activator.getDefault().log((IStatus)new Status(2, PLUGIN_ID, 2, NLS.bind((String)"{0} for {1} from {2} has invalid priority {3}. Priority will be set to {4}", (Object[])new Object[]{warning, protocol, configElement.getDeclaringExtension().getContributor().getName(), priorityString, String.valueOf(100)}), null));
            }
        }
        return priority;
    }

    boolean pluginExcluded(String pluginId) {
        if (this.excludedPlugins == null) {
            this.excludedPlugins = this.parseExcludedPlugins();
        }
        List<String> l = Arrays.asList(this.excludedPlugins);
        return l.contains(pluginId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void addRetrieveExtensions(IConfigurationElement[] configElements) {
        existingSchemes = this.getPlatformSupportedSchemes();
        i = 0;
        while (i < configElements.length) {
            block13: {
                protocol = configElements[i].getAttribute("protocol");
                if (protocol == null || "".equals(protocol)) {
                    return;
                }
                CONTRIBUTION_WARNING = "File retrieve contribution";
                try {
                    block14: {
                        pluginId = configElements[i].getDeclaringExtension().getContributor().getName();
                        if (this.pluginExcluded(pluginId)) break block14;
                        clazz = (IRetrieveFileTransferFactory)configElements[i].createExecutableExtension("class");
                        priority = this.getPriority(configElements[i], CONTRIBUTION_WARNING, protocol);
                        contributorName = configElements[i].getDeclaringExtension().getContributor().getName();
                        newProtocolFactory = new ProtocolFactory(clazz, priority, contributorName);
                        var11_12 = this.retrieveFileTransferProtocolMap;
                        synchronized (var11_12) {
                            oldProtocolFactory = (ProtocolFactory)this.retrieveFileTransferProtocolMap.get(protocol);
                            if (oldProtocolFactory == null) ** GOTO lbl29
                            result = oldProtocolFactory.compareTo(newProtocolFactory);
                            if (result < 0) {
                                Activator.getDefault().log((IStatus)new Status(2, "org.eclipse.ecf.provider.filetransfer", 2, NLS.bind((String)"{0} for protocol {1} from {2} will be ignored.  Existing protocol factory has higher priority.", (Object[])new Object[]{CONTRIBUTION_WARNING, protocol, contributorName}), null));
                            } else {
                                if (result == 0) {
                                    Activator.getDefault().log((IStatus)new Status(2, "org.eclipse.ecf.provider.filetransfer", 2, NLS.bind((String)"{0} for protocol {1} from {2} will be used in preference to existing handler.  Both have same priority={3}.", (Object[])new Object[]{CONTRIBUTION_WARNING, protocol, contributorName, new Integer(priority)}), null));
                                } else if (result > 0) {
                                    Activator.getDefault().log((IStatus)new Status(2, "org.eclipse.ecf.provider.filetransfer", 2, NLS.bind((String)"{0} for protocol {1} from {2} will be used in preference to existing handler.  New handler has higher priority={3}<{4}.", (Object[])new Object[]{CONTRIBUTION_WARNING, protocol, contributorName, new Integer(priority), new Integer(oldProtocolFactory.priority)}), null));
                                }
lbl29:
                                // 5 sources

                                if (!this.isSchemeRegistered(protocol, existingSchemes)) {
                                    this.registerScheme(protocol);
                                }
                                this.retrieveFileTransferProtocolMap.put(protocol, newProtocolFactory);
                            }
                            break block13;
                        }
                    }
                    Activator.getDefault().log((IStatus)new Status(2, "org.eclipse.ecf.provider.filetransfer", 2, "Plugin " + pluginId + " excluded from contributing retrieve factory", null));
                }
                catch (CoreException e) {
                    Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider.filetransfer", 4, NLS.bind((String)"Error loading from {0} extension point", (Object)"org.eclipse.ecf.provider.filetransfer.retrieveFileTransferProtocolFactory"), (Throwable)e));
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRetrieveExtensions(IConfigurationElement[] configElements) {
        int i = 0;
        while (i < configElements.length) {
            String protocol = configElements[i].getAttribute(PROTOCOL_ATTR);
            if (protocol == null || "".equals(protocol)) {
                return;
            }
            Map map = this.retrieveFileTransferProtocolMap;
            synchronized (map) {
                ProtocolFactory protocolFactory = (ProtocolFactory)this.retrieveFileTransferProtocolMap.get(protocol);
                if (protocolFactory != null && configElements[i].getContributor().getName().equals(protocolFactory.getID())) {
                    this.retrieveFileTransferProtocolMap.remove(protocol);
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void addSendExtensions(IConfigurationElement[] configElements) {
        existingSchemes = this.getPlatformSupportedSchemes();
        i = 0;
        while (i < configElements.length) {
            block13: {
                protocol = configElements[i].getAttribute("protocol");
                if (protocol == null || "".equals(protocol)) {
                    return;
                }
                CONTRIBUTION_WARNING = "File send contribution";
                try {
                    block14: {
                        pluginId = configElements[i].getDeclaringExtension().getContributor().getName();
                        if (this.pluginExcluded(pluginId)) break block14;
                        clazz = (ISendFileTransferFactory)configElements[i].createExecutableExtension("class");
                        priority = this.getPriority(configElements[i], CONTRIBUTION_WARNING, protocol);
                        contributorName = configElements[i].getDeclaringExtension().getContributor().getName();
                        newProtocolFactory = new ProtocolFactory(clazz, priority, contributorName);
                        var11_12 = this.sendFileTransferProtocolMap;
                        synchronized (var11_12) {
                            oldProtocolFactory = (ProtocolFactory)this.sendFileTransferProtocolMap.get(protocol);
                            if (oldProtocolFactory == null) ** GOTO lbl29
                            result = oldProtocolFactory.compareTo(newProtocolFactory);
                            if (result < 0) {
                                Activator.getDefault().log((IStatus)new Status(2, "org.eclipse.ecf.provider.filetransfer", 2, NLS.bind((String)"{0} for protocol {1} from {2} will be ignored.  Existing protocol factory has higher priority.", (Object[])new Object[]{CONTRIBUTION_WARNING, protocol, contributorName}), null));
                            } else {
                                if (result == 0) {
                                    Activator.getDefault().log((IStatus)new Status(2, "org.eclipse.ecf.provider.filetransfer", 2, NLS.bind((String)"{0} for protocol {1} from {2} will be used in preference to existing handler.  Both have same priority={3}.", (Object[])new Object[]{CONTRIBUTION_WARNING, protocol, contributorName, new Integer(priority)}), null));
                                } else if (result > 0) {
                                    Activator.getDefault().log((IStatus)new Status(2, "org.eclipse.ecf.provider.filetransfer", 2, NLS.bind((String)"{0} for protocol {1} from {2} will be used in preference to existing handler.  New handler has higher priority={3}<{4}.", (Object[])new Object[]{CONTRIBUTION_WARNING, protocol, contributorName, new Integer(priority), new Integer(oldProtocolFactory.priority)}), null));
                                }
lbl29:
                                // 5 sources

                                if (!this.isSchemeRegistered(protocol, existingSchemes)) {
                                    this.registerScheme(protocol);
                                }
                                this.sendFileTransferProtocolMap.put(protocol, newProtocolFactory);
                            }
                            break block13;
                        }
                    }
                    Activator.getDefault().log((IStatus)new Status(2, "org.eclipse.ecf.provider.filetransfer", 2, "Plugin " + pluginId + " excluded from contributing send factory", null));
                }
                catch (CoreException e) {
                    Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider.filetransfer", 4, NLS.bind((String)"Error loading from {0} extension point", (Object)"org.eclipse.ecf.provider.filetransfer.sendFileTransferProtocolFactory"), (Throwable)e));
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSendExtensions(IConfigurationElement[] configElements) {
        int i = 0;
        while (i < configElements.length) {
            String protocol = configElements[i].getAttribute(PROTOCOL_ATTR);
            if (protocol == null || "".equals(protocol)) {
                return;
            }
            Map map = this.sendFileTransferProtocolMap;
            synchronized (map) {
                ProtocolFactory protocolFactory = (ProtocolFactory)this.sendFileTransferProtocolMap.get(protocol);
                if (protocolFactory != null && configElements[i].getContributor().getName().equals(protocolFactory.getID())) {
                    this.sendFileTransferProtocolMap.remove(protocol);
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void addBrowseExtensions(IConfigurationElement[] configElements) {
        existingSchemes = this.getPlatformSupportedSchemes();
        i = 0;
        while (i < configElements.length) {
            block13: {
                protocol = configElements[i].getAttribute("protocol");
                if (protocol == null || "".equals(protocol)) {
                    return;
                }
                CONTRIBUTION_WARNING = "File browse contribution";
                try {
                    block14: {
                        pluginId = configElements[i].getDeclaringExtension().getContributor().getName();
                        if (this.pluginExcluded(pluginId)) break block14;
                        clazz = (IRemoteFileSystemBrowserFactory)configElements[i].createExecutableExtension("class");
                        priority = this.getPriority(configElements[i], CONTRIBUTION_WARNING, protocol);
                        contributorName = configElements[i].getDeclaringExtension().getContributor().getName();
                        newProtocolFactory = new ProtocolFactory(clazz, priority, contributorName);
                        var11_12 = this.browseFileTransferProtocolMap;
                        synchronized (var11_12) {
                            oldProtocolFactory = (ProtocolFactory)this.browseFileTransferProtocolMap.get(protocol);
                            if (oldProtocolFactory == null) ** GOTO lbl29
                            result = oldProtocolFactory.compareTo(newProtocolFactory);
                            if (result < 0) {
                                Activator.getDefault().log((IStatus)new Status(2, "org.eclipse.ecf.provider.filetransfer", 2, NLS.bind((String)"{0} for protocol {1} from {2} will be ignored.  Existing protocol factory has higher priority.", (Object[])new Object[]{CONTRIBUTION_WARNING, protocol, contributorName}), null));
                            } else {
                                if (result == 0) {
                                    Activator.getDefault().log((IStatus)new Status(2, "org.eclipse.ecf.provider.filetransfer", 2, NLS.bind((String)"{0} for protocol {1} from {2} will be used in preference to existing handler.  Both have same priority={3}.", (Object[])new Object[]{CONTRIBUTION_WARNING, protocol, contributorName, new Integer(priority)}), null));
                                } else if (result > 0) {
                                    Activator.getDefault().log((IStatus)new Status(2, "org.eclipse.ecf.provider.filetransfer", 2, NLS.bind((String)"{0} for protocol {1} from {2} will be used in preference to existing handler.  New handler has higher priority={3}<{4}.", (Object[])new Object[]{CONTRIBUTION_WARNING, protocol, contributorName, new Integer(priority), new Integer(oldProtocolFactory.priority)}), null));
                                }
lbl29:
                                // 5 sources

                                if (!this.isSchemeRegistered(protocol, existingSchemes)) {
                                    this.registerScheme(protocol);
                                }
                                this.browseFileTransferProtocolMap.put(protocol, newProtocolFactory);
                            }
                            break block13;
                        }
                    }
                    Activator.getDefault().log((IStatus)new Status(2, "org.eclipse.ecf.provider.filetransfer", 2, "Plugin " + pluginId + " excluded from contributing browse factory", null));
                }
                catch (CoreException e) {
                    Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider.filetransfer", 4, NLS.bind((String)"Error loading from {0} extension point", (Object)"org.eclipse.ecf.provider.filetransfer.browseFileTransferProtocolFactory"), (Throwable)e));
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBrowseExtensions(IConfigurationElement[] configElements) {
        int i = 0;
        while (i < configElements.length) {
            String protocol = configElements[i].getAttribute(PROTOCOL_ATTR);
            if (protocol == null || "".equals(protocol)) {
                return;
            }
            Map map = this.browseFileTransferProtocolMap;
            synchronized (map) {
                ProtocolFactory protocolFactory = (ProtocolFactory)this.browseFileTransferProtocolMap.get(protocol);
                if (protocolFactory != null && configElements[i].getContributor().getName().equals(protocolFactory.getID())) {
                    this.browseFileTransferProtocolMap.remove(protocol);
                }
            }
            ++i;
        }
    }

    private void loadProtocolHandlers() {
        this.retrieveFileTransferProtocolMap = new HashMap(3);
        this.sendFileTransferProtocolMap = new HashMap(3);
        this.browseFileTransferProtocolMap = new HashMap(3);
        IExtensionRegistry reg = this.getExtensionRegistry();
        if (reg != null) {
            IExtensionPoint browseExtensionPoint;
            IExtensionPoint sendExtensionPoint;
            IExtensionPoint retrieveExtensionPoint = reg.getExtensionPoint(RETRIEVE_FILETRANSFER_PROTOCOL_FACTORY_EPOINT);
            if (retrieveExtensionPoint != null) {
                this.addRetrieveExtensions(retrieveExtensionPoint.getConfigurationElements());
            }
            if ((sendExtensionPoint = reg.getExtensionPoint(SEND_FILETRANSFER_PROTOCOL_FACTORY_EPOINT)) != null) {
                this.addSendExtensions(sendExtensionPoint.getConfigurationElements());
            }
            if ((browseExtensionPoint = reg.getExtensionPoint(BROWSE_FILETRANSFER_PROTOCOL_FACTORY_EPOINT)) != null) {
                this.addBrowseExtensions(browseExtensionPoint.getConfigurationElements());
            }
        }
    }

    private boolean isSchemeRegistered(String protocol, String[] schemes) {
        int i = 0;
        while (i < schemes.length) {
            if (protocol.equals(schemes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void registerScheme(String protocol) {
        Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
        properties.put(URL_HANDLER_PROTOCOL_NAME, new String[]{protocol});
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName(URLSTREAM_HANDLER_SERVICE_NAME);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.context.registerService(clazz.getName(), (Object)this.dummyService, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRetrieveFileTransfer getFileTransfer(String protocol) {
        ProtocolFactory protocolFactory = null;
        Map map = this.retrieveFileTransferProtocolMap;
        synchronized (map) {
            protocolFactory = (ProtocolFactory)this.retrieveFileTransferProtocolMap.get(protocol);
        }
        if (protocolFactory == null) {
            return null;
        }
        IRetrieveFileTransferFactory factory = (IRetrieveFileTransferFactory)protocolFactory.getFactory();
        if (factory != null) {
            return factory.newInstance();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISendFileTransfer getSendFileTransfer(String protocol) {
        ProtocolFactory protocolFactory = null;
        Map map = this.sendFileTransferProtocolMap;
        synchronized (map) {
            protocolFactory = (ProtocolFactory)this.sendFileTransferProtocolMap.get(protocol);
        }
        if (protocolFactory == null) {
            return null;
        }
        ISendFileTransferFactory factory = (ISendFileTransferFactory)protocolFactory.getFactory();
        if (factory != null) {
            return factory.newInstance();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteFileSystemBrowser getBrowseFileTransfer(String protocol) {
        ProtocolFactory protocolFactory = null;
        Map map = this.browseFileTransferProtocolMap;
        synchronized (map) {
            protocolFactory = (ProtocolFactory)this.browseFileTransferProtocolMap.get(protocol);
        }
        if (protocolFactory == null) {
            return null;
        }
        IRemoteFileSystemBrowserFactory factory = (IRemoteFileSystemBrowserFactory)protocolFactory.getFactory();
        if (factory != null) {
            return factory.newInstance();
        }
        return null;
    }

    public IAdapterManager getAdapterManager() {
        IAdapterManager adapterManager;
        if (this.adapterManagerTracker == null) {
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("org.eclipse.core.runtime.IAdapterManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.adapterManagerTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.adapterManagerTracker.open();
        }
        if ((adapterManager = (IAdapterManager)this.adapterManagerTracker.getService()) == null) {
            adapterManager = PlatformHelper.getPlatformAdapterManager();
        }
        return adapterManager;
    }

    public IURLConnectionModifier getURLConnectionModifier() {
        return this.urlConnectionModifier;
    }

    class DummyURLStreamHandlerService
    extends AbstractURLStreamHandlerService {
        DummyURLStreamHandlerService() {
        }

        public URLConnection openConnection(URL u) throws IOException {
            throw new IOException(NLS.bind((String)"URLConnection cannot be created for {0}", (Object)u.toExternalForm()));
        }
    }

    static class ProtocolFactory
    implements Comparable {
        Object factory;
        int priority = 0;
        String id;

        public ProtocolFactory(Object factory, int priority, String id) {
            this.factory = factory;
            this.priority = priority;
            this.id = id;
        }

        public Object getFactory() {
            return this.factory;
        }

        public String getID() {
            return this.id;
        }

        public int compareTo(Object another) {
            if (!(another instanceof ProtocolFactory)) {
                return -1;
            }
            ProtocolFactory other = (ProtocolFactory)another;
            if (this.priority == other.priority) {
                return 0;
            }
            return this.priority < other.priority ? -1 : 1;
        }
    }
}

