/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ecf.core.variants;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

final class RemoteStorage
implements IEncodedStorage,
Serializable {
    private static final long serialVersionUID = -4773139009062649259L;
    private final String path;
    private final String charset;
    private final byte[] bytes;

    RemoteStorage(String path, String charset, byte[] bytes) {
        this.path = path;
        this.charset = charset;
        this.bytes = bytes;
    }

    public String getCharset() throws CoreException {
        return this.charset;
    }

    public InputStream getContents() {
        return new ByteArrayInputStream(this.bytes);
    }

    public IPath getFullPath() {
        return new Path(this.path);
    }

    public String getName() {
        return new Path(this.path).lastSegment();
    }

    public boolean isReadOnly() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public String toString() {
        return "RemoteStorage[path=" + this.path + ']';
    }
}

