/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ecf.ui.handlers;

import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.user.IUser;
import org.eclipse.ecf.presence.IPresenceContainerAdapter;
import org.eclipse.ecf.presence.roster.IRoster;
import org.eclipse.ecf.presence.roster.IRosterEntry;
import org.eclipse.ecf.presence.ui.menu.AbstractRosterMenuHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.ecf.core.RemoteShare;
import org.eclipse.team.internal.ecf.core.TeamSynchronization;
import org.eclipse.team.internal.ecf.core.variants.RemoteResourceVariantTreeSubscriber;
import org.eclipse.team.ui.synchronize.SyncInfoCompareInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.WorkbenchJob;

class CompareWithHandler
extends AbstractRosterMenuHandler {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    CompareWithHandler(IRosterEntry entry) {
        super(entry);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IRosterEntry selectedEntry = this.getRosterEntry();
        IRoster roster = selectedEntry.getRoster();
        final IUser remoteUser = roster.getUser();
        ID localId = remoteUser.getID();
        ID remoteId = selectedEntry.getUser().getID();
        IPresenceContainerAdapter iPresenceContainerAdapter = roster.getPresenceContainerAdapter();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.core.IContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IContainer container = (IContainer)iPresenceContainerAdapter.getAdapter((Class)clazz);
        final IResource resource = this.getResource(event);
        if (resource == null) {
            MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), null, (String)"A file must be selected for comparison.");
            return null;
        }
        RemoteShare share = TeamSynchronization.getShare((ID)container.getID());
        final RemoteResourceVariantTreeSubscriber subscriber = new RemoteResourceVariantTreeSubscriber(share, localId, remoteId);
        Job job = new Job("Resource Compare with Remote Peer"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    CompareWithHandler.this.openCompareEditor(subscriber.getSyncInfo(resource, monitor), remoteUser);
                    return Status.OK_STATUS;
                }
                catch (TeamException e) {
                    return e.getStatus();
                }
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }

    void openCompareEditor(SyncInfo syncInfo, IUser user) {
        final SyncInfoCompareInput input = new SyncInfoCompareInput("Remote Peer (" + user.getNickname() + ")", syncInfo);
        WorkbenchJob job = new WorkbenchJob("Compare Editor Renderer"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                CompareUI.openCompareEditor((CompareEditorInput)input, (boolean)true);
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private IResource getResource(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection iss = (IStructuredSelection)selection;
            Object element = iss.getFirstElement();
            if (element instanceof IResource) {
                return (IResource)element;
            }
            if (element instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)element;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return (IResource)iAdaptable.getAdapter((Class)clazz);
            }
            return null;
        }
        IEditorPart editor = HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
        IEditorInput iEditorInput = editor.getEditorInput();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IFile)iEditorInput.getAdapter((Class)clazz);
    }
}

