/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.discovery.identity;

import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.discovery.identity.IServiceIDFactory;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.discovery.identity.ServiceTypeID;
import org.eclipse.ecf.internal.discovery.Messages;

public class ServiceIDFactory
implements IServiceIDFactory {
    private static final IServiceIDFactory instance = new ServiceIDFactory();

    public static IServiceIDFactory getDefault() {
        return instance;
    }

    public IServiceID createServiceID(Namespace namespace, IServiceTypeID serviceType, String serviceName) throws IDCreateException {
        return (IServiceID)IDFactory.getDefault().createID(namespace, new Object[]{serviceType, serviceName});
    }

    public IServiceID createServiceID(Namespace namespace, String serviceType, String serviceName) throws IDCreateException {
        return (IServiceID)IDFactory.getDefault().createID(namespace, new Object[]{serviceType, serviceName});
    }

    public IServiceID createServiceID(Namespace namespace, String serviceType) throws IDCreateException {
        return this.createServiceID(namespace, serviceType, null);
    }

    public IServiceID createServiceID(Namespace namespace, IServiceTypeID serviceType) throws IDCreateException {
        return this.createServiceID(namespace, serviceType, null);
    }

    public IServiceID createServiceID(Namespace namespace, String[] serviceType, String[] scopes, String[] protocols, String namingAuthority, String serviceName) throws IDCreateException {
        try {
            ServiceTypeID aServiceType = new ServiceTypeID(namespace, serviceType, scopes, protocols, namingAuthority);
            return (IServiceID)IDFactory.getDefault().createID(namespace, new Object[]{aServiceType, serviceName});
        }
        catch (AssertionFailedException e) {
            throw new IDCreateException(Messages.ServiceTypeID_EXCEPTION_SERVICE_TYPE_ID_NOT_PARSEABLE, (Throwable)e);
        }
    }

    public IServiceID createServiceID(Namespace namespace, String[] serviceType, String[] protocols, String serviceName) throws IDCreateException {
        return this.createServiceID(namespace, serviceType, IServiceTypeID.DEFAULT_SCOPE, protocols, "iana", serviceName);
    }
}

