/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.discovery;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.ecf.discovery.IServiceProperties;
import org.osgi.framework.ServiceReference;

public class ServicePropertyUtils {
    public static final String PROTOCOL_SEPARATOR = ":";
    public static final String ENDPOINT_INTERFACE_NAME_SEPARATOR = ":";
    public static final String INTERFACE_VERSION_SEPARATOR = ":";
    private static final String COLLECTION_SEPARATOR = ",";

    public static Collection getCollectionProperty(ServiceReference sr, String propName) {
        if (sr == null || propName == null) {
            return null;
        }
        Object val = sr.getProperty(propName);
        if (val == null || !(val instanceof Collection)) {
            return null;
        }
        return (Collection)val;
    }

    public static String getStringProperty(ServiceReference reference, String propKey) {
        if (reference == null || propKey == null) {
            return null;
        }
        Object val = reference.getProperty(propKey);
        if (val == null || !(val instanceof String)) {
            return null;
        }
        return (String)val;
    }

    public static String getStringProperty(ServiceReference reference, String propKey, String defaultValue) {
        if (reference == null || propKey == null) {
            return null;
        }
        Object val = reference.getProperty(propKey);
        if (val == null || !(val instanceof String)) {
            return defaultValue;
        }
        return (String)val;
    }

    public static String getStringProperty(IServiceProperties svcProps, String propKey) {
        if (svcProps == null || propKey == null) {
            return null;
        }
        Object val = svcProps.getProperty(propKey);
        if (val == null || !(val instanceof String)) {
            return null;
        }
        return (String)val;
    }

    public static URL getURLProperty(ServiceReference reference, String propKey) {
        if (reference == null || propKey == null) {
            return null;
        }
        Object val = reference.getProperty(propKey);
        if (val == null || !(val instanceof URL)) {
            return null;
        }
        return (URL)val;
    }

    public static Map getMapProperty(ServiceReference reference, String propKeyServiceProperties) {
        if (reference == null || propKeyServiceProperties == null) {
            return null;
        }
        Object val = reference.getProperty(propKeyServiceProperties);
        if (val == null || !(val instanceof Map)) {
            return null;
        }
        return (Map)val;
    }

    public static String createStringFromCollection(Collection svcInterfaces) {
        if (svcInterfaces == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        Iterator i = svcInterfaces.iterator();
        while (i.hasNext()) {
            String item = (String)i.next();
            result.append(item);
            if (!i.hasNext()) continue;
            result.append(COLLECTION_SEPARATOR);
        }
        return result.toString();
    }

    public static Collection createCollectionFromString(String value) {
        if (value == null) {
            return null;
        }
        StringTokenizer t = new StringTokenizer(value, COLLECTION_SEPARATOR);
        ArrayList<String> result = new ArrayList<String>();
        while (t.hasMoreTokens()) {
            result.add(t.nextToken());
        }
        return result;
    }
}

