/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.discovery;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.util.ECFRuntimeException;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.discovery.IServiceEvent;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceListener;
import org.eclipse.ecf.discovery.IServiceProperties;
import org.eclipse.ecf.discovery.ServiceInfo;
import org.eclipse.ecf.discovery.ServiceProperties;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.discovery.identity.ServiceIDFactory;
import org.eclipse.ecf.discovery.service.IDiscoveryService;
import org.eclipse.ecf.internal.osgi.services.discovery.Activator;
import org.eclipse.ecf.internal.osgi.services.discovery.DiscoveredServiceNotificationImpl;
import org.eclipse.ecf.internal.osgi.services.discovery.ServicePropertyUtils;
import org.osgi.framework.ServiceReference;
import org.osgi.service.discovery.DiscoveredServiceNotification;
import org.osgi.service.discovery.DiscoveredServiceTracker;
import org.osgi.service.discovery.ServicePublication;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServicePublicationHandler
implements ServiceTrackerCustomizer {
    private Map serviceInfos = Collections.synchronizedMap(new HashMap());
    private final IServiceListener serviceListener = new IServiceListener(){

        public void serviceDiscovered(IServiceEvent anEvent) {
            ServicePublicationHandler.this.handleServiceDiscovered(anEvent.getLocalContainerID(), anEvent.getServiceInfo());
        }

        public void serviceUndiscovered(IServiceEvent anEvent) {
            ServicePublicationHandler.this.handleServiceUndiscovered(anEvent.getLocalContainerID(), anEvent.getServiceInfo());
        }
    };
    private IDiscoveryService discovery;

    void handleServiceDiscovered(ID localContainerID, IServiceInfo serviceInfo) {
        IServiceID serviceID = serviceInfo.getServiceID();
        if (this.matchServiceID(serviceID)) {
            this.trace("handleOSGIServiceDiscovered", "serviceID=" + serviceID);
            DiscoveredServiceTracker[] discoveredTrackers = this.findMatchingDiscoveredServiceTrackers(serviceInfo);
            if (discoveredTrackers != null) {
                int i = 0;
                while (i < discoveredTrackers.length) {
                    discoveredTrackers[i].serviceChanged((DiscoveredServiceNotification)new DiscoveredServiceNotificationImpl(localContainerID, 1, serviceInfo));
                    ++i;
                }
            }
        }
    }

    void handleServiceUndiscovered(ID localContainerID, IServiceInfo serviceInfo) {
        IServiceID serviceID = serviceInfo.getServiceID();
        if (this.matchServiceID(serviceID)) {
            this.trace("handleOSGIServiceUndiscovered", "serviceID=" + serviceID);
            DiscoveredServiceTracker[] discoveredTrackers = this.findMatchingDiscoveredServiceTrackers(serviceInfo);
            if (discoveredTrackers != null) {
                int i = 0;
                while (i < discoveredTrackers.length) {
                    discoveredTrackers[i].serviceChanged((DiscoveredServiceNotification)new DiscoveredServiceNotificationImpl(localContainerID, 4, serviceInfo));
                    ++i;
                }
            }
        }
    }

    private DiscoveredServiceTracker[] findMatchingDiscoveredServiceTrackers(IServiceInfo serviceInfo) {
        ServiceReference[] sourceTrackers = Activator.getDefault().getDiscoveredServiceTrackerReferences();
        if (sourceTrackers == null) {
            return null;
        }
        ArrayList<Object> matchingTrackers = new ArrayList<Object>();
        int i = 0;
        while (i < sourceTrackers.length) {
            if (this.matchWithDiscoveredServiceInfo(sourceTrackers[i], serviceInfo)) {
                matchingTrackers.add(Activator.getDefault().getContext().getService(sourceTrackers[i]));
            }
            ++i;
        }
        return matchingTrackers.toArray(new DiscoveredServiceTracker[0]);
    }

    private boolean matchWithDiscoveredServiceInfo(ServiceReference serviceReference, IServiceInfo serviceInfo) {
        return true;
    }

    private boolean matchServiceID(IServiceID serviceId) {
        return Arrays.asList(serviceId.getServiceTypeID().getServices()).contains("osgiservices");
    }

    public ServiceReference[] getPublishedServices() {
        return this.serviceInfos.keySet().toArray(new ServiceReference[0]);
    }

    IServiceInfo addServiceInfo(ServiceReference sr, IServiceInfo si) {
        return this.serviceInfos.put(sr, si);
    }

    IServiceInfo removeServiceInfo(ServiceReference sr) {
        return (IServiceInfo)this.serviceInfos.remove(sr);
    }

    IServiceInfo getServiceInfo(ServiceReference sr) {
        return (IServiceInfo)this.serviceInfos.get(sr);
    }

    public Object addingService(ServiceReference reference) {
        ServicePublication servicePublication = (ServicePublication)Activator.getDefault().getContext().getService(reference);
        this.addServicePublication(reference, servicePublication);
        return servicePublication;
    }

    private void addServicePublication(ServiceReference reference, ServicePublication servicePublication) {
        Collection svcInterfaces = ServicePropertyUtils.getCollectionProperty(reference, "service.interface");
        if (svcInterfaces == null) {
            this.trace("createServiceInfo", "svcInterfaces=" + svcInterfaces + " is null or not instance of Collection as specified by RFC119");
            return;
        }
        Collection interfaceVersions = ServicePropertyUtils.getCollectionProperty(reference, "service.interface.version");
        Collection endpointInterfaces = ServicePropertyUtils.getCollectionProperty(reference, "osgi.remote.endpoint.interface");
        Map svcProperties = ServicePropertyUtils.getMapProperty(reference, "service.properties");
        URL location = ServicePropertyUtils.getURLProperty(reference, "osgi.remote.endpoint.location");
        String id = ServicePropertyUtils.getStringProperty(reference, "osgi.remote.endpoint.id");
        IServiceInfo svcInfo = null;
        try {
            svcInfo = this.createServiceInfo(reference, svcInterfaces, interfaceVersions, endpointInterfaces, svcProperties, location, id);
        }
        catch (IDCreateException e) {
            this.traceException("addServicePublication", e);
        }
        if (svcInfo == null) {
            this.trace("addServicePublication", "svcInfo is null, so no service published");
        } else {
            this.publishService(reference, svcInfo);
        }
    }

    protected IServiceInfo createServiceInfo(ServiceReference serviceReference, Collection svcInterfaces, Collection interfaceVersions, Collection endpointInterfaces, Map svcProperties, URL location, String id) throws IDCreateException {
        IServiceID serviceID = this.createServiceID(serviceReference);
        if (serviceID == null) {
            return null;
        }
        URI uri = this.createURI(location);
        IServiceProperties serviceProperties = this.createServiceProperties(svcInterfaces, interfaceVersions, endpointInterfaces, svcProperties, location, id);
        return new ServiceInfo(uri, serviceID, serviceProperties);
    }

    protected IServiceProperties createServiceProperties(Collection svcInterfaces, Collection interfaceVersions, Collection endpointInterfaces, Map svcProperties, URL location, String id) {
        ServiceProperties serviceProperties = new ServiceProperties();
        if (svcInterfaces != null) {
            serviceProperties.setProperty("service.interface", (Object)ServicePropertyUtils.createStringFromCollection(svcInterfaces));
        }
        if (interfaceVersions != null) {
            serviceProperties.setProperty("service.interface.version", (Object)ServicePropertyUtils.createStringFromCollection(interfaceVersions));
        }
        if (endpointInterfaces != null) {
            serviceProperties.setProperty("osgi.remote.endpoint.interface", (Object)ServicePropertyUtils.createStringFromCollection(endpointInterfaces));
        }
        if (svcProperties != null) {
            Iterator i = svcProperties.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                Object val = svcProperties.get(key);
                if (val instanceof String) {
                    serviceProperties.setProperty(key, (Object)((String)val));
                    continue;
                }
                if (val instanceof byte[]) {
                    serviceProperties.setProperty(key, (Object)((byte[])val));
                    continue;
                }
                serviceProperties.setProperty(key, val);
            }
        }
        if (location != null) {
            serviceProperties.setProperty("osgi.remote.endpoint.location", (Object)location.toExternalForm());
        }
        if (id != null) {
            serviceProperties.setProperty("osgi.remote.endpoint.id", (Object)id);
        }
        return serviceProperties;
    }

    protected URI createURI(URL location) {
        String locationStr = null;
        try {
            locationStr = location == null ? "unknown" : URLEncoder.encode(location.toExternalForm(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return URI.create("osgiservices:" + locationStr);
    }

    private void traceException(String string, Throwable e) {
        Trace.catching((String)"org.eclipse.ecf.osgi.services.discovery", (String)"org.eclipse.ecf.osgi.services.discovery/debug/exceptions/catching", this.getClass(), (String)string, (Throwable)e);
    }

    private synchronized IDiscoveryService getDiscovery() {
        try {
            if (this.discovery == null) {
                this.discovery = Activator.getDefault().getDiscoveryService();
                this.discovery.addServiceListener(this.serviceListener);
            }
        }
        catch (InterruptedException e) {
            this.traceException("getDiscovery", e);
        }
        return this.discovery;
    }

    protected IServiceID createServiceID(ServiceReference serviceReference) throws IDCreateException {
        IDiscoveryService d = this.getDiscovery();
        if (d == null) {
            return null;
        }
        String namingAuthority = ServicePropertyUtils.getStringProperty(serviceReference, "ecf.naming.authority", "_IANA");
        String scope = ServicePropertyUtils.getStringProperty(serviceReference, "ecf.scope", "local");
        String protocol = ServicePropertyUtils.getStringProperty(serviceReference, "ecf.protocol", "tcp");
        String serviceName = ServicePropertyUtils.getStringProperty(serviceReference, "ecf.service.name", this.getDefaultServiceName(serviceReference));
        String serviceType = "_osgiservices._" + protocol + "." + scope + "." + namingAuthority;
        return ServiceIDFactory.getDefault().createServiceID(this.discovery.getServicesNamespace(), serviceType, serviceName);
    }

    private String getDefaultServiceName(ServiceReference serviceReference) {
        return "service." + serviceReference.getProperty("service.id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishService(ServiceReference reference, IServiceInfo svcInfo) {
        Map map = this.serviceInfos;
        synchronized (map) {
            try {
                this.addServiceInfo(reference, svcInfo);
                this.trace("publishService", "publishing serviceReference=" + reference + ", svcInfo=" + svcInfo);
                this.discovery.registerService(svcInfo);
            }
            catch (ECFRuntimeException e) {
                this.traceException("publishService", e);
                this.removeServiceInfo(reference);
            }
        }
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.unpublishService(reference);
        this.addServicePublication(reference, (ServicePublication)service);
    }

    public void removedService(ServiceReference reference, Object service) {
        this.unpublishService(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpublishService(ServiceReference reference) {
        Map map = this.serviceInfos;
        synchronized (map) {
            try {
                IServiceInfo svcInfo = this.removeServiceInfo(reference);
                if (svcInfo != null) {
                    this.discovery.unregisterService(svcInfo);
                }
            }
            catch (ECFRuntimeException e) {
                this.traceException("publishService", e);
            }
        }
    }

    protected void trace(String methodName, String message) {
        Trace.trace((String)"org.eclipse.ecf.osgi.services.discovery", (String)"org.eclipse.ecf.osgi.services.discovery/debug/servicepublication", this.getClass(), (String)methodName, (String)message);
    }

    public void dispose() {
        if (this.discovery != null) {
            this.discovery.removeServiceListener(this.serviceListener);
            Iterator i = this.serviceInfos.keySet().iterator();
            while (i.hasNext()) {
                ServiceReference sr = (ServiceReference)i.next();
                this.unpublishService(sr);
            }
            this.serviceInfos.clear();
            this.discovery = null;
        }
    }
}

