/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.distribution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.osgi.services.distribution.Activator;
import org.eclipse.ecf.internal.osgi.services.distribution.DistributionProviderImpl;
import org.eclipse.ecf.remoteservice.IRemoteServiceRegistration;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.service.EventHook;

public abstract class AbstractEventHookImpl
implements EventHook {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final DistributionProviderImpl distributionProvider;
    private final Map srvRefToRemoteSrvRegistration = new HashMap();

    public AbstractEventHookImpl(DistributionProviderImpl distributionProvider) {
        this.distributionProvider = distributionProvider;
    }

    public void event(ServiceEvent event, Collection contexts) {
        switch (event.getType()) {
            case 2: {
                this.handleModifiedServiceEvent(event.getServiceReference(), contexts);
                break;
            }
            case 8: {
                break;
            }
            case 1: {
                this.handleRegisteredServiceEvent(event.getServiceReference(), contexts);
                break;
            }
            case 4: {
                this.handleUnregisteringServiceEvent(event.getServiceReference(), contexts);
                break;
            }
        }
    }

    void handleRegisteredServiceEvent(ServiceReference serviceReference, Collection contexts) {
        Object osgiRemotes = serviceReference.getProperty("osgi.remote.interfaces");
        if (osgiRemotes != null) {
            String[] remoteInterfaces;
            String[] remoteInterfacesArr = (String[])(osgiRemotes instanceof String[] ? osgiRemotes : null);
            if (remoteInterfacesArr == null) {
                this.trace("handleRegisteredServiceEvent", "remoteInterfaces not of String [] type as required by RFC 119");
                return;
            }
            this.trace("handleRegisteredServiceEvent", "serviceReference=" + serviceReference + " has remoteInterfaces=" + Arrays.asList(remoteInterfacesArr));
            String[] stringArray = remoteInterfaces = remoteInterfacesArr != null ? this.getInterfacesForServiceReference(remoteInterfacesArr, serviceReference) : null;
            if (remoteInterfaces == null) {
                this.trace("handleRegisteredServiceEvent", "No exposed remoteInterfaces found for serviceReference=" + serviceReference);
                return;
            }
            Object osgiRemoteConfigurationType = serviceReference.getProperty("osgi.remote.configuration.type");
            String[] remoteConfigurationType = null;
            if (osgiRemoteConfigurationType != null) {
                if (!(osgiRemoteConfigurationType instanceof String[])) {
                    this.trace("handleRegisteredServiceEvent", "osgi.remote.configuration.type is not String[] as required by RFC 119");
                    return;
                }
                remoteConfigurationType = (String[])osgiRemoteConfigurationType;
            }
            this.registerRemoteService(serviceReference, remoteInterfaces, remoteConfigurationType);
        }
    }

    protected abstract void registerRemoteService(ServiceReference var1, String[] var2, String[] var3);

    protected void fireRemoteServiceRegistered(ServiceReference serviceReference, IRemoteServiceRegistration remoteServiceRegistration) {
        this.srvRefToRemoteSrvRegistration.put(serviceReference, remoteServiceRegistration);
        this.distributionProvider.addExposedService(serviceReference);
    }

    private String[] getInterfacesForServiceReference(String[] remoteInterfaces, ServiceReference serviceReference) {
        if (remoteInterfaces == null || remoteInterfaces.length == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> results = new ArrayList<String>();
        List<String> interfaces = Arrays.asList((String[])serviceReference.getProperty("objectClass"));
        int i = 0;
        while (i < remoteInterfaces.length) {
            String intf = remoteInterfaces[i];
            if ("*".equals(intf)) {
                return interfaces.toArray(new String[0]);
            }
            if (intf != null && interfaces.contains(intf)) {
                results.add(intf);
            }
            ++i;
        }
        return results.toArray(new String[0]);
    }

    protected void trace(String methodName, String message) {
        Trace.trace((String)"org.eclipse.ecf.osgi.services.distribution", (String)"org.eclipse.ecf.osgi.services.distribution/debug/eventhook", this.getClass(), (String)methodName, (String)message);
    }

    protected void handleUnregisteringServiceEvent(ServiceReference serviceReference, Collection contexts) {
        IRemoteServiceRegistration remoteRegistration = this.removeRemoteRegistration(serviceReference);
        if (remoteRegistration != null) {
            this.trace("handleUnregisteringServiceEvent", "found serviceRegistration=" + remoteRegistration);
            this.distributionProvider.removeRemoteService(serviceReference);
            remoteRegistration.unregister();
        }
    }

    private IRemoteServiceRegistration removeRemoteRegistration(ServiceReference serviceReference) {
        return (IRemoteServiceRegistration)this.srvRefToRemoteSrvRegistration.remove(serviceReference);
    }

    protected void handleModifiedServiceEvent(ServiceReference serviceReference, Collection contexts) {
    }

    protected Object getService(ServiceReference sr) {
        return Activator.getDefault().getContext().getService(sr);
    }
}

