/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.distribution;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.internal.osgi.services.distribution.DistributionProviderImpl;
import org.eclipse.ecf.internal.osgi.services.distribution.EventHookImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.ecf.osgi.services.distribution";
    private static Activator plugin;
    private BundleContext context;
    private ServiceRegistration eventHookRegistration;
    private ServiceRegistration distributionProviderRegistration;
    private ServiceRegistration listenerHookRegistration;
    private DistributionProviderImpl distributionProvider;
    private ServiceTracker containerManagerTracker;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static Activator getDefault() {
        return plugin;
    }

    public BundleContext getContext() {
        return this.context;
    }

    public void start(BundleContext ctxt) throws Exception {
        plugin = this;
        this.context = ctxt;
        this.distributionProvider = new DistributionProviderImpl();
        this.addServiceRegistryHooks();
        this.addDistributionProvider();
    }

    private void addServiceRegistryHooks() {
        EventHookImpl hook = new EventHookImpl(this.distributionProvider);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.framework.hooks.service.EventHook");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.eventHookRegistration = this.context.registerService(clazz.getName(), (Object)hook, null);
        try {
            ServiceReference[] refs = this.context.getServiceReferences(null, "(osgi.remote.interfaces=*)");
            if (refs != null) {
                int i = 0;
                while (i < refs.length) {
                    hook.handleRegisteredServiceEvent(refs[i], null);
                    ++i;
                }
            }
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
    }

    private void addDistributionProvider() {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("osgi.remote.distribution.vendor", DistributionProviderImpl.VENDOR_NAME);
        ((Dictionary)properties).put("osgi.remote.distribution.product", DistributionProviderImpl.PRODUCT_NAME);
        ((Dictionary)properties).put("osgi.remote.distribution.product.version", DistributionProviderImpl.PRODUCT_VERSION);
        ((Dictionary)properties).put("osgi.remote.distribition.supported_intents", this.distributionProvider.getSupportedIntents());
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.osgi.service.distribution.DistributionProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.distributionProviderRegistration = this.context.registerService(clazz.getName(), (Object)this.distributionProvider, properties);
    }

    private void removeServiceRegistryHooks() {
        if (this.eventHookRegistration != null) {
            this.eventHookRegistration.unregister();
            this.eventHookRegistration = null;
        }
        if (this.listenerHookRegistration != null) {
            this.listenerHookRegistration.unregister();
            this.listenerHookRegistration = null;
        }
    }

    private void removeDistributionProvider() {
        if (this.distributionProviderRegistration != null) {
            this.distributionProviderRegistration.unregister();
            this.distributionProviderRegistration = null;
        }
    }

    public void stop(BundleContext ctxt) throws Exception {
        this.removeDistributionProvider();
        this.removeServiceRegistryHooks();
        if (this.containerManagerTracker != null) {
            this.containerManagerTracker.close();
            this.containerManagerTracker = null;
        }
        this.distributionProvider = null;
        this.context = null;
        plugin = null;
    }

    public IContainerManager getContainerManager() {
        if (this.containerManagerTracker == null) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.ecf.core.IContainerManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.containerManagerTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.containerManagerTracker.open();
        }
        return (IContainerManager)this.containerManagerTracker.getService();
    }
}

