/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.distribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.osgi.services.distribution.Activator;
import org.eclipse.ecf.internal.osgi.services.distribution.DistributionProviderImpl;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.equinox.concurrent.future.IFuture;
import org.eclipse.equinox.concurrent.future.TimeoutException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.discovery.DiscoveredServiceNotification;
import org.osgi.service.discovery.DiscoveredServiceTracker;
import org.osgi.service.discovery.ServiceEndpointDescription;

public class DiscoveredServiceTrackerImpl
implements DiscoveredServiceTracker {
    DistributionProviderImpl distributionProvider;
    Map serviceRegistrationMap = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$0;

    public DiscoveredServiceTrackerImpl(DistributionProviderImpl dp) {
        this.distributionProvider = dp;
    }

    public void serviceChanged(DiscoveredServiceNotification notification) {
        if (notification == null) {
            this.logError("DiscoveredServiceNotification is null", null);
            return;
        }
        Trace.entering((String)"org.eclipse.ecf.osgi.services.distribution", (String)"org.eclipse.ecf.osgi.services.distribution/debug", this.getClass(), (String)"serviceChanged", (Object)notification);
        int notificationType = notification.getType();
        switch (notificationType) {
            case 1: {
                this.handleDiscoveredServiceAvailable(notification.getServiceEndpointDescription());
                break;
            }
            case 4: {
                this.handleDiscoveredServiceUnavailable(notification.getServiceEndpointDescription());
                break;
            }
            case 2: {
                this.handleDiscoveredServiceModified(notification.getServiceEndpointDescription());
                break;
            }
            case 8: {
                this.handleDiscoveredServiceModifiedEndmatch(notification.getServiceEndpointDescription());
                break;
            }
            default: {
                this.logError("DiscoveredServiceNotification type=" + notificationType + " not found", null);
            }
        }
    }

    private IContainerManager getContainerManager() {
        return Activator.getDefault().getContainerManager();
    }

    private void handleDiscoveredServiceModifiedEndmatch(ServiceEndpointDescription description) {
    }

    private void handleDiscoveredServiceModified(ServiceEndpointDescription description) {
    }

    private void handleDiscoveredServiceUnavailable(ServiceEndpointDescription description) {
    }

    private void handleDiscoveredServiceAvailable(ServiceEndpointDescription description) {
        Collection providedInterfaces = description.getProvidedInterfaces();
        if (providedInterfaces == null) {
            this.logError("ServiceEndpointDescription providedInterfaces is null", null);
            return;
        }
        IRemoteServiceContainerAdapter[] rscas = this.findRSCAs(description);
        if (rscas == null) {
            this.logError("No RemoteServiceContainerAdapters found for description " + description, null);
            return;
        }
        int i = 0;
        while (i < rscas.length) {
            Iterator j = providedInterfaces.iterator();
            while (j.hasNext()) {
                String providedInterface = (String)j.next();
                IFuture futureRemoteReferences = rscas[i].asyncGetRemoteServiceReferences(this.createContainerIDsForQuery(description), providedInterface, this.getRemoteFilterForQuery(description));
                this.processFutureForRemoteServiceReferences(futureRemoteReferences, rscas[i], description, this.getTimeout(description));
            }
            ++i;
        }
    }

    private String getRemoteFilterForQuery(ServiceEndpointDescription description) {
        return null;
    }

    long getTimeout(ServiceEndpointDescription description) {
        return 30000L;
    }

    private void processFutureForRemoteServiceReferences(final IFuture futureRemoteReferences, final IRemoteServiceContainerAdapter rsca, final ServiceEndpointDescription description, final long timeout) {
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    IRemoteServiceReference[] remoteReferences = (IRemoteServiceReference[])futureRemoteReferences.get(timeout);
                    IStatus futureStatus = futureRemoteReferences.getStatus();
                    if (futureStatus.isOK() && remoteReferences != null && remoteReferences.length > 0) {
                        DiscoveredServiceTrackerImpl.this.registerRemoteServiceReferences(rsca, remoteReferences, description);
                    } else {
                        DiscoveredServiceTrackerImpl.this.logFutureError(futureStatus);
                    }
                }
                catch (InterruptedException e) {
                    DiscoveredServiceTrackerImpl.this.logError("Retrieval of remote references interrupted", e);
                }
                catch (OperationCanceledException e) {
                    DiscoveredServiceTrackerImpl.this.logError("Retrieval of remote references cancelled", e);
                }
                catch (TimeoutException e) {
                    DiscoveredServiceTrackerImpl.this.logError("Retrieval of remote references timedout after " + e.getDuration(), e);
                }
            }
        });
        t.start();
    }

    void logFutureError(IStatus futureStatus) {
        this.logError("Future error: " + futureStatus.getMessage(), futureStatus.getException());
    }

    private ServiceRegistration getRemoteServiceRegistration(IRemoteServiceReference reference) {
        return null;
    }

    private ServiceRegistration addRemoteServiceRegistration(IRemoteServiceReference ref, ServiceRegistration registration) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerRemoteServiceReferences(IRemoteServiceContainerAdapter rsca, IRemoteServiceReference[] remoteReferences, ServiceEndpointDescription description) {
        int i = 0;
        while (i < remoteReferences.length) {
            block13: {
                IRemoteService remoteService = rsca.getRemoteService(remoteReferences[i]);
                if (remoteService == null) {
                    this.logError("remote service is null for remote reference " + remoteReferences[i], null);
                } else {
                    String[] clazzes = this.getClazzesForRemoteServiceReference(remoteReferences[i], description);
                    if (clazzes == null) {
                        this.logError("no classes specified for remote service reference " + remoteReferences[i], null);
                    } else {
                        Dictionary properties = this.getPropertiesForRemoteServiceReference(remoteReferences[i], description);
                        Object proxy = null;
                        try {
                            proxy = remoteService.getProxy();
                        }
                        catch (ECFException e) {
                            this.logError("Exception creating proxy for remote service reference " + remoteReferences[i], e);
                            break block13;
                        }
                        BundleContext bundleContext = Activator.getDefault().getContext();
                        Map map = this.serviceRegistrationMap;
                        synchronized (map) {
                            ServiceRegistration reg = this.getRemoteServiceRegistration(remoteReferences[i]);
                            if (reg != null) {
                                this.logError("remote reference " + remoteReferences + " already registered locally", null);
                                break block13;
                            }
                            try {
                                ServiceRegistration registration = bundleContext.registerService(clazzes, proxy, properties);
                                this.addRemoteServiceRegistration(remoteReferences[i], registration);
                            }
                            catch (Exception e) {
                                this.logError("Error registering for remote reference " + remoteReferences[i], e);
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    private Dictionary getPropertiesForRemoteServiceReference(IRemoteServiceReference remoteServiceReference, ServiceEndpointDescription description) {
        return null;
    }

    private String[] getClazzesForRemoteServiceReference(IRemoteServiceReference iRemoteServiceReference, ServiceEndpointDescription description) {
        return null;
    }

    private ID[] createContainerIDsForQuery(ServiceEndpointDescription description) {
        return null;
    }

    private IRemoteServiceContainerAdapter[] findRSCAs(ServiceEndpointDescription description) {
        IContainerManager containerManager = this.getContainerManager();
        if (containerManager == null) {
            return null;
        }
        IContainer[] containers = containerManager.getAllContainers();
        if (containers == null) {
            return null;
        }
        ArrayList<IRemoteServiceContainerAdapter> results = new ArrayList<IRemoteServiceContainerAdapter>();
        int i = 0;
        while (i < containers.length) {
            IRemoteServiceContainerAdapter adapter;
            IContainer iContainer = containers[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (IRemoteServiceContainerAdapter)iContainer.getAdapter((Class)clazz)) != null && this.includeRCSAForDescription(containers[i], adapter, description)) {
                results.add(adapter);
            }
            ++i;
        }
        return results.toArray(new IRemoteServiceContainerAdapter[0]);
    }

    private boolean includeRCSAForDescription(IContainer container, IRemoteServiceContainerAdapter adapter, ServiceEndpointDescription description) {
        Namespace namespace;
        String namespaceName = (String)description.getProperty("rsvc.ns");
        if (namespaceName != null && (namespace = adapter.getRemoteServiceNamespace()).getName().equals(namespaceName)) {
            return true;
        }
        return true;
    }

    private void logError(String string, Throwable t) {
        System.err.println(string);
        if (t != null) {
            t.printStackTrace(System.err);
        }
    }
}

