/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.distribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.osgi.services.distribution.AbstractEventHookImpl;
import org.eclipse.ecf.internal.osgi.services.distribution.Activator;
import org.eclipse.ecf.internal.osgi.services.distribution.DistributionProviderImpl;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.IRemoteServiceRegistration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.discovery.ServicePublication;

public class EventHookImpl
extends AbstractEventHookImpl {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public EventHookImpl(DistributionProviderImpl distributionProvider) {
        super(distributionProvider);
    }

    protected void registerRemoteService(ServiceReference serviceReference, String[] remoteInterfaces, String[] remoteConfigurationType) {
        Map ecfConfiguration = this.parseECFConfigurationType(remoteConfigurationType);
        IRemoteServiceContainerAdapter[] rscas = this.findRemoteServiceContainerAdapters(serviceReference, ecfConfiguration);
        if (rscas == null) {
            this.trace("registerRemoteService", "No remote service container adapters found for serviceReference=" + serviceReference + " and configuration=" + ecfConfiguration);
            return;
        }
        int i = 0;
        while (i < rscas.length) {
            IRemoteServiceRegistration remoteRegistration = rscas[i].registerRemoteService(remoteInterfaces, this.getService(serviceReference), this.createPropertiesForRemoteService(rscas[i], remoteInterfaces, serviceReference));
            this.trace("registerRemoteService", "REGISTERED REMOTE SERVICE serviceReference=" + serviceReference + " remoteRegistration=" + remoteRegistration);
            this.fireRemoteServiceRegistered(serviceReference, remoteRegistration);
            this.publishRemoteService(rscas[i], serviceReference, remoteInterfaces);
            ++i;
        }
    }

    private void publishRemoteService(IRemoteServiceContainerAdapter rsca, ServiceReference ref, String[] remoteInterfaces) {
        IContainer container;
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        BundleContext context = Activator.getDefault().getContext();
        ((Dictionary)properties).put("service.interface", this.getAsCollection(remoteInterfaces));
        ((Dictionary)properties).put("service.properties", this.getServiceProperties(ref));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.core.IContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((container = (IContainer)rsca.getAdapter((Class)clazz)) != null) {
            ((Dictionary)properties).put("osgi.remote.endpoint.id", container.getID().toString());
        }
        ((Dictionary)properties).put("rsvc.ns", rsca.getRemoteServiceNamespace().getName());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.osgi.service.discovery.ServicePublication");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        context.registerService(clazz2.getName(), (Object)new ServicePublication(){}, properties);
        this.trace("publishRemoteService", "PUBLISH REMOTE SERVICE serviceReference=" + ref + " properties=" + properties);
    }

    private Collection getAsCollection(String[] remoteInterfaces) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < remoteInterfaces.length) {
            result.add(remoteInterfaces[i]);
            ++i;
        }
        return result;
    }

    private Map getServiceProperties(ServiceReference ref) {
        String[] keys = ref.getPropertyKeys();
        HashMap<String, Object> map = new HashMap<String, Object>(keys.length);
        int i = 0;
        while (i < keys.length) {
            map.put(keys[i], ref.getProperty(keys[i]));
            ++i;
        }
        return map;
    }

    private Map parseECFConfigurationType(String[] remoteConfigurationType) {
        HashMap results = new HashMap();
        return results;
    }

    protected Collection registerRemoteService(IRemoteServiceContainerAdapter[] rscas, String[] remoteInterfaces, ServiceReference sr) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < rscas.length) {
            IRemoteServiceRegistration remoteRegistration = rscas[i].registerRemoteService(remoteInterfaces, this.getService(sr), this.createPropertiesForRemoteService(rscas[i], remoteInterfaces, sr));
            this.trace("registerRemoteService", "REGISTERED REMOTE SERVICE serviceReference=" + sr + " remoteRegistration=" + remoteRegistration);
            result.add(remoteRegistration.getContainerID().toString());
            this.fireRemoteServiceRegistered(sr, remoteRegistration);
            ++i;
        }
        return result;
    }

    protected Dictionary createPropertiesForRemoteService(IRemoteServiceContainerAdapter iRemoteServiceContainerAdapter, String[] remotes, ServiceReference sr) {
        String[] propKeys = sr.getPropertyKeys();
        Properties newProps = new Properties();
        int i = 0;
        while (i < propKeys.length) {
            newProps.put(propKeys[i], sr.getProperty(propKeys[i]));
            ++i;
        }
        return newProps;
    }

    protected IRemoteServiceContainerAdapter[] findRemoteServiceContainerAdapters(ServiceReference serviceReference, Map ecfConfiguration) {
        IContainerManager containerManager = Activator.getDefault().getContainerManager();
        return containerManager != null ? this.getRSCAsFromContainers(containerManager.getAllContainers(), serviceReference, ecfConfiguration) : null;
    }

    private IRemoteServiceContainerAdapter[] getRSCAsFromContainers(IContainer[] containers, ServiceReference serviceReference, Map ecfConfiguration) {
        if (containers == null) {
            return null;
        }
        ArrayList<IRemoteServiceContainerAdapter> rscas = new ArrayList<IRemoteServiceContainerAdapter>();
        int i = 0;
        while (i < containers.length) {
            IRemoteServiceContainerAdapter rsca;
            IContainer iContainer = containers[i];
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((rsca = (IRemoteServiceContainerAdapter)iContainer.getAdapter((Class)clazz)) == null) {
                Trace.trace((String)"org.eclipse.ecf.osgi.services.distribution", (String)"org.eclipse.ecf.osgi.services.distribution/debug", this.getClass(), (String)"getRCSAsFromContainers", (String)("Container=" + containers[i] + " not an IRemoteServiceContainerAdapter. Excluding rsca=" + rsca + " from remote registration"));
            } else if (this.includeContainer(containers[i], rsca, serviceReference, ecfConfiguration)) {
                rscas.add(rsca);
            }
            ++i;
        }
        return rscas.toArray(new IRemoteServiceContainerAdapter[0]);
    }

    protected boolean includeContainer(IContainer container, IRemoteServiceContainerAdapter rsca, ServiceReference serviceReference, Map ecfConfiguration) {
        Object cID = serviceReference.getProperty("rsvc.cid");
        if (cID == null || !(cID instanceof ID)) {
            Trace.trace((String)"org.eclipse.ecf.osgi.services.distribution", (String)"org.eclipse.ecf.osgi.services.distribution/debug", this.getClass(), (String)"includeContainer", (String)("serviceReference=" + serviceReference + " does not set remote service container id service property.  INCLUDING containerID=" + container.getID() + " in remote registration"));
            return true;
        }
        ID containerID = (ID)cID;
        if (container.getID().equals((Object)containerID)) {
            Trace.trace((String)"org.eclipse.ecf.osgi.services.distribution", (String)"org.eclipse.ecf.osgi.services.distribution/debug", this.getClass(), (String)"includeContainer", (String)("serviceReference=" + serviceReference + " has MATCHING container id=" + containerID + ".  INCLUDING rsca=" + rsca + " in remote registration"));
            return true;
        }
        Trace.trace((String)"org.eclipse.ecf.osgi.services.distribution", (String)"org.eclipse.ecf.osgi.services.distribution/debug", this.getClass(), (String)"includeContainer", (String)("serviceReference=" + serviceReference + " has non-matching container id=" + containerID + ".  EXCLUDING rsca=" + rsca + " in remote registration"));
        return false;
    }
}

