/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.httpclient;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Socket;
import java.net.URL;
import java.util.Iterator;
import javax.security.auth.login.LoginException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.util.DateUtil;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.security.Callback;
import org.eclipse.ecf.core.security.CallbackHandler;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.security.NameCallback;
import org.eclipse.ecf.core.security.ObjectCallback;
import org.eclipse.ecf.core.security.UnsupportedCallbackException;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.core.util.ProxyAddress;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.filetransfer.IRemoteFile;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemListener;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemRequest;
import org.eclipse.ecf.filetransfer.events.socket.ISocketEventSource;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient.ConnectingSocketMonitor;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient.Messages;
import org.eclipse.ecf.provider.filetransfer.browse.AbstractFileSystemBrowser;
import org.eclipse.ecf.provider.filetransfer.browse.URLRemoteFile;
import org.eclipse.ecf.provider.filetransfer.events.socket.SocketEventSource;
import org.eclipse.ecf.provider.filetransfer.httpclient.HttpClientRetrieveFileTransfer;
import org.eclipse.ecf.provider.filetransfer.util.JREProxyHelper;
import org.eclipse.osgi.util.NLS;

public class HttpClientFileSystemBrowser
extends AbstractFileSystemBrowser {
    protected static final int DEFAULT_CONNECTION_TIMEOUT = 30000;
    private static final String USERNAME_PREFIX = "Username:";
    private JREProxyHelper proxyHelper = null;
    private ConnectingSocketMonitor connectingSockets;
    protected String username = null;
    protected String password = null;
    protected HttpClient httpClient = null;
    protected volatile HeadMethod headMethod;
    protected HttpClientRetrieveFileTransfer.HostConfigHelper hostConfigHelper;
    static /* synthetic */ Class class$0;

    public HttpClientFileSystemBrowser(HttpClient httpClient, IFileID directoryOrFileID, IRemoteFileSystemListener listener, URL directoryOrFileURL, IConnectContext connectContext, Proxy proxy) {
        super(directoryOrFileID, listener, directoryOrFileURL, connectContext, proxy);
        Assert.isNotNull((Object)httpClient);
        this.httpClient = httpClient;
        this.proxyHelper = new JREProxyHelper();
        this.connectingSockets = new ConnectingSocketMonitor(1);
    }

    protected IRemoteFileSystemRequest createRemoteFileSystemRequest() {
        return new HttpClientRemoteFileSystemRequest();
    }

    protected void cancel() {
        if (this.isCanceled()) {
            return;
        }
        this.setCanceled(this.getException());
        super.cancel();
        if (this.headMethod != null && !this.headMethod.isAborted()) {
            this.headMethod.abort();
        }
        if (this.connectingSockets != null) {
            Iterator iterator = this.connectingSockets.getConnectingSockets().iterator();
            while (iterator.hasNext()) {
                Socket socket = (Socket)iterator.next();
                try {
                    socket.close();
                }
                catch (IOException e) {
                    Trace.catching((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)"org.eclipse.ecf.provider.filetransfer.httpclient/debug/exceptions/catching", ((Object)((Object)this)).getClass(), (String)"cancel", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runRequest() throws Exception {
        Trace.entering((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)"org.eclipse.ecf.provider.filetransfer.httpclient/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"runRequest");
        this.setupProxies();
        this.httpClient.getHttpConnectionManager().getParams().setSoTimeout(30000);
        this.httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(30000);
        String urlString = this.directoryOrFile.toString();
        this.setupAuthentication(urlString);
        this.setupHostAndPort(urlString);
        this.headMethod = new HeadMethod(this.hostConfigHelper.getTargetRelativePath());
        this.headMethod.setFollowRedirects(true);
        this.headMethod.getParams().setParameter("http.authentication.credential-provider", (Object)new ECFCredentialsProvider());
        this.headMethod.addRequestHeader("Cache-Control", "max-age=0");
        long lastModified = 0L;
        long fileLength = -1L;
        this.connectingSockets.clear();
        try {
            try {
                Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)("browse=" + urlString));
                int code = this.httpClient.executeMethod(this.getHostConfiguration(), (HttpMethod)this.headMethod);
                Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)("browse resp=" + code));
                if (code != 200) {
                    if (code == 404) {
                        throw new FileNotFoundException(urlString);
                    }
                    if (code == 401) {
                        throw new LoginException(Messages.HttpClientRetrieveFileTransfer_Unauthorized);
                    }
                    if (code == 403) {
                        throw new LoginException("Forbidden");
                    }
                    if (code != 407) throw new IOException(NLS.bind((String)Messages.HttpClientRetrieveFileTransfer_ERROR_GENERAL_RESPONSE_CODE, (Object)new Integer(code)));
                    throw new LoginException(Messages.HttpClientRetrieveFileTransfer_Proxy_Auth_Required);
                }
                fileLength = this.headMethod.getResponseContentLength();
                lastModified = this.getLastModifiedTimeFromHeader();
                this.remoteFiles = new IRemoteFile[1];
                this.remoteFiles[0] = new URLRemoteFile(lastModified, fileLength, this.fileID);
            }
            catch (Exception e) {
                Trace.throwing((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)"org.eclipse.ecf.provider.filetransfer.httpclient/debug/exceptions/throwing", ((Object)((Object)this)).getClass(), (String)"runRequest", (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.headMethod.releaseConnection();
            throw throwable;
        }
        {
            Object var7_8 = null;
        }
        this.headMethod.releaseConnection();
    }

    private long getLastModifiedTimeFromHeader() throws IOException {
        Header lastModifiedHeader = this.headMethod.getResponseHeader("Last-Modified");
        if (lastModifiedHeader == null) {
            return 0L;
        }
        String lastModifiedString = lastModifiedHeader.getValue();
        long lastModified = 0L;
        if (lastModifiedString != null) {
            try {
                lastModified = DateUtil.parseDate((String)lastModifiedString).getTime();
            }
            catch (Exception exception) {
                throw new IOException(Messages.HttpClientRetrieveFileTransfer_EXCEPITION_INVALID_LAST_MODIFIED_FROM_SERVER);
            }
        }
        return lastModified;
    }

    Proxy getProxy() {
        return this.proxy;
    }

    protected void setupHostAndPort(String urlString) {
        this.getHostConfiguration();
        this.hostConfigHelper.setTargetHostByURL(urlString);
    }

    protected Credentials getFileRequestCredentials() throws UnsupportedCallbackException, IOException {
        if (this.connectContext == null) {
            return null;
        }
        CallbackHandler callbackHandler = this.connectContext.getCallbackHandler();
        if (callbackHandler == null) {
            return null;
        }
        NameCallback usernameCallback = new NameCallback(USERNAME_PREFIX);
        ObjectCallback passwordCallback = new ObjectCallback();
        callbackHandler.handle(new Callback[]{usernameCallback, passwordCallback});
        this.username = usernameCallback.getName();
        this.password = (String)passwordCallback.getObject();
        return new UsernamePasswordCredentials(this.username, this.password);
    }

    protected void setupAuthentication(String urlString) throws UnsupportedCallbackException, IOException {
        Credentials credentials = null;
        if (this.username == null) {
            credentials = this.getFileRequestCredentials();
        }
        if (credentials != null && this.username != null) {
            AuthScope authScope = new AuthScope(HttpClientRetrieveFileTransfer.getHostFromURL(urlString), HttpClientRetrieveFileTransfer.getPortFromURL(urlString), AuthScope.ANY_REALM);
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)("browse credentials=" + credentials));
            this.httpClient.getState().setCredentials(authScope, credentials);
        }
    }

    private HostConfiguration getHostConfiguration() {
        if (this.hostConfigHelper == null) {
            IRemoteFileSystemRequest iRemoteFileSystemRequest = this.job.getRequest();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ecf.filetransfer.events.socket.ISocketEventSource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ISocketEventSource source = (ISocketEventSource)iRemoteFileSystemRequest.getAdapter((Class)clazz);
            this.hostConfigHelper = new HttpClientRetrieveFileTransfer.HostConfigHelper(source, this.connectingSockets);
        }
        return this.hostConfigHelper.getHostConfiguration();
    }

    protected void setupProxy(Proxy proxy) {
        if (proxy.getType().equals(Proxy.Type.HTTP)) {
            ProxyAddress address = proxy.getAddress();
            this.getHostConfiguration().setProxy(HttpClientRetrieveFileTransfer.getHostFromURL(address.getHostName()), address.getPort());
            String proxyUsername = proxy.getUsername();
            String proxyPassword = proxy.getPassword();
            if (proxyUsername != null) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                AuthScope proxyAuthScope = new AuthScope(address.getHostName(), address.getPort(), AuthScope.ANY_REALM);
                Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)("browse httpproxy=" + proxyAuthScope + ";credentials" + credentials));
                this.httpClient.getState().setProxyCredentials(proxyAuthScope, (Credentials)credentials);
            }
        } else if (proxy.getType().equals(Proxy.Type.SOCKS)) {
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)("brows socksproxy=" + proxy.getAddress()));
            this.proxyHelper.setupProxy(proxy);
        }
    }

    final class ECFCredentialsProvider
    implements CredentialsProvider {
        ECFCredentialsProvider() {
        }

        public Credentials getCredentials(AuthScheme scheme, String host, int port, boolean isProxyAuthenticating) throws CredentialsNotAvailableException {
            if ("ntlm".equalsIgnoreCase(scheme.getSchemeName())) {
                return HttpClientRetrieveFileTransfer.createNTLMCredentials(HttpClientFileSystemBrowser.this.getProxy());
            }
            return null;
        }
    }

    class HttpClientRemoteFileSystemRequest
    extends AbstractFileSystemBrowser.RemoteFileSystemRequest {
        protected SocketEventSource socketEventSource = new SocketEventSource(this){
            final /* synthetic */ HttpClientRemoteFileSystemRequest this$1;
            {
                this.this$1 = httpClientRemoteFileSystemRequest;
            }

            public Object getAdapter(Class adapter) {
                if (adapter == null) {
                    return null;
                }
                if (adapter.isInstance((Object)((Object)this))) {
                    return this;
                }
                if (adapter.isInstance((Object)((Object)this.this$1))) {
                    return this.this$1;
                }
                return null;
            }
        };

        HttpClientRemoteFileSystemRequest() {
            super((AbstractFileSystemBrowser)HttpClientFileSystemBrowser.this);
        }

        public Object getAdapter(Class adapter) {
            if (adapter == null) {
                return null;
            }
            return this.socketEventSource.getAdapter(adapter);
        }

        public void cancel() {
            HttpClientFileSystemBrowser.this.cancel();
        }
    }
}

