/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.events.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.eclipse.ecf.filetransfer.events.socket.ISocketEvent;
import org.eclipse.ecf.filetransfer.events.socket.ISocketEventSource;
import org.eclipse.ecf.filetransfer.events.socket.ISocketListener;
import org.eclipse.ecf.filetransfer.events.socketfactory.INonconnectedSocketFactory;
import org.eclipse.ecf.provider.filetransfer.events.socket.AbstractSocketWrapper;
import org.eclipse.ecf.provider.filetransfer.events.socket.SocketClosedEvent;
import org.eclipse.ecf.provider.filetransfer.events.socket.SocketConnectedEvent;
import org.eclipse.ecf.provider.filetransfer.events.socket.SocketCreatedEvent;

public class SocketEventCreateUtil {
    static void fireEvent(ISocketListener spyListener, ISocketEvent event) {
        if (spyListener != null) {
            spyListener.handleSocketEvent(event);
        }
        event.getSource().fireEvent(event);
    }

    public static Socket createSocket(final ISocketListener spyListener, final ISocketEventSource socketEventSource, INonconnectedSocketFactory unconnectedFactory, InetSocketAddress remoteInetAddress, InetSocketAddress localInetAddress, int timeout) throws IOException {
        final Socket factorySocket = unconnectedFactory.createSocket();
        SocketEventCreateUtil.fireEvent(spyListener, new SocketCreatedEvent(socketEventSource, factorySocket));
        try {
            factorySocket.bind(localInetAddress);
            factorySocket.connect(remoteInetAddress, timeout);
        }
        catch (IOException e) {
            SocketEventCreateUtil.fireEvent(spyListener, new SocketClosedEvent(socketEventSource, factorySocket, factorySocket));
            throw e;
        }
        final Socket[] wrap = new Socket[1];
        AbstractSocketWrapper myWrap = new AbstractSocketWrapper(factorySocket){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void close() throws IOException {
                try {
                    super.close();
                }
                catch (Throwable throwable) {
                    Object var1_2 = null;
                    SocketEventCreateUtil.fireEvent(spyListener, new SocketClosedEvent(socketEventSource, factorySocket, wrap[0]));
                    throw throwable;
                }
                {
                    Object var1_3 = null;
                }
                SocketEventCreateUtil.fireEvent(spyListener, new SocketClosedEvent(socketEventSource, factorySocket, wrap[0]));
            }
        };
        SocketConnectedEvent connectedEvent = new SocketConnectedEvent(socketEventSource, factorySocket, myWrap);
        SocketEventCreateUtil.fireEvent(spyListener, connectedEvent);
        wrap[0] = connectedEvent.getSocket() == myWrap ? myWrap : connectedEvent.getSocket();
        return wrap[0];
    }
}

