/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TimerTask;
import java.util.Vector;
import javax.jmdns.ServiceInfo;
import javax.jmdns.impl.DNSListener;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.DNSState;
import javax.jmdns.impl.HostInfo;
import javax.jmdns.impl.JmDNSImpl;

public class ServiceInfoImpl
extends ServiceInfo
implements DNSListener {
    private JmDNSImpl dns;
    private DNSState state = DNSState.PROBING_1;
    private TimerTask task;
    String type;
    private String name;
    String server;
    int port;
    int weight;
    int priority;
    private byte[] text;
    Hashtable props;
    InetAddress addr;

    public ServiceInfoImpl(String type, String name, int port, String text) {
        this(type, name, port, 0, 0, text);
    }

    public ServiceInfoImpl(String type, String name, int port, int weight, int priority, String text) {
        this(type, name, port, weight, priority, (byte[])null);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(text.length());
            this.writeUTF(out, text);
            byte[] data = out.toByteArray();
            this.setText(new byte[data.length + 1]);
            this.getText()[0] = (byte)data.length;
            System.arraycopy(data, 0, this.getText(), 1, data.length);
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected exception: " + e);
        }
    }

    public ServiceInfoImpl(String type, String name, int port, int weight, int priority, Hashtable props) {
        this(type, name, port, weight, priority, new byte[0]);
        if (props != null) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream(256);
                Enumeration e = props.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    Object val = props.get(key);
                    ByteArrayOutputStream out2 = new ByteArrayOutputStream(100);
                    this.writeUTF(out2, key);
                    if (val instanceof String) {
                        out2.write(61);
                        this.writeUTF(out2, (String)val);
                    } else if (val instanceof byte[]) {
                        out2.write(61);
                        byte[] bval = (byte[])val;
                        out2.write(bval, 0, bval.length);
                    } else if (val != NO_VALUE) {
                        throw new IllegalArgumentException("invalid property value: " + val);
                    }
                    byte[] data = out2.toByteArray();
                    out.write(data.length);
                    out.write(data, 0, data.length);
                }
                this.setText(out.toByteArray());
            }
            catch (IOException e) {
                throw new RuntimeException("unexpected exception: " + e);
            }
        }
    }

    public ServiceInfoImpl(String type, String name, int port, int weight, int priority, byte[] text) {
        this.type = type;
        this.name = name;
        this.port = port;
        this.weight = weight;
        this.priority = priority;
        this.setText(text);
    }

    ServiceInfoImpl(String type, String name) {
        if (!type.endsWith(".")) {
            throw new IllegalArgumentException("type must be fully qualified DNS name ending in '.': " + type);
        }
        this.type = type;
        this.name = name;
    }

    ServiceInfoImpl(ServiceInfoImpl info) {
        if (info != null) {
            this.type = info.type;
            this.name = info.name;
            this.port = info.port;
            this.weight = info.weight;
            this.priority = info.priority;
            this.setText(info.getText());
        }
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public String getQualifiedName() {
        return String.valueOf(this.name) + "." + this.type;
    }

    public String getServer() {
        return this.server;
    }

    public String getHostAddress() {
        return this.addr != null ? this.addr.getHostAddress() : "";
    }

    public InetAddress getAddress() {
        return this.addr;
    }

    public InetAddress getInetAddress() {
        return this.addr;
    }

    public int getPort() {
        return this.port;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public byte[] getTextBytes() {
        return this.getText();
    }

    public String getTextString() {
        if (this.getText() == null || this.getText().length == 0 || this.getText().length == 1 && this.getText()[0] == 0) {
            return null;
        }
        return this.readUTF(this.getText(), 0, this.getText().length);
    }

    public String getURL() {
        return this.getURL("http");
    }

    public String getURL(String protocol) {
        String url = String.valueOf(protocol) + "://" + this.getHostAddress() + ":" + this.getPort();
        String path = this.getPropertyString("path");
        if (path != null) {
            url = path.indexOf("://") >= 0 ? path : String.valueOf(url) + (path.startsWith("/") ? path : "/" + path);
        }
        return url;
    }

    public synchronized byte[] getPropertyBytes(String name) {
        return (byte[])this.getProperties().get(name);
    }

    public synchronized String getPropertyString(String name) {
        byte[] data = (byte[])this.getProperties().get(name);
        if (data == null) {
            return null;
        }
        if (data == NO_VALUE) {
            return "true";
        }
        return this.readUTF(data, 0, data.length);
    }

    public Enumeration getPropertyNames() {
        Hashtable props = this.getProperties();
        return props != null ? props.keys() : new Vector().elements();
    }

    void writeUTF(OutputStream out, String str) throws IOException {
        int i = 0;
        int len = str.length();
        while (i < len) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                out.write(c);
            } else if (c > '\u07ff') {
                out.write(0xE0 | c >> 12 & 0xF);
                out.write(0x80 | c >> 6 & 0x3F);
                out.write(0x80 | c >> 0 & 0x3F);
            } else {
                out.write(0xC0 | c >> 6 & 0x1F);
                out.write(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
    }

    String readUTF(byte[] data, int off, int len) {
        StringBuffer buf = new StringBuffer();
        int end = off + len;
        while (off < end) {
            int ch = data[off++] & 0xFF;
            switch (ch >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 12: 
                case 13: {
                    if (off >= len) {
                        return null;
                    }
                    ch = (ch & 0x1F) << 6 | data[off++] & 0x3F;
                    break;
                }
                case 14: {
                    if (off + 2 >= len) {
                        return null;
                    }
                    ch = (ch & 0xF) << 12 | (data[off++] & 0x3F) << 6 | data[off++] & 0x3F;
                    break;
                }
                default: {
                    if (off + 1 >= len) {
                        return null;
                    }
                    ch = (ch & 0x3F) << 4 | data[off++] & 0xF;
                }
            }
            buf.append((char)ch);
        }
        return buf.toString();
    }

    synchronized Hashtable getProperties() {
        if (this.props == null && this.getText() != null) {
            Hashtable<String, byte[]> props = new Hashtable<String, byte[]>();
            int off = 0;
            while (off < this.getText().length) {
                int len = this.getText()[off++] & 0xFF;
                if (len == 0 || off + len > this.getText().length) {
                    props.clear();
                    break;
                }
                int i = 0;
                while (i < len && this.getText()[off + i] != 61) {
                    ++i;
                }
                String name = this.readUTF(this.getText(), off, i);
                if (name == null) {
                    props.clear();
                    break;
                }
                if (i == len) {
                    props.put(name, NO_VALUE);
                    continue;
                }
                byte[] value = new byte[len - ++i];
                System.arraycopy(this.getText(), off + i, value, 0, len - i);
                props.put(name, value);
                off += len;
            }
            this.props = props;
        }
        return this.props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(JmDNSImpl jmdns, long now, DNSRecord rec) {
        if (rec != null && !rec.isExpired(now)) {
            switch (rec.type) {
                case 1: 
                case 28: {
                    if (!rec.name.equals(this.server)) break;
                    this.addr = ((DNSRecord.Address)rec).getAddress();
                    break;
                }
                case 33: {
                    if (!rec.name.equals(this.getQualifiedName())) break;
                    DNSRecord.Service srv = (DNSRecord.Service)rec;
                    this.server = srv.server;
                    this.port = srv.port;
                    this.weight = srv.weight;
                    this.priority = srv.priority;
                    this.addr = null;
                    this.updateRecord(jmdns, now, (DNSRecord)jmdns.getCache().get(this.server, 1, 1));
                    break;
                }
                case 16: {
                    if (!rec.name.equals(this.getQualifiedName())) break;
                    DNSRecord.Text txt = (DNSRecord.Text)rec;
                    this.setText(txt.text);
                }
            }
            if (this.hasData() && this.getDns() != null) {
                this.getDns().handleServiceResolved(this);
                this.setDns(null);
            }
            ServiceInfoImpl serviceInfoImpl = this;
            synchronized (serviceInfoImpl) {
                this.notifyAll();
            }
        }
    }

    public boolean hasData() {
        return this.server != null && this.addr != null && this.getText() != null;
    }

    public synchronized void advanceState() {
        this.state = this.state.advance();
        this.notifyAll();
    }

    synchronized void revertState() {
        this.state = this.state.revert();
        this.notifyAll();
    }

    synchronized void cancel() {
        this.state = DNSState.CANCELED;
        this.notifyAll();
    }

    public DNSState getState() {
        return this.state;
    }

    public int hashCode() {
        return this.getQualifiedName().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ServiceInfoImpl && this.getQualifiedName().equals(((ServiceInfoImpl)obj).getQualifiedName());
    }

    public String getNiceTextString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        int len = this.getText().length;
        while (i < len) {
            if (i >= 20) {
                buf.append("...");
                break;
            }
            int ch = this.getText()[i] & 0xFF;
            if (ch < 32 || ch > 127) {
                buf.append("\\0");
                buf.append(Integer.toString(ch, 8));
            } else {
                buf.append((char)ch);
            }
            ++i;
        }
        return buf.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("service[");
        buf.append(this.getQualifiedName());
        buf.append(',');
        buf.append(this.getAddress());
        buf.append(':');
        buf.append(this.port);
        buf.append(',');
        buf.append(this.getNiceTextString());
        buf.append(']');
        return buf.toString();
    }

    public void addAnswers(DNSOutgoing out, int ttl, HostInfo localHost) throws IOException {
        out.addAnswer(new DNSRecord.Pointer(this.type, 12, 1, ttl, this.getQualifiedName()), 0L);
        out.addAnswer(new DNSRecord.Service(this.getQualifiedName(), 33, 32769, ttl, this.priority, this.weight, this.port, localHost.getName()), 0L);
        out.addAnswer(new DNSRecord.Text(this.getQualifiedName(), 16, 32769, ttl, this.getText()), 0L);
    }

    public void setTask(TimerTask task) {
        this.task = task;
    }

    public TimerTask getTask() {
        return this.task;
    }

    public void setText(byte[] text) {
        this.text = text;
    }

    public byte[] getText() {
        return this.text;
    }

    public void setDns(JmDNSImpl dns) {
        this.dns = dns;
    }

    public JmDNSImpl getDns() {
        return this.dns;
    }
}

