/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.jslp;

import ch.ethz.iks.slp.Locator;
import ch.ethz.iks.slp.ServiceLocationEnumeration;
import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.ServiceType;
import ch.ethz.iks.slp.ServiceURL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.internal.provider.jslp.LocatorDecorator;

public class LocatorDecoratorImpl
implements LocatorDecorator {
    private final Locator locator;

    public LocatorDecoratorImpl(Locator aLocator) {
        Assert.isNotNull((Object)aLocator);
        this.locator = aLocator;
    }

    public ServiceLocationEnumeration findAttributes(ServiceType type, List scopes, List attributeIds) throws ServiceLocationException {
        return this.locator.findAttributes(type, scopes, attributeIds);
    }

    public ServiceLocationEnumeration findAttributes(ServiceURL url, List scopes, List attributeIds) throws ServiceLocationException {
        return this.locator.findAttributes(url, scopes, attributeIds);
    }

    public ServiceLocationEnumeration findServices(ServiceType type, List scopes, String searchFilter) throws ServiceLocationException, IllegalArgumentException {
        return this.locator.findServices(type, scopes, searchFilter);
    }

    public ServiceLocationEnumeration findServiceTypes(String namingAuthority, List scopes) throws ServiceLocationException {
        return this.locator.findServiceTypes(namingAuthority, scopes);
    }

    public Locale getLocale() {
        return this.locator.getLocale();
    }

    public void setLocale(Locale locale) {
        this.locator.setLocale(locale);
    }

    public Map getServiceURLs(ServiceType aServiceType, List scopes) throws ServiceLocationException {
        HashMap result = new HashMap();
        ServiceLocationEnumeration services = this.findServices(aServiceType, scopes, null);
        while (services.hasMoreElements()) {
            ServiceURL url = (ServiceURL)services.next();
            result.put(url, Collections.list(this.findAttributes(url, scopes, null)));
        }
        return result;
    }

    public Map getServiceURLs() throws ServiceLocationException {
        ServiceLocationEnumeration stEnum = this.findServiceTypes(null, null);
        HashSet aSet = new HashSet(Collections.list(stEnum));
        HashMap result = new HashMap();
        Iterator itr = aSet.iterator();
        while (itr.hasNext()) {
            String type = (String)itr.next();
            ServiceLocationEnumeration services = this.findServices(new ServiceType(type), null, null);
            while (services.hasMoreElements()) {
                ServiceURL url = (ServiceURL)services.next();
                result.put(url, Collections.list(this.findAttributes(url, null, null)));
            }
        }
        return result;
    }
}

