/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.remoteservice;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.util.AdapterContainerFilter;
import org.eclipse.ecf.core.util.ConnectedContainerFilter;
import org.eclipse.ecf.core.util.IContainerFilter;
import org.eclipse.ecf.core.util.StringUtils;
import org.eclipse.ecf.discovery.IServiceInfo;

public abstract class AbstractRemoteServiceDescription {
    private ID discoveryID;
    private IServiceInfo serviceInfo;
    private IContainerFilter remoteServiceAdapterFilter;
    private IContainerFilter connectedFilter;
    static /* synthetic */ Class class$0;

    public AbstractRemoteServiceDescription(IServiceInfo serviceInfo, ID discoveryID) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.remoteServiceAdapterFilter = new AdapterContainerFilter((Class)clazz);
        this.connectedFilter = new ConnectedContainerFilter();
        Assert.isNotNull((Object)serviceInfo);
        this.serviceInfo = serviceInfo;
        this.discoveryID = null;
    }

    public ID getDiscoveryID() {
        return this.discoveryID;
    }

    public IServiceInfo getServiceInfo() {
        return this.serviceInfo;
    }

    public abstract Object createProxy() throws Exception;

    protected String getProperty(String key) {
        return this.serviceInfo.getServiceProperties().getPropertyString(key);
    }

    protected String[] getInterfaces() {
        String val = this.serviceInfo.getServiceProperties().getPropertyString("robjectClass");
        return StringUtils.split((String)val, (String)";");
    }

    public String getContainerFactoryName() {
        return this.getProperty("rsvc.cfn");
    }

    public IContainer createContainer() throws ContainerCreateException {
        String containerFactoryName = this.getContainerFactoryName();
        if (containerFactoryName == null) {
            return ContainerFactory.getDefault().createContainer();
        }
        return ContainerFactory.getDefault().createContainer(containerFactoryName);
    }

    protected IContainer[] getMatchingContainers(IContainerFilter filter, IContainer[] sourceContainers) {
        ArrayList<IContainer> results = new ArrayList<IContainer>();
        int i = 0;
        while (i < sourceContainers.length) {
            if (filter.match(sourceContainers[i])) {
                results.add(sourceContainers[i]);
            }
            ++i;
        }
        return results.toArray(new IContainer[0]);
    }

    public IContainer[] getRemoteServicesContainers(IContainer[] sourceContainers) {
        return this.getMatchingContainers(this.remoteServiceAdapterFilter, sourceContainers);
    }

    public IContainer[] getConnectedContainers(IContainer[] sourceContainers) {
        return this.getMatchingContainers(this.connectedFilter, sourceContainers);
    }

    public ID createTargetID(Namespace namespace) throws IDCreateException {
        return IDFactory.getDefault().createID(namespace, this.getProperty("rsvc.target"));
    }
}

