/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.remoteservice.generic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.provider.remoteservice.generic.RemoteServiceReferenceImpl;
import org.eclipse.ecf.provider.remoteservice.generic.RemoteServiceRegistrationImpl;
import org.eclipse.ecf.remoteservice.IRemoteFilter;
import org.eclipse.ecf.remoteservice.IRemoteServiceID;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.IRemoteServiceRegistration;

public class RemoteServiceRegistryImpl
implements Serializable {
    private static long nextServiceId = 0L;
    private static final long serialVersionUID = -291866447335444599L;
    protected static final String REMOTEOBJECTCLASS = "robjectClass";
    protected static final String REMOTESERVICE_ID = "rsvc.id";
    protected static final String REMOTESERVICE_RANKING = "rsvc.ranking";
    protected ID containerID;
    protected HashMap publishedServicesByClass = new HashMap(50);
    protected ArrayList allPublishedServices = new ArrayList(50);

    public RemoteServiceRegistryImpl() {
    }

    public RemoteServiceRegistryImpl(ID localContainerID) {
        this();
        this.containerID = localContainerID;
    }

    protected long getNextServiceId() {
        return nextServiceId++;
    }

    public ID getContainerID() {
        return this.containerID;
    }

    public void publishService(RemoteServiceRegistrationImpl serviceReg) {
        String[] clazzes = (String[])serviceReg.getReference().getProperty(REMOTEOBJECTCLASS);
        int size = clazzes.length;
        int i = 0;
        while (i < size) {
            String clazz = clazzes[i];
            ArrayList<RemoteServiceRegistrationImpl> services = (ArrayList<RemoteServiceRegistrationImpl>)this.publishedServicesByClass.get(clazz);
            if (services == null) {
                services = new ArrayList<RemoteServiceRegistrationImpl>(10);
                this.publishedServicesByClass.put(clazz, services);
            }
            services.add(serviceReg);
            ++i;
        }
        this.allPublishedServices.add(serviceReg);
    }

    public void unpublishService(RemoteServiceRegistrationImpl serviceReg) {
        String[] clazzes = (String[])serviceReg.getReference().getProperty(REMOTEOBJECTCLASS);
        int size = clazzes.length;
        int i = 0;
        while (i < size) {
            String clazz = clazzes[i];
            ArrayList services = (ArrayList)this.publishedServicesByClass.get(clazz);
            services.remove(serviceReg);
            ++i;
        }
        this.allPublishedServices.remove(serviceReg);
    }

    public void unpublishServices() {
        this.publishedServicesByClass.clear();
        this.allPublishedServices.clear();
    }

    public IRemoteServiceReference[] lookupServiceReferences(String clazz, IRemoteFilter filter) {
        ArrayList serviceRegs = clazz == null ? this.allPublishedServices : (ArrayList)this.publishedServicesByClass.get(clazz);
        if (serviceRegs == null) {
            return null;
        }
        int size = serviceRegs.size();
        if (size == 0) {
            return null;
        }
        ArrayList<IRemoteServiceReference> references = new ArrayList<IRemoteServiceReference>(size);
        int i = 0;
        while (i < size) {
            IRemoteServiceRegistration registration = (IRemoteServiceRegistration)serviceRegs.get(i);
            IRemoteServiceReference reference = registration.getReference();
            if (filter == null || filter.match(reference)) {
                RemoteServiceReferenceImpl impl = (RemoteServiceReferenceImpl)reference;
                impl.setRemoteClass(clazz);
                references.add(reference);
            }
            ++i;
        }
        if (references.size() == 0) {
            return null;
        }
        return references.toArray(new RemoteServiceReferenceImpl[references.size()]);
    }

    public IRemoteServiceReference[] lookupServiceReferences() {
        int size = this.allPublishedServices.size();
        if (size == 0) {
            return null;
        }
        ArrayList<IRemoteServiceReference> references = new ArrayList<IRemoteServiceReference>(size);
        int i = 0;
        while (i < size) {
            IRemoteServiceRegistration registration = (IRemoteServiceRegistration)this.allPublishedServices.get(i);
            IRemoteServiceReference reference = registration.getReference();
            references.add(reference);
            ++i;
        }
        if (references.size() == 0) {
            return null;
        }
        return references.toArray(new RemoteServiceReferenceImpl[references.size()]);
    }

    protected RemoteServiceRegistrationImpl[] getRegistrations() {
        return this.allPublishedServices.toArray(new RemoteServiceRegistrationImpl[this.allPublishedServices.size()]);
    }

    protected RemoteServiceRegistrationImpl findRegistrationForServiceId(long serviceId) {
        Iterator i = this.allPublishedServices.iterator();
        while (i.hasNext()) {
            RemoteServiceRegistrationImpl reg = (RemoteServiceRegistrationImpl)i.next();
            if (serviceId != reg.getServiceId()) continue;
            return reg;
        }
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("RemoteServiceRegistryImpl[");
        buf.append("all=").append(this.allPublishedServices).append(";").append("byclass=").append(this.publishedServicesByClass).append("]");
        return buf.toString();
    }

    public IRemoteServiceID createRemoteServiceID(long serviceid) {
        return (IRemoteServiceID)IDFactory.getDefault().createID(IDFactory.getDefault().getNamespaceByName("ecf.namespace.generic.remoteservice"), new Object[]{this.containerID, new Long(serviceid)});
    }
}

