/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.xmpp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.sharedobject.ISharedObject;
import org.eclipse.ecf.core.sharedobject.ISharedObjectConfig;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContext;
import org.eclipse.ecf.core.sharedobject.SharedObjectInitException;
import org.eclipse.ecf.core.sharedobject.events.ISharedObjectActivatedEvent;
import org.eclipse.ecf.core.sharedobject.events.ISharedObjectMessageEvent;
import org.eclipse.ecf.core.sharedobject.events.ISharedObjectMessageListener;
import org.eclipse.ecf.core.user.IUser;
import org.eclipse.ecf.core.user.User;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.core.util.Event;
import org.eclipse.ecf.internal.provider.xmpp.XMPPChatManager;
import org.eclipse.ecf.internal.provider.xmpp.XmppPlugin;
import org.eclipse.ecf.internal.provider.xmpp.events.IQEvent;
import org.eclipse.ecf.internal.provider.xmpp.events.MessageEvent;
import org.eclipse.ecf.internal.provider.xmpp.events.PresenceEvent;
import org.eclipse.ecf.internal.provider.xmpp.smack.ECFConnection;
import org.eclipse.ecf.presence.IPresence;
import org.eclipse.ecf.presence.IPresenceContainerAdapter;
import org.eclipse.ecf.presence.IPresenceListener;
import org.eclipse.ecf.presence.IPresenceSender;
import org.eclipse.ecf.presence.im.IChatManager;
import org.eclipse.ecf.presence.im.ITypingMessage;
import org.eclipse.ecf.presence.im.TypingMessage;
import org.eclipse.ecf.presence.roster.AbstractRosterManager;
import org.eclipse.ecf.presence.roster.IRoster;
import org.eclipse.ecf.presence.roster.IRosterEntry;
import org.eclipse.ecf.presence.roster.IRosterGroup;
import org.eclipse.ecf.presence.roster.IRosterItem;
import org.eclipse.ecf.presence.roster.IRosterManager;
import org.eclipse.ecf.presence.roster.IRosterSubscriptionSender;
import org.eclipse.ecf.presence.roster.Roster;
import org.eclipse.ecf.presence.roster.RosterEntry;
import org.eclipse.ecf.presence.roster.RosterGroup;
import org.eclipse.ecf.provider.xmpp.XMPPContainer;
import org.eclipse.ecf.provider.xmpp.identity.XMPPID;
import org.eclipse.ecf.provider.xmpp.identity.XMPPRoomID;
import org.eclipse.equinox.concurrent.future.IFuture;
import org.eclipse.equinox.concurrent.future.IProgressRunnable;
import org.eclipse.equinox.concurrent.future.ThreadsExecutor;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.RosterPacket;
import org.jivesoftware.smackx.packet.VCard;

public class XMPPContainerPresenceHelper
implements ISharedObject {
    public static final String VCARD = "vcard";
    public static final String VCARD_EMAIL = "vcard.email";
    public static final String VCARD_EMAIL_HOME = "vcard.email.home";
    public static final String VCARD_EMAIL_WORK = "vcard.email.work";
    public static final String VCARD_NAME = "vcard.name";
    public static final String VCARD_NAME_FIRST = "vcard.name.first";
    public static final String VCARD_NAME_MIDDLE = "vcard.name.middle";
    public static final String VCARD_NAME_LAST = "vcard.name.last";
    public static final String VCARD_NAME_NICK = "vcard.name.nick";
    public static final String VCARD_PHONE = "vcard.phone";
    public static final String VCARD_PHONE_HOME = "vcard.phone.home";
    public static final String VCARD_PHONE_HOME_VOICE = "vcard.phone.home.voice";
    public static final String VCARD_PHONE_HOME_CELL = "vcard.phone.home.cell";
    public static final String VCARD_PHONE_WORK = "vcard.phone.work";
    public static final String VCARD_PHONE_WORK_VOICE = "vcard.phone.work.voice";
    public static final String VCARD_PHONE_WORK_CELL = "vcard.phone.work.cell";
    private ISharedObjectConfig config = null;
    private final List sharedObjectMessageListeners = new ArrayList();
    private XMPPContainer container = null;
    private XMPPChatManager chatManager = null;
    private final List presenceListeners = new ArrayList();
    protected Roster roster;
    protected PresenceRosterManager rosterManager;
    private final Map vcardCache = new WeakHashMap();
    protected Message.Type[] ALLOWED_MESSAGES = new Message.Type[]{Message.Type.CHAT, Message.Type.ERROR, Message.Type.HEADLINE, Message.Type.NORMAL};

    public XMPPContainerPresenceHelper(XMPPContainer container) {
        this.container = container;
        this.chatManager = new XMPPChatManager(this);
        this.roster = new Roster((IPresenceContainerAdapter)container);
        this.rosterManager = new PresenceRosterManager(this.roster);
    }

    public void init(ISharedObjectConfig initData) throws SharedObjectInitException {
        this.config = initData;
    }

    public void handleEvent(Event event) {
        this.trace("handleEvent(" + event + ")");
        if (!(event instanceof ISharedObjectActivatedEvent)) {
            if (event instanceof IQEvent) {
                this.handleIQEvent((IQEvent)event);
            } else if (event instanceof MessageEvent) {
                this.handleMessageEvent((MessageEvent)event);
            } else if (event instanceof PresenceEvent) {
                this.handlePresenceEvent((PresenceEvent)event);
            } else if (event instanceof ISharedObjectMessageEvent) {
                this.handleSharedObjectMessageEvent((ISharedObjectMessageEvent)event);
            } else {
                this.trace("unhandled event=" + event);
            }
        }
    }

    public void handleEvents(Event[] events) {
        int i = 0;
        while (i < events.length) {
            this.handleEvent(events[i]);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.rosterManager.disconnect();
        this.chatManager.disconnect();
        List list = this.sharedObjectMessageListeners;
        synchronized (list) {
            this.sharedObjectMessageListeners.clear();
        }
        list = this.presenceListeners;
        synchronized (list) {
            this.presenceListeners.clear();
        }
        this.vcardCache.clear();
    }

    public void dispose(ID containerID) {
        this.vcardCache.clear();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isInstance(this)) {
            return this;
        }
        IAdapterManager adapterManager = XmppPlugin.getDefault().getAdapterManager();
        return adapterManager == null ? null : adapterManager.loadAdapter((Object)this, adapter.getName());
    }

    public IRosterManager getRosterManager() {
        return this.rosterManager;
    }

    public void setUser(IUser user) {
        this.rosterManager.setUser(user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSharedObjectMessageListener(ISharedObjectMessageListener listener) {
        List list = this.sharedObjectMessageListeners;
        synchronized (list) {
            this.sharedObjectMessageListeners.add(listener);
        }
    }

    protected void sendTypingMessage(ID toID, boolean isTyping, String body) throws IOException {
        this.getContext().sendMessage(toID, (Object)new TypingMessage(this.rosterManager.getRoster().getUser().getID(), isTyping, body));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSharedObjectMessageEvent(ISharedObjectMessageEvent event) {
        ArrayList toNotify = null;
        List list = this.sharedObjectMessageListeners;
        synchronized (list) {
            toNotify = new ArrayList(this.sharedObjectMessageListeners);
        }
        Iterator i = toNotify.iterator();
        while (i.hasNext()) {
            ISharedObjectMessageListener l = (ISharedObjectMessageListener)i.next();
            l.handleSharedObjectMessage(event);
        }
        Object data = event.getData();
        if (data instanceof ITypingMessage) {
            ITypingMessage tmess = (ITypingMessage)data;
            this.chatManager.fireTypingMessage(tmess.getFromID(), tmess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSharedObjectMessageListener(ISharedObjectMessageListener listener) {
        List list = this.sharedObjectMessageListeners;
        synchronized (list) {
            this.sharedObjectMessageListeners.remove(listener);
        }
    }

    private void addToRoster(IRosterItem[] items) {
        int i = 0;
        while (i < items.length) {
            this.roster.addItem(items[i]);
            ++i;
        }
        this.rosterManager.notifyRosterUpdate((IRosterItem)this.roster);
    }

    protected ISharedObjectContext getContext() {
        return this.config.getContext();
    }

    protected String getUserNameFromXMPPAddress(XMPPID userID) {
        return userID.getUsername();
    }

    protected IRosterEntry createRosterEntry(org.jivesoftware.smack.RosterEntry entry) {
        XMPPID xmppid = this.createIDFromName(entry.getUser());
        String name = entry.getName() == null ? xmppid.getUsername() : XMPPID.unfixEscapeInNode(entry.getName());
        return this.createRosterEntry((ID)xmppid, name, entry.getGroups());
    }

    protected IRosterEntry createRosterEntry(XMPPID xmppid, RosterPacket.Item entry) {
        String name = entry.getName() == null ? xmppid.getUsername() : XMPPID.unfixEscapeInNode(entry.getName());
        return this.createRosterEntry((ID)xmppid, name, entry.getGroupNames());
    }

    protected void handleIQEvent(IQEvent evt) {
        IQ iq = evt.getIQ();
        if (iq instanceof RosterPacket) {
            RosterPacket rosterPacket = (RosterPacket)iq;
            if (rosterPacket.getType() == IQ.Type.SET || rosterPacket.getType() == IQ.Type.RESULT) {
                Iterator i = rosterPacket.getRosterItems();
                while (i.hasNext()) {
                    RosterPacket.Item item = (RosterPacket.Item)i.next();
                    RosterPacket.ItemType itemType = item.getItemType();
                    boolean remove = false;
                    XMPPID newID = this.createIDFromName(item.getUser());
                    IRosterItem[] items = this.createRosterEntries(newID, item);
                    IRosterEntry entry = this.createRosterEntry(newID, item);
                    if (itemType == RosterPacket.ItemType.NONE || itemType == RosterPacket.ItemType.REMOVE) {
                        this.removeItemFromRoster(this.roster.getItems(), this.createIDFromName(item.getUser()));
                        remove = true;
                    } else {
                        remove = false;
                        this.addToRoster(items);
                    }
                    this.fireSetRosterEntry(remove, entry);
                }
            }
        } else {
            this.trace("Received non rosterpacket IQ message");
        }
    }

    protected void fireSetRosterEntry(boolean remove, IRosterEntry entry) {
        if (remove) {
            this.rosterManager.notifyRosterRemove(entry);
        } else {
            this.rosterManager.notifyRosterAdd(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeItemFromRoster(Collection rosterItems, XMPPID itemIDToRemove) {
        boolean removed = false;
        Collection collection = rosterItems;
        synchronized (collection) {
            Iterator i = rosterItems.iterator();
            while (i.hasNext()) {
                IRosterItem item = (IRosterItem)i.next();
                if (item instanceof RosterGroup) {
                    RosterGroup group = (RosterGroup)item;
                    removed = this.removeItemFromRosterGroup(group, itemIDToRemove);
                    if (group.getEntries().size() != 0) continue;
                    i.remove();
                    continue;
                }
                if (!(item instanceof RosterEntry) || !((RosterEntry)item).getUser().getID().equals((Object)itemIDToRemove)) continue;
                i.remove();
                removed = true;
            }
        }
        if (removed) {
            this.rosterManager.notifyRosterUpdate((IRosterItem)this.roster);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean removeItemFromRosterGroup(RosterGroup group, XMPPID itemIDToRemove) {
        Collection groupEntries;
        Collection collection = groupEntries = group.getEntries();
        synchronized (collection) {
            RosterEntry entry;
            Iterator i = group.getEntries().iterator();
            do {
                if (i.hasNext()) continue;
                return false;
            } while (!(entry = (RosterEntry)i.next()).getUser().getID().equals((Object)itemIDToRemove));
            i.remove();
            return true;
        }
    }

    protected void handleMessageEvent(MessageEvent evt) {
        Message msg = evt.getMessage();
        String from = msg.getFrom();
        String body = msg.getBody();
        String subject = msg.getSubject();
        XMPPID fromID = this.createIDFromName(from);
        ID threadID = this.createThreadID(msg.getThread());
        if ((msg = this.filterMessageType(msg)) != null) {
            if (msg.getExtension("composing", "http://jabber.org/protocol/chatstates") != null) {
                this.chatManager.fireTypingMessage((ID)fromID, (ITypingMessage)new TypingMessage((ID)fromID, true, body));
            } else if (msg.getExtension("paused", "http://jabber.org/protocol/chatstates") != null) {
                this.chatManager.fireTypingMessage((ID)fromID, (ITypingMessage)new TypingMessage((ID)fromID, false, body));
            } else {
                Iterator xhtmlbodies = evt.getXHTMLBodies();
                if (xhtmlbodies != null) {
                    ArrayList xhtmlbodylist = new ArrayList();
                    while (xhtmlbodies.hasNext()) {
                        xhtmlbodylist.add(xhtmlbodies.next());
                    }
                    this.chatManager.fireXHTMLChatMessage((ID)fromID, threadID, msg.getType(), subject, body, ECFConnection.getPropertiesFromPacket((Packet)msg), xhtmlbodylist);
                } else if (body != null) {
                    this.chatManager.fireChatMessage((ID)fromID, threadID, msg.getType(), subject, body, ECFConnection.getPropertiesFromPacket((Packet)msg));
                }
            }
        }
    }

    protected void handlePresenceEvent(PresenceEvent evt) {
        Presence xmppPresence = evt.getPresence();
        String from = xmppPresence.getFrom();
        IPresence newPresence = this.createIPresence(xmppPresence);
        XMPPID fromID = this.createIDFromName(from);
        if (newPresence.getType().equals((Object)IPresence.Type.SUBSCRIBE) || newPresence.getType().equals((Object)IPresence.Type.UNSUBSCRIBE) || newPresence.getType().equals((Object)IPresence.Type.SUBSCRIBED) || newPresence.getType().equals((Object)IPresence.Type.UNSUBSCRIBED)) {
            this.rosterManager.notifySubscriptionListener((ID)fromID, newPresence);
        } else {
            this.updatePresence(fromID, newPresence);
            this.firePresenceListeners((ID)fromID, newPresence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePresenceListeners(ID fromID, IPresence presence) {
        ArrayList toNotify = null;
        List list = this.presenceListeners;
        synchronized (list) {
            toNotify = new ArrayList(this.presenceListeners);
        }
        Iterator i = toNotify.iterator();
        while (i.hasNext()) {
            IPresenceListener l = (IPresenceListener)i.next();
            l.handlePresence(fromID, presence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePresence(XMPPID fromID, IPresence newPresence) {
        Collection rosterItems = this.roster.getItems();
        ArrayList<AdditionalClientRosterEntry> newEntrys = new ArrayList<AdditionalClientRosterEntry>();
        Collection collection = rosterItems;
        synchronized (collection) {
            Iterator i = this.roster.getItems().iterator();
            while (i.hasNext()) {
                AdditionalClientRosterEntry entry;
                IRosterItem item = (IRosterItem)i.next();
                if (item instanceof IRosterGroup) {
                    AdditionalClientRosterEntry[] es = this.updatePresenceInGroup((IRosterGroup)item, fromID, newPresence);
                    int j = 0;
                    while (j < es.length) {
                        newEntrys.add(es[j]);
                        ++j;
                    }
                    continue;
                }
                if (!(item instanceof RosterEntry) || (entry = this.updatePresenceForMatchingEntry((RosterEntry)item, fromID, newPresence)) == null) continue;
                newEntrys.add(entry);
            }
        }
        AdditionalClientRosterEntry[] entrys = newEntrys.toArray(new AdditionalClientRosterEntry[0]);
        RosterEntry entry = null;
        if (entrys.length > 0) {
            int i = 0;
            while (i < entrys.length) {
                entry = new RosterEntry(entrys[i].parent, entrys[i].user, entrys[i].presence);
                ++i;
            }
            this.rosterManager.notifyRosterUpdate((IRosterItem)this.roster);
            this.fireSetRosterEntry(false, (IRosterEntry)entry);
        }
    }

    private AdditionalClientRosterEntry updatePresenceForMatchingEntry(RosterEntry entry, XMPPID fromID, IPresence newPresence) {
        IUser user = entry.getUser();
        XMPPID oldID = (XMPPID)user.getID();
        if (oldID.equals((Object)fromID)) {
            entry.setPresence(newPresence);
            this.rosterManager.notifyRosterUpdate((IRosterItem)entry);
        } else if (oldID.getUsernameAtHost().equals(fromID.getUsernameAtHost())) {
            if (oldID.getResourceName() == null) {
                oldID.setResourceName(fromID.getResourceName());
                entry.setPresence(newPresence);
                this.rosterManager.notifyRosterUpdate((IRosterItem)entry);
            } else if (fromID.getResourceName() != null && !newPresence.getType().equals((Object)IPresence.Type.UNAVAILABLE)) {
                return new AdditionalClientRosterEntry(entry.getParent(), (IUser)new User((ID)fromID, user.getName()), newPresence);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AdditionalClientRosterEntry[] updatePresenceInGroup(IRosterGroup group, XMPPID fromID, IPresence newPresence) {
        Collection groupEntries;
        ArrayList<AdditionalClientRosterEntry> results = new ArrayList<AdditionalClientRosterEntry>();
        Collection collection = groupEntries = group.getEntries();
        synchronized (collection) {
            Iterator i = group.getEntries().iterator();
            while (i.hasNext()) {
                AdditionalClientRosterEntry newEntry = this.updatePresenceForMatchingEntry((RosterEntry)i.next(), fromID, newPresence);
                if (newEntry == null) continue;
                results.add(newEntry);
            }
        }
        return results.toArray(new AdditionalClientRosterEntry[0]);
    }

    protected void handleRoster(org.jivesoftware.smack.Roster roster) {
        Iterator i = roster.getEntries();
        while (i.hasNext()) {
            IRosterItem[] items = this.createRosterEntries((org.jivesoftware.smack.RosterEntry)i.next());
            int j = 0;
            while (j < items.length) {
                this.roster.addItem(items[j]);
                ++j;
            }
        }
        this.rosterManager.notifyRosterUpdate((IRosterItem)this.roster);
    }

    protected XMPPID createIDFromName(String uname) {
        try {
            if (uname.lastIndexOf(64) == -1) {
                return new XMPPID(this.container.getConnectNamespace(), "admin@" + uname);
            }
            return new XMPPID(this.container.getConnectNamespace(), uname);
        }
        catch (Exception e) {
            this.traceStack("Exception in createIDFromName", e);
            return null;
        }
    }

    protected ID createThreadID(String thread) {
        block3: {
            try {
                if (thread != null && !thread.equals("")) break block3;
                return null;
            }
            catch (Exception e) {
                this.traceStack("Exception in createThreadID", e);
                return null;
            }
        }
        return IDFactory.getDefault().createStringID(thread);
    }

    private VCard getFromCache(String id) {
        if (id == null) {
            return null;
        }
        return (VCard)this.vcardCache.get(id);
    }

    private void addToCache(String id, VCard card) {
        this.vcardCache.put(id, card);
    }

    private VCard getVCardForPresence(Presence xmppPresence) {
        String from;
        VCard result = null;
        if (xmppPresence.getExtension("x", "vcard-temp:x:update") != null && (result = this.getFromCache(from = xmppPresence.getFrom())) == null && from != null) {
            result = new VCard();
            try {
                result.load(this.container.getXMPPConnection(), from);
                this.addToCache(from, result);
            }
            catch (XMPPException e) {
                this.traceStack("vcard loading exception", e);
            }
        }
        return result;
    }

    private Map addVCardProperties(VCard vcard, Map props) {
        String phoneWorkCell;
        String phoneWorkVoice;
        String phoneHomeCell;
        String phoneHomeVoice;
        String nickName;
        String lastName;
        String middleName;
        String firstName;
        String emailWork;
        if (vcard == null) {
            return props;
        }
        String emailHome = vcard.getEmailHome();
        if (emailHome != null && !emailHome.equals("")) {
            props.put(VCARD_EMAIL_HOME, emailHome);
        }
        if ((emailWork = vcard.getEmailWork()) != null && !emailWork.equals("")) {
            props.put(VCARD_EMAIL_WORK, emailWork);
        }
        if ((firstName = vcard.getFirstName()) != null && !firstName.equals("")) {
            props.put(VCARD_NAME_FIRST, firstName);
        }
        if ((middleName = vcard.getMiddleName()) != null && !middleName.equals("")) {
            props.put(VCARD_NAME_MIDDLE, middleName);
        }
        if ((lastName = vcard.getLastName()) != null && !lastName.equals("")) {
            props.put(VCARD_NAME_LAST, lastName);
        }
        if ((nickName = vcard.getNickName()) != null && !nickName.equals("")) {
            props.put(VCARD_NAME_NICK, nickName);
        }
        if ((phoneHomeVoice = vcard.getPhoneHome("VOICE")) != null && !phoneHomeVoice.equals("")) {
            props.put(VCARD_PHONE_HOME_VOICE, phoneHomeVoice);
        }
        if ((phoneHomeCell = vcard.getPhoneHome("CELL")) != null && !phoneHomeCell.equals("")) {
            props.put(VCARD_PHONE_HOME_CELL, phoneHomeCell);
        }
        if ((phoneWorkVoice = vcard.getPhoneWork("VOICE")) != null && !phoneWorkVoice.equals("")) {
            props.put(VCARD_PHONE_WORK_VOICE, phoneWorkVoice);
        }
        if ((phoneWorkCell = vcard.getPhoneWork("CELL")) != null && !phoneWorkCell.equals("")) {
            props.put(VCARD_PHONE_WORK_CELL, phoneWorkCell);
        }
        return props;
    }

    protected IPresence createIPresence(final Presence xmppPresence) {
        IFuture asyncResult = new ThreadsExecutor().execute(new IProgressRunnable(){

            public Object run(IProgressMonitor monitor) throws Exception {
                return XMPPContainerPresenceHelper.this.getVCardForPresence(xmppPresence);
            }
        }, null);
        return new XMPPPresence(xmppPresence.getFrom(), xmppPresence, asyncResult);
    }

    protected Presence createPresence(IPresence ipresence) {
        Presence newPresence = new Presence(this.createPresenceType(ipresence), ipresence.getStatus(), 0, this.createPresenceMode(ipresence));
        ECFConnection.setPropertiesInPacket((Packet)newPresence, ipresence.getProperties());
        return newPresence;
    }

    protected IPresence.Mode createIPresenceMode(Presence xmppPresence) {
        if (xmppPresence == null) {
            return IPresence.Mode.AVAILABLE;
        }
        Presence.Mode mode = xmppPresence.getMode();
        if (mode == Presence.Mode.AVAILABLE) {
            return IPresence.Mode.AVAILABLE;
        }
        if (mode == Presence.Mode.AWAY) {
            return IPresence.Mode.AWAY;
        }
        if (mode == Presence.Mode.CHAT) {
            return IPresence.Mode.CHAT;
        }
        if (mode == Presence.Mode.DO_NOT_DISTURB) {
            return IPresence.Mode.DND;
        }
        if (mode == Presence.Mode.EXTENDED_AWAY) {
            return IPresence.Mode.EXTENDED_AWAY;
        }
        if (mode == Presence.Mode.INVISIBLE) {
            return IPresence.Mode.INVISIBLE;
        }
        return IPresence.Mode.AVAILABLE;
    }

    protected Presence.Mode createPresenceMode(IPresence ipresence) {
        if (ipresence == null) {
            return Presence.Mode.AVAILABLE;
        }
        IPresence.Mode mode = ipresence.getMode();
        if (mode == IPresence.Mode.AVAILABLE) {
            return Presence.Mode.AVAILABLE;
        }
        if (mode == IPresence.Mode.AWAY) {
            return Presence.Mode.AWAY;
        }
        if (mode == IPresence.Mode.CHAT) {
            return Presence.Mode.CHAT;
        }
        if (mode == IPresence.Mode.DND) {
            return Presence.Mode.DO_NOT_DISTURB;
        }
        if (mode == IPresence.Mode.EXTENDED_AWAY) {
            return Presence.Mode.EXTENDED_AWAY;
        }
        if (mode == IPresence.Mode.INVISIBLE) {
            return Presence.Mode.INVISIBLE;
        }
        return Presence.Mode.AVAILABLE;
    }

    protected IPresence.Type createIPresenceType(Presence xmppPresence) {
        if (xmppPresence == null) {
            return IPresence.Type.AVAILABLE;
        }
        Presence.Type type = xmppPresence.getType();
        if (type == Presence.Type.AVAILABLE) {
            return IPresence.Type.AVAILABLE;
        }
        if (type == Presence.Type.ERROR) {
            return IPresence.Type.ERROR;
        }
        if (type == Presence.Type.SUBSCRIBE) {
            return IPresence.Type.SUBSCRIBE;
        }
        if (type == Presence.Type.SUBSCRIBED) {
            return IPresence.Type.SUBSCRIBED;
        }
        if (type == Presence.Type.UNSUBSCRIBE) {
            return IPresence.Type.UNSUBSCRIBE;
        }
        if (type == Presence.Type.UNSUBSCRIBED) {
            return IPresence.Type.UNSUBSCRIBED;
        }
        if (type == Presence.Type.UNAVAILABLE) {
            return IPresence.Type.UNAVAILABLE;
        }
        return IPresence.Type.AVAILABLE;
    }

    protected Presence.Type createPresenceType(IPresence ipresence) {
        if (ipresence == null) {
            return Presence.Type.AVAILABLE;
        }
        IPresence.Type type = ipresence.getType();
        if (type == IPresence.Type.AVAILABLE) {
            return Presence.Type.AVAILABLE;
        }
        if (type == IPresence.Type.ERROR) {
            return Presence.Type.ERROR;
        }
        if (type == IPresence.Type.SUBSCRIBE) {
            return Presence.Type.SUBSCRIBE;
        }
        if (type == IPresence.Type.SUBSCRIBED) {
            return Presence.Type.SUBSCRIBED;
        }
        if (type == IPresence.Type.UNSUBSCRIBE) {
            return Presence.Type.UNSUBSCRIBE;
        }
        if (type == IPresence.Type.UNSUBSCRIBED) {
            return Presence.Type.UNSUBSCRIBED;
        }
        if (type == IPresence.Type.UNAVAILABLE) {
            return Presence.Type.UNAVAILABLE;
        }
        return Presence.Type.AVAILABLE;
    }

    protected IRosterItem[] createRosterEntries(org.jivesoftware.smack.RosterEntry entry) {
        XMPPID xmppid = this.createIDFromName(entry.getUser());
        String name = entry.getName();
        User newUser = name == null ? new User((ID)xmppid, xmppid.getUsername()) : new User((ID)xmppid, XMPPID.unfixEscapeInNode(name));
        return this.createRosterEntries(entry.getGroups(), (IRosterItem)this.roster, (IUser)newUser);
    }

    private IRosterItem[] createRosterEntries(Iterator grps, IRosterItem parent, IUser user) {
        ArrayList<RosterGroup> result = new ArrayList<RosterGroup>();
        if (grps.hasNext()) {
            while (grps.hasNext()) {
                boolean groupFound;
                String groupName;
                Object o = grps.next();
                String string = groupName = o instanceof String ? (String)o : ((org.jivesoftware.smack.RosterGroup)o).getName();
                if (groupName == null || groupName.equals("")) {
                    this.createRosterEntries(parent, user, result);
                    continue;
                }
                RosterGroup rosterGroup = this.findRosterGroup(parent, groupName);
                boolean bl = groupFound = rosterGroup != null;
                if (!groupFound) {
                    rosterGroup = new RosterGroup(parent, groupName);
                }
                if (this.findRosterEntry(rosterGroup, user) == null) {
                    new RosterEntry((IRosterItem)rosterGroup, user, (IPresence)new org.eclipse.ecf.presence.Presence(IPresence.Type.UNAVAILABLE, IPresence.Type.UNAVAILABLE.toString(), IPresence.Mode.AWAY));
                }
                if (groupFound) continue;
                result.add(rosterGroup);
            }
        } else {
            this.createRosterEntries(parent, user, result);
        }
        return result.toArray(new IRosterItem[0]);
    }

    protected IRosterEntry createRosterEntry(ID userID, String name, Iterator grps) {
        ArrayList<RosterGroup> groups = new ArrayList<RosterGroup>();
        while (grps.hasNext()) {
            Object o = grps.next();
            String groupName = o instanceof String ? (String)o : ((org.jivesoftware.smack.RosterGroup)o).getName();
            RosterGroup localGrp = new RosterGroup((IRosterItem)this.roster, groupName);
            groups.add(localGrp);
        }
        User user = new User(userID, name);
        RosterEntry newEntry = null;
        if (groups.size() == 0) {
            return new RosterEntry((IRosterItem)this.roster, (IUser)user, null);
        }
        int i = 0;
        while (i < groups.size()) {
            IRosterGroup grp = (IRosterGroup)groups.get(i);
            if (i == 0) {
                newEntry = new RosterEntry((IRosterItem)grp, (IUser)user, null);
            } else {
                grp.getEntries().add(newEntry);
                newEntry.getGroups().add(grp);
            }
            ++i;
        }
        return newEntry;
    }

    private void createRosterEntries(IRosterItem parent, IUser user, List result) {
        RosterEntry oldEntry = this.findRosterEntry((RosterGroup)null, user);
        if (oldEntry == null) {
            RosterEntry newEntry = new RosterEntry(parent, user, (IPresence)new org.eclipse.ecf.presence.Presence(IPresence.Type.UNAVAILABLE, IPresence.Type.UNAVAILABLE.toString(), IPresence.Mode.AWAY));
            result.add(newEntry);
        }
    }

    private RosterEntry findRosterEntry(RosterGroup rosterGroup, IUser user) {
        if (rosterGroup != null) {
            return this.findRosterEntry(rosterGroup.getEntries(), user);
        }
        return this.findRosterEntry(this.roster.getItems(), user);
    }

    private RosterEntry findRosterEntry(Collection entries, IUser user) {
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            RosterEntry entry;
            Object o = i.next();
            if (!(o instanceof RosterEntry) || !(entry = (RosterEntry)o).getUser().getID().equals((Object)user.getID())) continue;
            return entry;
        }
        return null;
    }

    protected IRosterItem[] createRosterEntries(XMPPID id, RosterPacket.Item entry) {
        String name = entry.getName();
        if (name == null) {
            name = id.getUsername();
        }
        name = XMPPID.unfixEscapeInNode(name);
        return this.createRosterEntries(entry.getGroupNames(), (IRosterItem)this.roster, (IUser)new User((ID)id, name));
    }

    protected RosterGroup findRosterGroup(Object parent, String grp) {
        Collection items = this.roster.getItems();
        Iterator i = items.iterator();
        while (i.hasNext()) {
            IRosterItem item = (IRosterItem)i.next();
            if (!item.getName().equals(grp)) continue;
            return (RosterGroup)item;
        }
        return null;
    }

    protected ECFConnection getConnectionOrThrowIfNull() throws IOException {
        ECFConnection conn = this.container.getECFConnection();
        if (conn == null) {
            throw new IOException("Not connected");
        }
        return conn;
    }

    protected void traceAndThrowECFException(String msg, Throwable t) throws ECFException {
        throw new ECFException(msg, t);
    }

    protected void trace(String msg) {
    }

    protected void traceStack(String msg, Throwable e) {
    }

    protected ID createRoomIDFromName(String from) {
        try {
            ECFConnection ecfConnection = this.getConnectionOrThrowIfNull();
            return new XMPPRoomID(this.container.getConnectNamespace(), ecfConnection.getXMPPConnection(), from);
        }
        catch (Exception e) {
            this.traceStack("Exception in createRoomIDFromName", e);
            return null;
        }
    }

    protected ID createUserIDFromName(String name) {
        XMPPID result = null;
        try {
            result = new XMPPID(this.container.getConnectNamespace(), name);
            return result;
        }
        catch (Exception e) {
            this.traceStack("Exception in createIDFromName", e);
            return null;
        }
    }

    protected Message filterMessageType(Message msg) {
        int i = 0;
        while (i < this.ALLOWED_MESSAGES.length) {
            if (this.ALLOWED_MESSAGES[i].equals(msg.getType())) {
                return msg;
            }
            ++i;
        }
        return null;
    }

    public IChatManager getChatManager() {
        return this.chatManager;
    }

    class AdditionalClientRosterEntry {
        IRosterItem parent;
        IUser user;
        IPresence presence;

        public AdditionalClientRosterEntry(IRosterItem parent, IUser user, IPresence presence) {
            this.parent = parent;
            this.user = user;
            this.presence = presence;
        }
    }

    class PresenceRosterManager
    extends AbstractRosterManager {
        IPresenceSender rosterPresenceSender = new IPresenceSender(this){
            final /* synthetic */ PresenceRosterManager this$1;
            {
                this.this$1 = presenceRosterManager;
            }

            public void sendPresenceUpdate(ID toID, IPresence presence) throws ECFException {
                try {
                    PresenceRosterManager.access$0(this.this$1).getConnectionOrThrowIfNull().sendPresenceUpdate(toID, PresenceRosterManager.access$0(this.this$1).createPresence(presence));
                }
                catch (IOException e) {
                    PresenceRosterManager.access$0(this.this$1).traceAndThrowECFException("sendPresenceUpdate", e);
                }
            }
        };
        IRosterSubscriptionSender rosterSubscriptionSender = new IRosterSubscriptionSender(this){
            final /* synthetic */ PresenceRosterManager this$1;
            {
                this.this$1 = presenceRosterManager;
            }

            public void sendRosterAdd(String user, String name, String[] groups) throws ECFException {
                try {
                    PresenceRosterManager.access$0(this.this$1).getConnectionOrThrowIfNull().sendRosterAdd(user, name, groups);
                }
                catch (Exception e) {
                    PresenceRosterManager.access$0(this.this$1).traceAndThrowECFException("sendRosterAdd", e);
                }
            }

            public void sendRosterRemove(ID userID) throws ECFException {
                try {
                    if (!(userID instanceof XMPPID)) {
                        throw new ECFException("invalid userID");
                    }
                    XMPPID xmppID = (XMPPID)userID;
                    PresenceRosterManager.access$0(this.this$1).getConnectionOrThrowIfNull().sendRosterRemove(xmppID.getUsernameAtHost());
                }
                catch (Exception e) {
                    PresenceRosterManager.access$0(this.this$1).traceAndThrowECFException("sendRosterRemove", e);
                }
            }
        };

        public PresenceRosterManager(Roster roster) {
            super((IRoster)roster);
        }

        public void notifySubscriptionListener(ID fromID, IPresence presence) {
            this.fireSubscriptionListener(fromID, presence.getType());
        }

        public void notifyRosterUpdate(IRosterItem changedItem) {
            this.fireRosterUpdate(changedItem);
        }

        public void notifyRosterAdd(IRosterEntry entry) {
            this.fireRosterAdd(entry);
        }

        public void notifyRosterRemove(IRosterEntry entry) {
            this.fireRosterRemove(entry);
        }

        public void disconnect() {
            this.getRoster().getItems().clear();
            super.disconnect();
            this.fireRosterUpdate((IRosterItem)this.roster);
        }

        public void setUser(IUser user) {
            Roster roster = (Roster)this.getRoster();
            roster.setUser(user);
            this.notifyRosterUpdate((IRosterItem)roster);
        }

        public IPresenceSender getPresenceSender() {
            return this.rosterPresenceSender;
        }

        public IRosterSubscriptionSender getRosterSubscriptionSender() {
            return this.rosterSubscriptionSender;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addPresenceListener(IPresenceListener listener) {
            List list = XMPPContainerPresenceHelper.this.presenceListeners;
            synchronized (list) {
                XMPPContainerPresenceHelper.this.presenceListeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removePresenceListener(IPresenceListener listener) {
            List list = XMPPContainerPresenceHelper.this.presenceListeners;
            synchronized (list) {
                XMPPContainerPresenceHelper.this.presenceListeners.add(listener);
            }
        }

        static /* synthetic */ XMPPContainerPresenceHelper access$0(PresenceRosterManager presenceRosterManager) {
            return presenceRosterManager.XMPPContainerPresenceHelper.this;
        }
    }

    class XMPPPresence
    extends org.eclipse.ecf.presence.Presence {
        private static final long serialVersionUID = 7843634971520771692L;
        IFuture asyncResult = null;
        String fromID = null;

        XMPPPresence(String fromID, Presence xmppPresence, IFuture future) {
            super(XMPPContainerPresenceHelper.this.createIPresenceType(xmppPresence), xmppPresence.getStatus(), XMPPContainerPresenceHelper.this.createIPresenceMode(xmppPresence), ECFConnection.getPropertiesFromPacket((Packet)xmppPresence), null);
            this.fromID = fromID;
        }

        private void fillFromVCard() {
            VCard card = XMPPContainerPresenceHelper.this.getFromCache(this.fromID);
            if (card == null && this.asyncResult != null) {
                try {
                    card = (VCard)this.asyncResult.get();
                    this.asyncResult = null;
                }
                catch (Exception exception) {}
            }
            if (card != null) {
                XMPPContainerPresenceHelper.this.addToCache(this.fromID, card);
                byte[] bytes = card.getAvatar();
                this.pictureData = bytes == null ? new byte[]{} : bytes;
                this.properties = XMPPContainerPresenceHelper.this.addVCardProperties(card, this.properties);
            }
        }

        public byte[] getPictureData() {
            this.fillFromVCard();
            return this.pictureData;
        }

        public Map getProperties() {
            this.fillFromVCard();
            return this.properties;
        }
    }
}

