/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.sharedobject.util;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.ecf.core.sharedobject.util.ISimpleFIFOQueue;

public class SimpleFIFOQueue
implements ISimpleFIFOQueue {
    List list = new LinkedList();
    boolean stopped = false;

    public synchronized boolean enqueue(Object obj) {
        if (this.isStopped() || obj == null) {
            return false;
        }
        this.list.add(obj);
        this.notify();
        return true;
    }

    public synchronized Object dequeue() {
        Object val = this.peekQueue();
        if (val != null) {
            this.removeHead();
        }
        return val;
    }

    public synchronized Object peekQueue() {
        while (this.isEmpty()) {
            if (this.stopped) {
                return null;
            }
            try {
                this.wait();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this.list.get(0);
    }

    public synchronized Object peekQueue(long waitMS) {
        if (waitMS == 0L) {
            return this.peekQueue();
        }
        if (this.stopped) {
            return null;
        }
        try {
            this.wait(waitMS);
        }
        catch (Exception exception) {
            return null;
        }
        if (this.isEmpty()) {
            return null;
        }
        return this.list.get(0);
    }

    public synchronized Object removeHead() {
        if (this.list.isEmpty()) {
            return null;
        }
        return this.list.remove(0);
    }

    public synchronized boolean isEmpty() {
        return this.list.isEmpty();
    }

    public synchronized void stop() {
        this.stopped = true;
    }

    public synchronized boolean isStopped() {
        return this.stopped;
    }

    public synchronized int size() {
        return this.list.size();
    }

    public synchronized Object[] flush() {
        Object[] out = this.list.toArray();
        this.list.clear();
        this.close();
        return out;
    }

    public synchronized void close() {
        this.stop();
        this.notifyAll();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SimpleFIFOQueue[");
        sb.append(this.list).append("]");
        return sb.toString();
    }
}

