/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.packet.DataForm;

public class ReportedData {
    private List columns = new ArrayList();
    private List rows = new ArrayList();
    private String title = "";

    public static ReportedData getReportedDataFrom(Packet packet) {
        DataForm dataForm;
        PacketExtension packetExtension = packet.getExtension("x", "jabber:x:data");
        if (packetExtension != null && (dataForm = (DataForm)packetExtension).getReportedData() != null) {
            return new ReportedData(dataForm);
        }
        return null;
    }

    private ReportedData(DataForm dataForm) {
        Iterator fields = dataForm.getReportedData().getFields();
        while (fields.hasNext()) {
            FormField field = (FormField)fields.next();
            this.columns.add(new Column(field.getLabel(), field.getVariable(), field.getType()));
        }
        Iterator items = dataForm.getItems();
        while (items.hasNext()) {
            DataForm.Item item = (DataForm.Item)items.next();
            ArrayList<Field> fieldList = new ArrayList<Field>(this.columns.size());
            Iterator fields2 = item.getFields();
            while (fields2.hasNext()) {
                FormField field = (FormField)fields2.next();
                ArrayList values = new ArrayList();
                Iterator it = field.getValues();
                while (it.hasNext()) {
                    values.add(it.next());
                }
                fieldList.add(new Field(field.getVariable(), values));
            }
            this.rows.add(new Row(fieldList));
        }
        this.title = dataForm.getTitle();
    }

    public ReportedData() {
    }

    public void addRow(Row row) {
        this.rows.add(row);
    }

    public void addColumn(Column column) {
        this.columns.add(column);
    }

    public Iterator getRows() {
        return Collections.unmodifiableList(new ArrayList(this.rows)).iterator();
    }

    public Iterator getColumns() {
        return Collections.unmodifiableList(new ArrayList(this.columns)).iterator();
    }

    public String getTitle() {
        return this.title;
    }

    public static class Column {
        private String label;
        private String variable;
        private String type;

        public Column(String label, String variable, String type) {
            this.label = label;
            this.variable = variable;
            this.type = type;
        }

        public String getLabel() {
            return this.label;
        }

        public String getType() {
            return this.type;
        }

        public String getVariable() {
            return this.variable;
        }
    }

    public static class Field {
        private String variable;
        private List values;

        public Field(String variable, List values) {
            this.variable = variable;
            this.values = values;
        }

        public String getVariable() {
            return this.variable;
        }

        public Iterator getValues() {
            return Collections.unmodifiableList(this.values).iterator();
        }
    }

    public static class Row {
        private List fields = new ArrayList();

        public Row(List fields) {
            this.fields = fields;
        }

        public Iterator getValues(String variable) {
            Iterator it = this.getFields();
            while (it.hasNext()) {
                Field field = (Field)it.next();
                if (!variable.equalsIgnoreCase(field.getVariable())) continue;
                return field.getValues();
            }
            return null;
        }

        private Iterator getFields() {
            return Collections.unmodifiableList(new ArrayList(this.fields)).iterator();
        }
    }
}

