/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.irc.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.events.ContainerDisconnectedEvent;
import org.eclipse.ecf.core.events.ContainerDisconnectingEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.internal.provider.irc.Activator;
import org.eclipse.ecf.internal.provider.irc.Messages;
import org.eclipse.ecf.internal.provider.irc.container.IRCAbstractContainer;
import org.eclipse.ecf.internal.provider.irc.container.IRCChannelContainer;
import org.eclipse.ecf.internal.provider.irc.container.IRCMessageChannel;
import org.eclipse.ecf.internal.provider.irc.identity.IRCID;
import org.eclipse.ecf.presence.chatroom.ChatRoomCreateException;
import org.eclipse.ecf.presence.chatroom.IChatRoomAdminSender;
import org.eclipse.ecf.presence.chatroom.IChatRoomContainer;
import org.eclipse.ecf.presence.chatroom.IChatRoomContainerOptionsAdapter;
import org.eclipse.ecf.presence.chatroom.IChatRoomInfo;
import org.eclipse.ecf.presence.chatroom.IChatRoomInvitationListener;
import org.eclipse.ecf.presence.chatroom.IChatRoomInvitationSender;
import org.eclipse.ecf.presence.chatroom.IChatRoomManager;
import org.eclipse.ecf.presence.chatroom.IChatRoomMessageSender;
import org.eclipse.ecf.presence.chatroom.IChatRoomParticipantListener;
import org.eclipse.ecf.presence.history.IHistory;
import org.eclipse.ecf.presence.history.IHistoryManager;
import org.eclipse.ecf.presence.im.IChatMessage;
import org.eclipse.ecf.presence.im.IChatMessageSender;
import org.eclipse.osgi.util.NLS;
import org.schwering.irc.lib.IRCConnection;
import org.schwering.irc.lib.IRCEventListener;
import org.schwering.irc.lib.IRCModeParser;
import org.schwering.irc.lib.IRCUser;

public class IRCRootContainer
extends IRCAbstractContainer
implements IContainer,
IChatMessageSender,
IChatRoomInvitationSender,
IChatRoomManager,
IChatRoomContainer,
IRCMessageChannel,
IChatRoomContainerOptionsAdapter {
    private static final long CONNECT_TIMEOUT = 20000L;
    protected IRCConnection connection = null;
    protected ReplyHandler replyHandler = null;
    protected Map channels = new HashMap();
    protected String username;
    protected String encoding = null;
    private ArrayList invitationListeners;
    protected Object connectLock = new Object();
    protected boolean connectWaiting = false;
    protected Exception connectException = null;
    protected IHistoryManager chatRoomHistoryManager = new IHistoryManager(){

        public IHistory getHistory(ID chatRoomID, Map options) {
            return null;
        }

        public boolean isActive() {
            return false;
        }

        public void setActive(boolean active) {
        }

        public Object getAdapter(Class adapter) {
            return null;
        }
    };

    public IRCRootContainer(ID localID) throws IDCreateException {
        this.localID = localID;
        this.unknownID = IDFactory.getDefault().createStringID(Messages.IRCRootContainer_0);
        this.replyHandler = new ReplyHandler();
        this.invitationListeners = new ArrayList();
    }

    public void connect(ID connectID, IConnectContext connectContext) throws ContainerConnectException {
        throw new Error("Unresolved compilation problem: \n\tThe constructor TimeoutException(long, String) is undefined\n");
    }

    protected void handleDisconnected() {
        Iterator i = this.channels.values().iterator();
        while (i.hasNext()) {
            IRCChannelContainer c = (IRCChannelContainer)((Object)i.next());
            c.disconnect();
        }
        this.fireContainerEvent((IContainerEvent)new ContainerDisconnectedEvent(this.getID(), this.targetID));
        this.channels.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleErrorIfConnecting(String message) {
        Object object = this.connectLock;
        synchronized (object) {
            if (this.connectWaiting) {
                this.connectException = new Exception(message);
            }
        }
    }

    protected IRCEventListener getIRCEventListener() {
        return new IRCEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onRegistered() {
                IRCRootContainer.this.trace("handleOnRegistered()");
                Object object = IRCRootContainer.this.connectLock;
                synchronized (object) {
                    IRCRootContainer.this.connectWaiting = false;
                    IRCRootContainer.this.connectLock.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onDisconnected() {
                IRCRootContainer.this.trace("handleOnDisconnected()");
                Object object = IRCRootContainer.this.connectLock;
                synchronized (object) {
                    if (IRCRootContainer.this.connectWaiting) {
                        if (IRCRootContainer.this.connectException == null) {
                            IRCRootContainer.this.connectException = new Exception(Messages.IRCRootContainer_Exception_Unexplained_Disconnect);
                        }
                        IRCRootContainer.this.connectWaiting = false;
                        IRCRootContainer.this.connectLock.notify();
                    }
                }
                if (IRCRootContainer.this.targetID != null) {
                    IRCRootContainer.this.showMessage(null, NLS.bind((String)Messages.IRCRootContainer_Disconnected, (Object)IRCRootContainer.this.targetID.getName()));
                    IRCRootContainer.this.handleDisconnected();
                }
            }

            public void onError(String arg0) {
                IRCRootContainer.this.trace("handleOnError(" + arg0 + ")");
                IRCRootContainer.this.showMessage(null, NLS.bind((String)Messages.IRCRootContainer_Error, (Object)arg0));
                IRCRootContainer.this.handleErrorIfConnecting(arg0);
            }

            public void onError(int arg0, String arg1) {
                String msg = String.valueOf(arg0) + "," + arg1;
                IRCRootContainer.this.trace("handleOnError(" + msg + ")");
                IRCRootContainer.this.showMessage(null, NLS.bind((String)Messages.IRCRootContainer_Error, (Object)msg));
                IRCRootContainer.this.handleErrorIfConnecting(String.valueOf(arg0) + msg);
            }

            public void onInvite(String arg0, IRCUser arg1, String arg2) {
                IRCRootContainer.this.handleInvite(IRCRootContainer.this.createIDFromString(arg0), IRCRootContainer.this.createIDFromString(arg1.getNick()));
            }

            public void onJoin(String arg0, IRCUser arg1) {
                IRCRootContainer.this.trace("handleOnJoin(" + arg0 + "," + arg1 + ")");
                IRCChannelContainer container = IRCRootContainer.this.getChannel(arg0);
                if (container != null) {
                    container.setIRCUser(arg1);
                }
            }

            public void onKick(String channelName, IRCUser kicker, String kicked, String reason) {
                IRCRootContainer.this.trace("handleOnKick(" + channelName + "," + kicker + "," + kicked + "," + reason + ")");
                IRCChannelContainer channel = IRCRootContainer.this.getChannel(channelName);
                if (channel != null) {
                    IRCRootContainer.this.showMessage(channelName, NLS.bind((String)Messages.IRCRootContainer_UserKicked, (Object[])new Object[]{kicker.getNick(), kicked, channelName, reason}));
                    if (kicked.equals(((IRCID)IRCRootContainer.this.targetID).getUsername())) {
                        channel.fireContainerEvent((IContainerEvent)new ContainerDisconnectingEvent(channel.getID(), channel.targetID));
                        channel.firePresenceListeners(false, new String[]{kicked});
                        channel.fireContainerEvent((IContainerEvent)new ContainerDisconnectedEvent(channel.getID(), channel.targetID));
                    } else {
                        channel.firePresenceListeners(false, new String[]{kicked});
                    }
                }
            }

            public void onMode(String arg0, IRCUser arg1, IRCModeParser arg2) {
                IRCRootContainer.this.trace("handleOnMode(" + arg0 + "," + arg1 + "," + arg2 + ")");
            }

            public void onMode(IRCUser arg0, String arg1, String arg2) {
                IRCRootContainer.this.trace("handleOnMode(" + arg0 + "," + arg1 + "," + arg2 + ")");
            }

            public void onNick(IRCUser arg0, String arg1) {
                IRCRootContainer.this.trace("handleOnNick(" + arg0 + "," + arg1 + ")");
            }

            public void onNotice(String arg0, IRCUser arg1, String arg2) {
                IRCRootContainer.this.trace("handleOnNotice(" + arg0 + "," + arg1 + "," + arg2 + ")");
                IRCRootContainer.this.showMessage(arg0, arg2);
            }

            public void onPart(String arg0, IRCUser arg1, String arg2) {
                IRCRootContainer.this.trace("handleOnPart(" + arg0 + "," + arg1 + "," + arg2 + ")");
                IRCChannelContainer channel = (IRCChannelContainer)((Object)IRCRootContainer.this.channels.get(arg0));
                if (channel != null) {
                    channel.firePresenceListeners(false, new String[]{IRCRootContainer.this.getIRCUserName(arg1)});
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onPing(String arg0) {
                IRCRootContainer.this.trace("handleOnPing(" + arg0 + ")");
                IRCRootContainer iRCRootContainer = IRCRootContainer.this;
                synchronized (iRCRootContainer) {
                    if (IRCRootContainer.this.connection != null) {
                        IRCRootContainer.this.connection.doPong(arg0);
                    }
                }
            }

            public void onPrivmsg(String arg0, IRCUser arg1, String arg2) {
                IRCRootContainer.this.trace("handleOnPrivmsg(" + arg0 + "," + arg1 + "," + arg2 + ")");
                if (arg2.equals("\u0001VERSION\u0001")) {
                    IRCRootContainer.this.showMessage(null, NLS.bind((String)Messages.IRCRootContainer_CTCP_VERSION_Request, (Object)arg1.toString()));
                } else {
                    IRCRootContainer.this.showMessage(arg0, arg1.toString(), arg2);
                }
            }

            public void onQuit(IRCUser arg0, String arg1) {
                IRCRootContainer.this.trace("handleOnQuit(" + arg0 + "," + arg1 + ")");
                Iterator i = IRCRootContainer.this.channels.values().iterator();
                while (i.hasNext()) {
                    IRCChannelContainer container = (IRCChannelContainer)((Object)i.next());
                    container.handleUserQuit(IRCRootContainer.this.getIRCUserName(arg0));
                }
            }

            public void onReply(int arg0, String arg1, String arg2) {
                IRCRootContainer.this.trace("handleOnReply(" + arg0 + "|" + arg1 + "|" + arg2 + ")");
                IRCRootContainer.this.replyHandler.handleReply(arg0, arg1, arg2);
            }

            public void onTopic(String arg0, IRCUser arg1, String arg2) {
                IRCRootContainer.this.trace("handleOnTopic(" + arg0 + "," + arg1 + "," + arg2 + ")");
                IRCRootContainer.this.handleSetSubject(arg0, arg1, arg2);
            }

            public void unknown(String arg0, String arg1, String arg2, String arg3) {
                IRCRootContainer.this.trace("handleUnknown(" + arg0 + "," + arg1 + "," + arg2 + "," + arg3 + ")");
                IRCRootContainer.this.showMessage(null, NLS.bind((String)Messages.IRCRootContainer_Unknown_Message, (Object[])new Object[]{arg0, arg1, arg2, arg3}));
            }
        };
    }

    protected String getIRCUserName(IRCUser user) {
        return user == null ? null : user.toString();
    }

    public void disconnect() {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
            this.targetID = null;
        }
    }

    public Object getAdapter(Class serviceType) {
        if (serviceType != null && serviceType.isInstance(this)) {
            return this;
        }
        return null;
    }

    public Namespace getConnectNamespace() {
        return IDFactory.getDefault().getNamespaceByName("ecf.irc.irclib");
    }

    public IChatRoomInfo getChatRoomInfo(final String roomName) {
        if (roomName == null) {
            return new IChatRoomInfo(){

                public IChatRoomContainer createChatRoomContainer() throws ContainerCreateException {
                    return IRCRootContainer.this;
                }

                public ID getConnectedID() {
                    return IRCRootContainer.this.getConnectedID();
                }

                public String getDescription() {
                    return "";
                }

                public String getName() {
                    return "/";
                }

                public int getParticipantsCount() {
                    return 0;
                }

                public ID getRoomID() {
                    return IRCRootContainer.this.getSystemID();
                }

                public String getSubject() {
                    return "";
                }

                public boolean isModerated() {
                    return false;
                }

                public boolean isPersistent() {
                    return false;
                }

                public boolean requiresPassword() {
                    return false;
                }

                public Object getAdapter(Class adapter) {
                    return null;
                }
            };
        }
        return new IChatRoomInfo(){

            public IChatRoomContainer createChatRoomContainer() throws ContainerCreateException {
                try {
                    IRCChannelContainer newChannelContainer = new IRCChannelContainer(IRCRootContainer.this, IDFactory.getDefault().createGUID());
                    IRCRootContainer.this.addChannel(roomName, newChannelContainer);
                    return newChannelContainer;
                }
                catch (Exception e) {
                    throw new ContainerCreateException(Messages.IRCRootContainer_Exception_Create_ChatRoom, (Throwable)e);
                }
            }

            public ID getConnectedID() {
                return IRCRootContainer.this.getConnectedID();
            }

            public String getDescription() {
                return "";
            }

            public String getName() {
                return roomName;
            }

            public int getParticipantsCount() {
                return 0;
            }

            public ID getRoomID() {
                return IRCRootContainer.this.createIDFromString(roomName);
            }

            public String getSubject() {
                return "";
            }

            public boolean isModerated() {
                return false;
            }

            public boolean isPersistent() {
                return false;
            }

            public boolean requiresPassword() {
                return false;
            }

            public Object getAdapter(Class adapter) {
                return null;
            }
        };
    }

    public IChatRoomInfo[] getChatRoomInfos() {
        return new IChatRoomInfo[0];
    }

    public IChatRoomManager[] getChildren() {
        return new IChatRoomManager[0];
    }

    public IChatRoomManager getParent() {
        return null;
    }

    public void addChatRoomParticipantListener(IChatRoomParticipantListener participantListener) {
    }

    public void removeChatRoomParticipantListener(IChatRoomParticipantListener participantListener) {
    }

    public IChatRoomMessageSender getChatRoomMessageSender() {
        return new IChatRoomMessageSender(){

            public void sendMessage(String message) throws ECFException {
                if (IRCRootContainer.this.isCommand(message)) {
                    IRCRootContainer.this.parseCommandAndSend(message, null, null);
                } else {
                    IRCRootContainer.this.showErrorMessage(null, NLS.bind((String)Messages.IRCRootContainer_Command_Error, (Object)message, (Object)"/"));
                }
            }
        };
    }

    protected String nextToken(StringBuffer buffer) {
        if (buffer.length() == 0) {
            return null;
        }
        int index = buffer.indexOf(" ");
        if (index == -1) {
            String token = buffer.toString();
            buffer.delete(0, buffer.length());
            return token;
        }
        String token = buffer.substring(0, index);
        while (buffer.length() > index && buffer.indexOf(" ", index) == index) {
            index += " ".length();
        }
        if (index > 0) {
            buffer.delete(0, index);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseCommandAndSend(String commandMessage, String channelName, String ircUser) {
        IRCRootContainer iRCRootContainer = this;
        synchronized (iRCRootContainer) {
            block27: {
                if (this.connection != null) {
                    try {
                        String lowerCase = commandMessage.toLowerCase();
                        StringBuffer command = new StringBuffer(commandMessage);
                        if (lowerCase.startsWith("/msg ")) {
                            int index = (commandMessage = commandMessage.substring(5)).indexOf(" ");
                            if (index != -1) {
                                this.connection.doPrivmsg(commandMessage.substring(0, index), commandMessage.substring(index + 1));
                            }
                            break block27;
                        }
                        if (lowerCase.startsWith("/privmsg ")) {
                            int index = (commandMessage = commandMessage.substring(9)).indexOf(" ");
                            if (index != -1) {
                                this.connection.doPrivmsg(commandMessage.substring(0, index), commandMessage.substring(index + 1));
                            }
                            break block27;
                        }
                        if (lowerCase.startsWith("/op ")) {
                            this.nextToken(command);
                            String nick = this.nextToken(command);
                            if (nick != null) {
                                this.connection.doMode(channelName, "+o " + nick);
                            }
                            break block27;
                        }
                        if (lowerCase.startsWith("/dop ")) {
                            this.nextToken(command);
                            String nick = this.nextToken(command);
                            if (nick != null) {
                                this.connection.doMode(channelName, "-o " + nick);
                            }
                            break block27;
                        }
                        if (lowerCase.startsWith("/ban ")) {
                            this.nextToken(command);
                            String nick = this.nextToken(command);
                            if (nick != null) {
                                this.connection.doMode(channelName, "+b " + nick);
                            }
                            break block27;
                        }
                        if (lowerCase.startsWith("/unban ")) {
                            this.nextToken(command);
                            String nick = this.nextToken(command);
                            if (nick != null) {
                                this.connection.doMode(channelName, "-b " + nick);
                            }
                            break block27;
                        }
                        if (lowerCase.startsWith("/kick ")) {
                            String comment;
                            this.nextToken(command);
                            String nick = this.nextToken(command);
                            if (nick.startsWith("#")) {
                                channelName = nick;
                                nick = this.nextToken(command);
                            }
                            if ((comment = command.toString()).length() > 0) {
                                this.connection.doKick(channelName, nick, comment);
                            } else {
                                this.connection.doKick(channelName, nick);
                            }
                            break block27;
                        }
                        if (lowerCase.startsWith("/mode ")) {
                            int index = (commandMessage = commandMessage.substring(6)).indexOf(" ");
                            if (index != -1) {
                                this.connection.doMode(channelName, commandMessage);
                            }
                            break block27;
                        }
                        if (lowerCase.startsWith("/me ")) {
                            this.nextToken(command);
                            String message = command.toString();
                            if (message.length() > 0) {
                                message = "\u0001ACTION " + message + "\u0001";
                                this.connection.doPrivmsg(channelName, message);
                                this.showMessage(channelName, ircUser, message);
                            }
                            break block27;
                        }
                        String[] tokens = this.parseCommandTokens(commandMessage);
                        this.handleCommandMessage(tokens, channelName);
                    }
                    catch (Exception e) {
                        this.showErrorMessage(channelName, NLS.bind((String)Messages.IRCRootContainer_Exception_Parse, (Object[])new Object[]{e.getClass().getName(), e.getLocalizedMessage()}));
                        this.traceStack(e, "PARSE ERROR: " + commandMessage);
                    }
                } else {
                    this.trace("parseMessageAndSend(" + commandMessage + ") Not connected for IRCContainer " + this.getID());
                }
            }
        }
    }

    private synchronized void handleCommandMessage(String[] tokens, String channelName) {
        String origCommand;
        String command = origCommand = tokens[0];
        while (command.startsWith("/")) {
            command = command.substring(1);
        }
        String[] args = new String[tokens.length - 1];
        System.arraycopy(tokens, 1, args, 0, tokens.length - 1);
        if (command.equalsIgnoreCase("JOIN")) {
            if (args.length > 1) {
                this.connection.doJoin(args[0], args[1]);
            } else if (args.length > 0) {
                this.connection.doJoin(args[0]);
            }
        } else if (command.equalsIgnoreCase("LIST")) {
            if (args.length > 0) {
                this.connection.doList(args[0]);
            } else {
                this.connection.doList();
            }
        } else if (command.equalsIgnoreCase("PART")) {
            if (args.length > 1) {
                this.connection.doPart(args[0], args[1]);
            } else if (args.length > 0) {
                this.connection.doPart(args[0]);
            }
        } else if (command.equalsIgnoreCase("NICK")) {
            if (args.length > 0) {
                this.connection.doNick(args[0]);
            }
        } else if (command.equalsIgnoreCase("NOTICE")) {
            if (args.length > 1) {
                this.connection.doNotice(args[0], args[1]);
            }
        } else if (command.equalsIgnoreCase("WHOIS")) {
            if (args.length > 0) {
                this.connection.doWhois(args[0]);
            }
        } else if (command.equalsIgnoreCase("QUIT")) {
            if (args.length > 0) {
                this.connection.doQuit(args[0]);
            } else {
                this.connection.doQuit();
            }
        } else if (command.equalsIgnoreCase("AWAY")) {
            if (args.length > 0) {
                this.connection.doAway(args[0]);
            } else {
                this.connection.doAway();
            }
        } else if (command.equalsIgnoreCase("TOPIC")) {
            if (args.length > 1) {
                StringBuffer sb = new StringBuffer();
                int i = 1;
                while (i < args.length) {
                    if (i > 1) {
                        sb.append(" ");
                    }
                    sb.append(args[i]);
                    ++i;
                }
                this.connection.doTopic(args[0], sb.toString());
            } else if (args.length > 0) {
                this.connection.doTopic(args[0]);
            }
        } else if (command.equalsIgnoreCase("INVITE")) {
            if (args.length > 1) {
                this.connection.doInvite(args[0], args[1]);
            }
        } else {
            String msg = NLS.bind((String)Messages.IRCRootContainer_Command_Unrecognized, (Object)origCommand);
            this.trace(String.valueOf(msg) + " in IRCContainer: " + this.getID());
            this.showErrorMessage(channelName, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleInvite(ID channelID, ID fromID) {
        ArrayList arrayList = this.invitationListeners;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.invitationListeners.size()) {
                IChatRoomInvitationListener icril = (IChatRoomInvitationListener)this.invitationListeners.get(i);
                icril.handleInvitationReceived(channelID, fromID, null, null);
                ++i;
            }
        }
    }

    protected IRCChannelContainer getChannel(String channel) {
        if (channel == null) {
            return null;
        }
        IRCChannelContainer container = this.getContainerForChannel(channel);
        if (container == null) {
            return null;
        }
        return container;
    }

    protected void showMessage(String channel, String msg) {
        IRCChannelContainer msgChannel = this.getChannel(channel);
        if (msgChannel != null) {
            msgChannel.fireChatRoomMessageEvent(this.createIDFromString(channel), msg);
        } else {
            this.fireChatRoomMessageEvent(channel == null ? this.getSystemID() : this.createIDFromString(channel), msg);
        }
    }

    protected void showMessage(String channel, String user, String msg) {
        IRCChannelContainer msgChannel = this.getChannel(channel);
        if (msgChannel != null) {
            msgChannel.fireChatRoomMessageEvent(this.createIDFromString(user), msg);
        } else {
            this.fireChatMessageEvent(this.createIDFromString(user), msg);
            Iterator it = this.channels.values().iterator();
            while (it.hasNext()) {
                msgChannel = (IRCChannelContainer)((Object)it.next());
                msgChannel.fireChatMessageEvent(this.createIDFromString(user), msg);
            }
        }
    }

    void showErrorMessage(String channel, String msg) {
        IRCChannelContainer msgChannel = this.getChannel(channel);
        if (msgChannel != null) {
            msgChannel.fireChatRoomMessageEvent(this.username == null ? this.getSystemID() : this.createIDFromString(this.username), msg);
        } else {
            this.fireChatRoomMessageEvent(this.username == null ? this.getSystemID() : this.createIDFromString(this.username), msg);
        }
    }

    ID getSystemID() {
        if (this.targetID == null) {
            return this.unknownID;
        }
        try {
            return IDFactory.getDefault().createStringID(((IRCID)this.targetID).getHost());
        }
        catch (IDCreateException e) {
            Activator.log("ID creation exception in IRCContainer.getSystemID()", e);
            return this.unknownID;
        }
    }

    protected void handle353Reply(String channel, String[] strings) {
        IRCChannelContainer container = this.getChannel(channel);
        if (container == null) {
            this.showMessage(null, NLS.bind((String)Messages.IRCRootContainer_353_Error, (Object)channel));
        } else {
            container.firePresenceListeners(true, strings);
        }
    }

    protected void handleSetSubject(String channelName, IRCUser user, String newSubject) {
        IRCChannelContainer channel = (IRCChannelContainer)((Object)this.channels.get(channelName));
        if (channel == null) {
            this.showMessage(null, newSubject);
            this.fireSubjectListeners(null, newSubject);
        } else {
            ID fromID;
            String nickname = user == null ? null : user.getNick();
            ID iD = fromID = user == null ? null : this.createIDFromString(this.getIRCUserName(user));
            if (nickname == null) {
                this.showMessage(channelName, newSubject);
            } else {
                this.showMessage(channelName, NLS.bind((String)Messages.IRCRootContainer_TopicChange, (Object[])new Object[]{nickname, newSubject}));
            }
            channel.fireSubjectListeners(fromID, newSubject);
        }
    }

    protected void doJoinChannel(String channelName, String key) {
        if (this.connection != null) {
            if (key == null || key.equals("")) {
                this.connection.doJoin(channelName);
            } else {
                this.connection.doJoin(channelName, key);
            }
        }
    }

    protected void doPartChannel(String channelName) {
        if (this.connection != null) {
            this.connection.doPart(channelName);
        }
    }

    protected void doSendChannelMessage(String channelName, String ircUser, String msg) {
        if (this.connection != null) {
            if (this.isCommand(msg)) {
                this.parseCommandAndSend(msg, channelName, ircUser);
            } else {
                this.connection.doPrivmsg(channelName, msg);
                this.showMessage(channelName, ircUser, msg);
            }
        }
    }

    protected void doSendSubjectChangeMessage(String channelName, String topic) throws ECFException {
        if (this.connection == null) {
            throw new ECFException(Messages.IRCRootContainer_Exception_Unexplained_Disconnect);
        }
        this.connection.doTopic(channelName, topic);
    }

    protected void addChannel(String channel, IRCChannelContainer container) {
        this.channels.put(channel, container);
    }

    protected IRCChannelContainer getContainerForChannel(String channel) {
        return (IRCChannelContainer)((Object)this.channels.get(channel));
    }

    protected void removeChannel(String channel) {
        this.channels.remove(channel);
    }

    public boolean setEncoding(String encoding) {
        if (this.connection == null) {
            this.encoding = encoding;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInvitationListener(IChatRoomInvitationListener listener) {
        if (listener != null) {
            ArrayList arrayList = this.invitationListeners;
            synchronized (arrayList) {
                if (!this.invitationListeners.contains(listener)) {
                    this.invitationListeners.add(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInvitationListener(IChatRoomInvitationListener listener) {
        if (listener != null) {
            ArrayList arrayList = this.invitationListeners;
            synchronized (arrayList) {
                this.invitationListeners.remove(listener);
            }
        }
    }

    public IChatRoomInfo createChatRoom(String roomname, Map properties) throws ChatRoomCreateException {
        throw new ChatRoomCreateException(roomname, Messages.IRCRootContainer_Exception_Create_Not_Supported, null);
    }

    public IHistoryManager getHistoryManager() {
        return this.chatRoomHistoryManager;
    }

    public IChatRoomInvitationSender getInvitationSender() {
        return this;
    }

    public void sendInvitation(ID room, ID targetUser, String subject, String body) throws ECFException {
        if (this.connection == null) {
            throw new ECFException(Messages.IRCRootContainer_EXCEPTION_CONNECTION_CANNOT_BE_NULL);
        }
        this.connection.doInvite(targetUser.getName(), room.getName());
    }

    public void sendChatMessage(ID toID, ID threadID, IChatMessage.Type type, String subject, String body, Map properties) throws ECFException {
        this.sendChatMessage(toID, body);
    }

    public void sendChatMessage(ID toID, String body) throws ECFException {
        if (toID == null) {
            throw new ECFException(Messages.IRCRootContainer_EXCEPTION_TARGETID_CANNOT_BE_NULL);
        }
        String name = toID.getName();
        if (name.charAt(0) == '@') {
            name = name.substring(1);
        }
        this.connection.doPrivmsg(name, body);
    }

    public IChatMessageSender getPrivateMessageSender() {
        return this;
    }

    public ID[] getChatRoomParticipants() {
        return new ID[0];
    }

    public IChatRoomAdminSender getChatRoomAdminSender() {
        return null;
    }

    protected class ReplyHandler {
        protected ReplyHandler() {
        }

        public void handleReply(int code, String arg1, String arg2) {
            String[] users = IRCRootContainer.this.parseUsers(arg1);
            switch (code) {
                case 353: {
                    IRCRootContainer.this.handle353Reply(users[2], IRCRootContainer.this.parseUserNames(arg2));
                    break;
                }
                case 311: {
                    IRCRootContainer.this.showMessage(null, NLS.bind((String)Messages.IRCRootContainer_Whois, (Object)users[1]));
                    IRCRootContainer.this.showMessage(null, String.valueOf(this.trimUsername(users[2])) + "@" + users[3]);
                    break;
                }
                case 312: {
                    IRCRootContainer.this.showMessage(null, NLS.bind((String)Messages.IRCRootContainer_Server, (Object[])new Object[]{users[2], arg2}));
                    break;
                }
                case 317: {
                    IRCRootContainer.this.showMessage(null, NLS.bind((String)Messages.IRCRootContainer_Idle, (Object)users[2]));
                    break;
                }
                case 318: {
                    IRCRootContainer.this.showMessage(null, Messages.IRCRootContainer_Whois_End);
                    break;
                }
                case 319: {
                    IRCRootContainer.this.showMessage(null, NLS.bind((String)Messages.IRCRootContainer_Channels, (Object)arg2));
                    break;
                }
                case 320: {
                    break;
                }
                case 331: 
                case 332: {
                    String[] args = IRCRootContainer.this.parseCommandTokens(arg1);
                    String channel = args.length == 2 ? args[1] : (args.length == 1 ? args[0] : null);
                    IRCRootContainer.this.handleSetSubject(channel, null, arg2);
                    break;
                }
                default: {
                    if (users.length < 2) {
                        IRCRootContainer.this.showMessage(null, arg2);
                        break;
                    }
                    IRCRootContainer.this.showMessage(users[1], IRCRootContainer.this.concat(users, 2, arg2));
                }
            }
        }

        private String trimUsername(String un) {
            int eq = un.indexOf(61);
            return un.substring(eq + 1);
        }
    }
}

