/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.jslp;

import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.ServiceURL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.internal.provider.jslp.Activator;
import org.eclipse.ecf.internal.provider.jslp.JSLPDebugOptions;
import org.eclipse.ecf.internal.provider.jslp.Messages;
import org.eclipse.ecf.internal.provider.jslp.ServicePropertiesAdapter;
import org.eclipse.ecf.internal.provider.jslp.ServiceURLAdapter;
import org.eclipse.ecf.provider.jslp.container.JSLPDiscoveryContainer;
import org.eclipse.ecf.provider.jslp.container.JSLPServiceInfo;

public final class JSLPDiscoveryJob
extends Job {
    private JSLPDiscoveryContainer discoveryContainer;
    private Map services;

    public JSLPDiscoveryJob(JSLPDiscoveryContainer container) {
        super(Messages.JSLPDiscoveryJob_TITLE);
        this.discoveryContainer = container;
        this.services = Collections.synchronizedMap(new HashMap());
    }

    protected IStatus run(IProgressMonitor monitor) {
        Assert.isNotNull((Object)monitor);
        try {
            Map availableServices = Activator.getDefault().getLocator().getServiceURLs();
            HashMap removedServices = new HashMap(this.services);
            Iterator itr = availableServices.entrySet().iterator();
            while (itr.hasNext() && !monitor.isCanceled()) {
                Map.Entry entry = itr.next();
                ServiceURL url = (ServiceURL)entry.getKey();
                if (removedServices.containsKey(url)) {
                    removedServices.remove(url);
                } else {
                    ServicePropertiesAdapter spa = new ServicePropertiesAdapter((List)entry.getValue());
                    JSLPServiceInfo serviceInfo = new JSLPServiceInfo(new ServiceURLAdapter(url, spa.getServiceName()), spa.getPriority(), spa.getWeight(), spa);
                    this.services.put(url, serviceInfo);
                    this.discoveryContainer.fireServiceDiscovered(serviceInfo);
                }
                monitor.worked(1);
            }
            itr = removedServices.keySet().iterator();
            while (itr.hasNext() && !monitor.isCanceled()) {
                Map.Entry key = itr.next();
                this.discoveryContainer.fireServiceUndiscovered((IServiceInfo)removedServices.get(key));
                this.services.remove(key);
                monitor.worked(1);
            }
        }
        catch (ServiceLocationException e) {
            Trace.catching((String)"org.eclipse.ecf.provider.jslp", (String)JSLPDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"run", (Throwable)e);
        }
        this.schedule(JSLPDiscoveryContainer.REDISCOVER);
        return Status.OK_STATUS;
    }

    public boolean shouldRun() {
        if (Activator.getDefault() != null) {
            int state = Activator.getDefault().getBundle().getState();
            return state == 32 || state == 8;
        }
        return false;
    }
}

