/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.remoteservice.generic;

import java.io.Serializable;
import java.security.AccessControlException;
import org.eclipse.core.runtime.Assert;

public class AddRegistrationRequest
implements Serializable {
    private static final long serialVersionUID = -2671778516104780091L;
    String service;
    String filter;
    AccessControlException acc;
    AddRegistrationRequest parent;
    private boolean done = false;

    public AddRegistrationRequest(String service, String filter, AddRegistrationRequest parent) {
        Assert.isNotNull((Object)service);
        this.service = service;
        this.filter = filter;
        this.parent = parent;
    }

    public String getService() {
        return this.service;
    }

    public String getFilter() {
        return this.filter;
    }

    public Integer getId() {
        return new Integer(System.identityHashCode(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForResponse(long timeout) {
        long startTime = System.currentTimeMillis();
        long endTime = startTime + timeout;
        AddRegistrationRequest addRegistrationRequest = this;
        synchronized (addRegistrationRequest) {
            while (!this.done && endTime >= System.currentTimeMillis()) {
                try {
                    this.wait(timeout / 10L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public AccessControlException getException() {
        return this.acc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyResponse(AccessControlException exception) {
        this.acc = exception;
        AddRegistrationRequest addRegistrationRequest = this;
        synchronized (addRegistrationRequest) {
            this.done = true;
            if (this.parent != null) {
                this.parent.notifyResponse(exception);
            } else {
                AddRegistrationRequest addRegistrationRequest2 = this;
                synchronized (addRegistrationRequest2) {
                    this.notify();
                }
            }
        }
    }
}

