/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.examples.remoteservices.server;

import java.net.URI;
import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.discovery.IDiscoveryAdvertiser;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceProperties;
import org.eclipse.ecf.discovery.ServiceInfo;
import org.eclipse.ecf.discovery.ServiceProperties;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.discovery.identity.ServiceIDFactory;
import org.eclipse.ecf.internal.examples.remoteservices.server.Activator;
import org.eclipse.ecf.internal.examples.remoteservices.server.RemoteEnvironmentInfoImpl;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.util.DiscoveryProperties;
import org.eclipse.ecf.remoteservice.util.RemoteServiceProperties;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;

public class DiscoverableServer
implements IApplication {
    public static final String serviceHostContainerTypeArg = "-serviceHostContainerType";
    public static final String serviceHostNamespaceArg = "-serviceHostNamespace";
    public static final String serviceHostIDArg = "-serviceHostID";
    public static final String clientContainerTypeArg = "-clientContainerType";
    public static final String clientConnectTargetArg = "-clientConnectTarget";
    public static final String serviceTypeArg = "-serviceType";
    private String protocol = "ecftcp";
    private String serviceHostContainerType = "ecf.generic.server";
    private String serviceHostNamespace;
    private String serviceHostID;
    private String clientContainerType;
    private String clientConnectTarget;
    private String serviceType;
    private IContainer serviceHostContainer;
    private IServiceInfo serviceInfo;
    private IDiscoveryAdvertiser discoveryService;
    private boolean done;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public DiscoverableServer() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.core.identity.StringID");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.serviceHostNamespace = clazz.getName();
        this.serviceHostID = String.valueOf(this.protocol) + "://localhost:3285/server";
        this.clientContainerType = "ecf.generic.client";
        this.clientConnectTarget = String.valueOf(this.protocol) + "://localhost:3285/server";
        this.serviceType = "remotesvcs";
        this.done = false;
    }

    protected IContainer createServiceHostContainer() throws IDCreateException, ContainerCreateException {
        return ContainerFactory.getDefault().createContainer(this.serviceHostContainerType, IDFactory.getDefault().createID(this.serviceHostNamespace, this.serviceHostID));
    }

    protected Properties createServiceDiscoveryProperties() {
        RemoteServiceProperties props = new RemoteServiceProperties(this.serviceHostContainerType, this.serviceHostContainer);
        props.put("ecf.rsvc.areg", "true");
        return props;
    }

    public void start(String[] args) throws Exception {
        this.initializeFromArguments(args);
        this.serviceHostContainer = this.createServiceHostContainer();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IRemoteServiceContainerAdapter containerAdapter = (IRemoteServiceContainerAdapter)this.serviceHostContainer.getAdapter((Class)clazz);
        Assert.isNotNull((Object)containerAdapter);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.ecf.examples.remoteservices.common.IRemoteEnvironmentInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String serviceClassName = clazz2.getName();
        containerAdapter.registerRemoteService(new String[]{serviceClassName}, (Object)new RemoteEnvironmentInfoImpl(), (Dictionary)this.createServiceDiscoveryProperties());
        System.out.println("Registered remote service " + serviceClassName + " with " + this.serviceHostContainer + ",ID=" + this.serviceHostContainer.getID());
        this.discoveryService = Activator.getDefault().getDiscoveryService(15000);
        Assert.isNotNull((Object)this.discoveryService);
        String serviceName = String.valueOf(System.getProperty("user.name")) + System.currentTimeMillis();
        IServiceTypeID serviceID = ServiceIDFactory.getDefault().createServiceTypeID(this.discoveryService.getServicesNamespace(), new String[]{this.serviceType}, new String[]{this.protocol});
        Properties serviceProperties = this.createServicePropertiesForDiscovery(serviceClassName);
        URI uri = new URI(this.serviceHostID);
        this.serviceInfo = new ServiceInfo(uri, serviceName, serviceID, 0, 0, (IServiceProperties)new ServiceProperties(serviceProperties));
        this.discoveryService.registerService(this.serviceInfo);
        System.out.println("service published for discovery\n\tserviceName=" + serviceName + "\n\tserviceTypeID=" + serviceID);
        System.out.println("\tserviceProperties=" + serviceProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object start(IApplicationContext ctxt) throws Exception {
        this.start((String[])ctxt.getArguments().get("application.args"));
        DiscoverableServer discoverableServer = this;
        synchronized (discoverableServer) {
            while (!this.done) {
                this.wait();
            }
        }
        return new Integer(0);
    }

    protected Properties createServicePropertiesForDiscovery(String className) {
        return new DiscoveryProperties(className, this.clientContainerType, this.serviceHostNamespace, this.clientConnectTarget, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.serviceInfo != null && this.discoveryService != null) {
            IContainer container;
            this.discoveryService.unregisterService(this.serviceInfo);
            this.serviceInfo = null;
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.ecf.core.IContainer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((container = (IContainer)this.discoveryService.getAdapter((Class)clazz)) != null) {
                container.disconnect();
            }
            this.discoveryService = null;
        }
        if (this.serviceHostContainer != null) {
            this.serviceHostContainer.disconnect();
            this.serviceHostContainer = null;
        }
        DiscoverableServer discoverableServer = this;
        synchronized (discoverableServer) {
            this.done = true;
            this.notifyAll();
        }
    }

    private void initializeFromArguments(String[] args) throws Exception {
        if (args == null) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase(serviceHostContainerTypeArg)) {
                this.serviceHostContainerType = args[++i];
            } else if (args[i].equalsIgnoreCase(serviceHostNamespaceArg)) {
                this.serviceHostNamespace = args[++i];
            } else if (args[i].equalsIgnoreCase(serviceHostIDArg)) {
                this.serviceHostID = args[++i];
            } else if (args[i].equalsIgnoreCase(clientContainerTypeArg)) {
                this.clientContainerType = args[++i];
            } else if (args[i].equalsIgnoreCase(clientConnectTargetArg)) {
                this.clientConnectTarget = args[++i];
            } else if (args[i].equalsIgnoreCase(serviceTypeArg)) {
                this.serviceType = args[++i];
            } else {
                this.usage();
                throw new IllegalArgumentException("Invalid argument");
            }
            ++i;
        }
    }

    private void usage() {
        System.out.println("usage: eclipse -console [options] -application org.eclipse.ecf.examples.remoteservices.server.remoteServicesServer");
        System.out.println("   options: [-serviceHostContainerType <typename>] default=ecf.generic.server");
        System.out.println("            [-serviceHostNamespace <namespacename>] default=org.eclipse.ecf.identity.StringID");
        System.out.println("            [-serviceHostID <hostID>] default=ecftcp://localhost:3285/server");
        System.out.println("            [-clientContainerType <typename>] default=ecf.generic.client");
        System.out.println("            [-clientConnectTarget <target>] default=ecftcp://localhost:3285/server");
        System.out.println("            [-serviceType <serviceType>] default=remotesvcs");
    }
}

