/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.xmpp;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.internal.provider.xmpp.Messages;
import org.eclipse.ecf.internal.provider.xmpp.XMPPChatRoomContainer;
import org.eclipse.ecf.internal.provider.xmpp.XmppPlugin;
import org.eclipse.ecf.internal.provider.xmpp.smack.ECFConnection;
import org.eclipse.ecf.presence.chatroom.ChatRoomCreateException;
import org.eclipse.ecf.presence.chatroom.IChatRoomContainer;
import org.eclipse.ecf.presence.chatroom.IChatRoomInfo;
import org.eclipse.ecf.presence.chatroom.IChatRoomInvitationListener;
import org.eclipse.ecf.presence.chatroom.IChatRoomInvitationSender;
import org.eclipse.ecf.presence.chatroom.IChatRoomManager;
import org.eclipse.ecf.presence.history.IHistory;
import org.eclipse.ecf.presence.history.IHistoryManager;
import org.eclipse.ecf.provider.xmpp.identity.XMPPID;
import org.eclipse.ecf.provider.xmpp.identity.XMPPRoomID;
import org.eclipse.osgi.util.NLS;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.muc.HostedRoom;
import org.jivesoftware.smackx.muc.InvitationListener;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.RoomInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;

public class XMPPChatRoomManager
implements IChatRoomManager {
    private static final String PROP_XMPP_SUBJECT = "subject";
    public static final String PROP_XMPP_CONFERENCE = "conference";
    private ID containerID = null;
    private Namespace connectNamespace = null;
    private final List invitationListeners = new ArrayList();
    private ECFConnection ecfConnection = null;
    private final List chatrooms = new ArrayList();
    private ID connectedID = null;
    private final IChatRoomInvitationSender invitationSender = new IChatRoomInvitationSender(){

        public void sendInvitation(ID room, ID targetUser, String subject, String body) throws ECFException {
            XMPPChatRoomManager.this.sendInvitation(room, targetUser, subject, body);
        }
    };
    protected IHistoryManager chatRoomHistoryManager = new IHistoryManager(){

        public IHistory getHistory(ID chatRoomID, Map options) {
            return null;
        }

        public boolean isActive() {
            return false;
        }

        public void setActive(boolean active) {
        }

        public Object getAdapter(Class adapter) {
            if (adapter == null) {
                return null;
            }
            if (adapter.isInstance(this)) {
                return this;
            }
            IAdapterManager adapterManager = XmppPlugin.getDefault().getAdapterManager();
            return adapterManager == null ? null : adapterManager.loadAdapter((Object)this, adapter.getName());
        }
    };

    public XMPPChatRoomManager(ID containerID) {
        this.containerID = containerID;
    }

    protected void sendInvitation(ID room, ID targetUser, String subject, String body) throws ECFException {
        XMPPChatRoomContainer chatRoomContainer = this.getChatRoomContainer(room);
        if (chatRoomContainer == null) {
            throw new ECFException(NLS.bind((String)Messages.XMPPChatRoomManager_ROOM_NOT_FOUND, (Object)room.getName()));
        }
        chatRoomContainer.sendInvitation(targetUser, subject, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChat(XMPPChatRoomContainer container) {
        List list = this.chatrooms;
        synchronized (list) {
            this.chatrooms.add(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeChat(XMPPChatRoomContainer container) {
        List list = this.chatrooms;
        synchronized (list) {
            this.chatrooms.remove((Object)container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XMPPChatRoomContainer getChatRoomContainer(ID roomID) {
        if (roomID == null) {
            return null;
        }
        ArrayList toNotify = null;
        List list = this.chatrooms;
        synchronized (list) {
            toNotify = new ArrayList(this.chatrooms);
        }
        Iterator i = toNotify.iterator();
        while (i.hasNext()) {
            XMPPChatRoomContainer container = (XMPPChatRoomContainer)((Object)i.next());
            ID containerRoomID = container.getConnectedID();
            if (containerRoomID == null || !containerRoomID.equals((Object)roomID)) continue;
            return container;
        }
        return null;
    }

    protected ID createRoomIDFromName(String from) {
        try {
            return new XMPPRoomID(this.connectNamespace, this.ecfConnection.getXMPPConnection(), from);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    protected ID createUserIDFromName(String name) {
        XMPPID result = null;
        try {
            result = new XMPPID(this.connectNamespace, name);
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setConnection(Namespace connectNamespace, ID connectedID, ECFConnection connection) {
        this.connectNamespace = connectNamespace;
        this.connectedID = connectedID;
        this.ecfConnection = connection;
        if (connection != null) {
            MultiUserChat.addInvitationListener((XMPPConnection)this.ecfConnection.getXMPPConnection(), (InvitationListener)new InvitationListener(){

                public void invitationReceived(XMPPConnection arg0, String arg1, String arg2, String arg3, String arg4, Message arg5) {
                    XMPPChatRoomManager.this.fireInvitationReceived(XMPPChatRoomManager.this.createRoomIDFromName(arg1), XMPPChatRoomManager.this.createUserIDFromName(arg2), XMPPChatRoomManager.this.createUserIDFromName(arg5.getTo()), arg5.getSubject(), arg3);
                }
            });
        } else {
            this.disposeChatRooms();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeChatRooms() {
        ArrayList toNotify = null;
        List list = this.chatrooms;
        synchronized (list) {
            toNotify = new ArrayList(this.chatrooms);
            this.chatrooms.clear();
        }
        Iterator i = toNotify.iterator();
        while (i.hasNext()) {
            IChatRoomContainer cc = (IChatRoomContainer)i.next();
            cc.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        List list = this.invitationListeners;
        synchronized (list) {
            this.invitationListeners.clear();
        }
        this.containerID = null;
        this.connectNamespace = null;
        this.disposeChatRooms();
        this.setConnection(null, null, null);
    }

    public IChatRoomManager[] getChildren() {
        return new IChatRoomManager[0];
    }

    protected ID createIDFromHostedRoom(HostedRoom room) {
        try {
            return new XMPPRoomID(this.connectNamespace, this.ecfConnection.getXMPPConnection(), room.getJid(), room.getName());
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IChatRoomContainer findReceiverChatRoom(ID toID) {
        if (toID == null) {
            return null;
        }
        XMPPRoomID roomID = null;
        if (toID instanceof XMPPRoomID) {
            roomID = (XMPPRoomID)toID;
            String mucname = roomID.getMucString();
            ArrayList toNotify = null;
            List list = this.chatrooms;
            synchronized (list) {
                toNotify = new ArrayList(this.chatrooms);
            }
            Iterator i = toNotify.iterator();
            while (i.hasNext()) {
                XMPPRoomID targetID;
                String tmuc;
                ID tid;
                IChatRoomContainer cont = (IChatRoomContainer)i.next();
                if (cont == null || (tid = cont.getConnectedID()) == null || !(tid instanceof XMPPRoomID) || !(tmuc = (targetID = (XMPPRoomID)tid).getMucString()).equals(mucname)) continue;
                return cont;
            }
        }
        return null;
    }

    protected ID[] getChatRooms() {
        if (this.ecfConnection == null) {
            return null;
        }
        XMPPConnection conn = this.ecfConnection.getXMPPConnection();
        if (conn == null) {
            return null;
        }
        ArrayList<ID> result = new ArrayList<ID>();
        try {
            Collection svcs = MultiUserChat.getServiceNames((XMPPConnection)conn);
            Iterator svcsi = svcs.iterator();
            while (svcsi.hasNext()) {
                String svc = (String)svcsi.next();
                Collection rooms = MultiUserChat.getHostedRooms((XMPPConnection)conn, (String)svc);
                Iterator roomsi = rooms.iterator();
                while (roomsi.hasNext()) {
                    HostedRoom room = (HostedRoom)roomsi.next();
                    ID roomID = this.createIDFromHostedRoom(room);
                    if (roomID == null) continue;
                    result.add(roomID);
                }
            }
        }
        catch (XMPPException xMPPException) {
            return null;
        }
        return result.toArray(new ID[0]);
    }

    protected IChatRoomInfo getChatRoomInfo(ID roomID) {
        if (!(roomID instanceof XMPPRoomID)) {
            return null;
        }
        XMPPRoomID cRoomID = (XMPPRoomID)roomID;
        try {
            RoomInfo info = MultiUserChat.getRoomInfo((XMPPConnection)this.ecfConnection.getXMPPConnection(), (String)cRoomID.getMucString());
            if (info != null) {
                return new ECFRoomInfo(cRoomID, info, this.connectedID);
            }
        }
        catch (XMPPException xMPPException) {
            return null;
        }
        return null;
    }

    public IChatRoomInfo getChatRoomInfo(String roomname) {
        block4: {
            try {
                if (this.ecfConnection != null) break block4;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        XMPPConnection conn = this.ecfConnection.getXMPPConnection();
        XMPPRoomID roomID = new XMPPRoomID(this.connectNamespace, conn, roomname);
        String mucName = roomID.getMucString();
        RoomInfo info = MultiUserChat.getRoomInfo((XMPPConnection)conn, (String)mucName);
        if (info != null) {
            return new ECFRoomInfo(roomID, info, this.connectedID);
        }
        return null;
    }

    public IChatRoomInfo[] getChatRoomInfos() {
        ID[] chatRooms = this.getChatRooms();
        if (chatRooms == null) {
            return new IChatRoomInfo[0];
        }
        IChatRoomInfo[] res = new IChatRoomInfo[chatRooms.length];
        int count = 0;
        int i = 0;
        while (i < chatRooms.length) {
            IChatRoomInfo infoResult = this.getChatRoomInfo(chatRooms[i]);
            if (infoResult != null) {
                res[count++] = infoResult;
            }
            ++i;
        }
        IChatRoomInfo[] results = new IChatRoomInfo[count];
        int i2 = 0;
        while (i2 < count) {
            results[i2] = res[i2];
            ++i2;
        }
        return results;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isInstance(this)) {
            return this;
        }
        IAdapterManager adapterManager = XmppPlugin.getDefault().getAdapterManager();
        return adapterManager == null ? null : adapterManager.loadAdapter((Object)this, adapter.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInvitationListener(IChatRoomInvitationListener listener) {
        List list = this.invitationListeners;
        synchronized (list) {
            this.invitationListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInvitationListener(IChatRoomInvitationListener listener) {
        List list = this.invitationListeners;
        synchronized (list) {
            this.invitationListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireInvitationReceived(ID roomID, ID fromID, ID toID, String subject, String body) {
        ArrayList toNotify = null;
        List list = this.invitationListeners;
        synchronized (list) {
            toNotify = new ArrayList(this.invitationListeners);
        }
        Iterator i = toNotify.iterator();
        while (i.hasNext()) {
            IChatRoomInvitationListener l = (IChatRoomInvitationListener)i.next();
            l.handleInvitationReceived(roomID, fromID, subject, body);
        }
    }

    public IChatRoomManager getParent() {
        return null;
    }

    public IChatRoomInfo createChatRoom(String roomname, Map properties) throws ChatRoomCreateException {
        if (roomname == null) {
            throw new ChatRoomCreateException(roomname, Messages.XMPPChatRoomManager_EXCEPTION_ROOM_CANNOT_BE_NULL);
        }
        try {
            RoomInfo info;
            String longname;
            String nickname = this.ecfConnection.getXMPPConnection().getUser();
            String server = this.ecfConnection.getXMPPConnection().getHost();
            String domain = properties == null ? PROP_XMPP_CONFERENCE : (String)properties.get(PROP_XMPP_CONFERENCE);
            String conference = XMPPRoomID.fixConferenceDomain(domain, server);
            String roomID = String.valueOf(roomname) + "@" + conference;
            MultiUserChat muc = new MultiUserChat(this.ecfConnection.getXMPPConnection(), roomID);
            if (!this.checkRoom(conference, roomID)) {
                String subject;
                muc.create(nickname);
                muc.sendConfigurationForm(new Form("submit"));
                String string = subject = properties == null ? null : (String)properties.get(PROP_XMPP_SUBJECT);
                if (subject != null) {
                    muc.changeSubject(subject);
                }
            }
            if ((longname = muc.getRoom()) == null || longname.length() <= 0) {
                longname = roomID;
            }
            if ((info = MultiUserChat.getRoomInfo((XMPPConnection)this.ecfConnection.getXMPPConnection(), (String)roomID)) != null) {
                XMPPRoomID xid = new XMPPRoomID(this.connectedID.getNamespace(), this.ecfConnection.getXMPPConnection(), roomID, longname);
                return new ECFRoomInfo(xid, info, this.connectedID);
            }
            throw new XMPPException(NLS.bind((String)Messages.XMPPChatRoomManager_EXCEPTION_NO_ROOM_INFO, (Object)roomID));
        }
        catch (XMPPException e) {
            throw new ChatRoomCreateException(roomname, e.getMessage(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new ChatRoomCreateException(roomname, e.getMessage(), (Throwable)e);
        }
    }

    protected boolean checkRoom(String conference, String room) throws XMPPException {
        XMPPConnection conn = this.ecfConnection.getXMPPConnection();
        ServiceDiscoveryManager serviceDiscoveryManager = new ServiceDiscoveryManager(conn);
        DiscoverItems result = serviceDiscoveryManager.discoverItems(conference);
        Iterator items = result.getItems();
        while (items.hasNext()) {
            DiscoverItems.Item item = (DiscoverItems.Item)items.next();
            if (!room.equals(item.getEntityID())) continue;
            return true;
        }
        return false;
    }

    public IHistoryManager getHistoryManager() {
        return this.chatRoomHistoryManager;
    }

    public IChatRoomInvitationSender getInvitationSender() {
        return this.invitationSender;
    }

    class ECFRoomInfo
    implements IChatRoomInfo {
        RoomInfo info;
        XMPPRoomID roomID;
        ID connectedID;

        public ECFRoomInfo(XMPPRoomID roomID, RoomInfo info, ID connectedID) {
            this.roomID = roomID;
            this.info = info;
            this.connectedID = connectedID;
        }

        public String getDescription() {
            return this.info.getDescription();
        }

        public String getSubject() {
            return this.info.getSubject();
        }

        public ID getRoomID() {
            return this.roomID;
        }

        public int getParticipantsCount() {
            return this.info.getOccupantsCount();
        }

        public String getName() {
            return this.roomID.getLongName();
        }

        public boolean isPersistent() {
            return this.info.isPersistent();
        }

        public boolean requiresPassword() {
            return this.info.isPasswordProtected();
        }

        public boolean isModerated() {
            return this.info.isModerated();
        }

        public ID getConnectedID() {
            return this.roomID;
        }

        public Object getAdapter(Class adapter) {
            if (adapter == null) {
                return null;
            }
            if (adapter.isInstance(this)) {
                return this;
            }
            IAdapterManager adapterManager = XmppPlugin.getDefault().getAdapterManager();
            return adapterManager == null ? null : adapterManager.loadAdapter((Object)this, adapter.getName());
        }

        public IChatRoomContainer createChatRoomContainer() throws ContainerCreateException {
            XMPPChatRoomContainer chatContainer = null;
            if (XMPPChatRoomManager.this.ecfConnection == null) {
                throw new ContainerCreateException(Messages.XMPPChatRoomManager_EXCEPTION_CONTAINER_DISCONNECTED);
            }
            try {
                chatContainer = new XMPPChatRoomContainer(XMPPChatRoomManager.this.ecfConnection, XMPPChatRoomManager.this.connectNamespace);
                XMPPChatRoomManager.this.addChat(chatContainer);
                return chatContainer;
            }
            catch (IDCreateException e) {
                throw new ContainerCreateException(Messages.XMPPChatRoomManager_EXCEPTION_CREATING_CHAT_CONTAINER, (Throwable)e);
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("ECFRoomInfo[");
            buf.append("id=").append(XMPPChatRoomManager.this.containerID).append(";name=" + this.getName());
            buf.append(";service=" + this.getConnectedID());
            buf.append(";count=" + this.getParticipantsCount());
            buf.append(";subject=" + this.getSubject()).append(";desc=" + this.getDescription());
            buf.append(";pers=" + this.isPersistent()).append(";pw=" + this.requiresPassword());
            buf.append(";mod=" + this.isModerated()).append("]");
            return buf.toString();
        }
    }
}

