/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.xmpp.identity;

import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.ecf.core.identity.BaseID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.util.StringUtils;
import org.eclipse.ecf.internal.provider.xmpp.Messages;
import org.eclipse.ecf.presence.IFQID;
import org.eclipse.ecf.presence.im.IChatID;

public class XMPPID
extends BaseID
implements IChatID,
IFQID {
    private static final long serialVersionUID = 3257289140701049140L;
    public static final char USER_HOST_DELIMITER = '@';
    public static final char PORT_DELIMITER = ':';
    public static final String PATH_DELIMITER = "/";
    protected static Hashtable escapeTable = new Hashtable(10);
    protected String username;
    protected String hostname;
    protected String resourcename;
    protected int port = -1;

    static {
        escapeTable.put("@", new XMPPEscape(new char[]{'\\', '4', '0'}));
        escapeTable.put("\"", new XMPPEscape(new char[]{'\\', '2', '2'}));
        escapeTable.put("&", new XMPPEscape(new char[]{'\\', '2', '6'}));
        escapeTable.put("'", new XMPPEscape(new char[]{'\\', '2', '7'}));
        escapeTable.put(PATH_DELIMITER, new XMPPEscape(new char[]{'\\', '2', 'f'}));
        escapeTable.put(":", new XMPPEscape(new char[]{'\\', '3', 'a'}));
        escapeTable.put("<", new XMPPEscape(new char[]{'\\', '3', 'c'}));
        escapeTable.put(">", new XMPPEscape(new char[]{'\\', '3', 'e'}));
        escapeTable.put("\\", new XMPPEscape(new char[]{'\\', '5', 'c'}));
    }

    static String fixEscapeInNode(String node) {
        if (node == null) {
            return null;
        }
        Iterator i = escapeTable.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            XMPPEscape escape = (XMPPEscape)escapeTable.get(key);
            node = StringUtils.replaceAll((String)node, (String)key, (String)escape.getAsString());
        }
        return node;
    }

    static String fixPercentEscape(String src) {
        if (src == null) {
            return null;
        }
        return StringUtils.replaceAll((String)src, (String)"%", (String)"%25");
    }

    public static String unfixEscapeInNode(String node) {
        if (node == null) {
            return null;
        }
        Iterator i = escapeTable.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            XMPPEscape escape = (XMPPEscape)escapeTable.get(key);
            node = StringUtils.replaceAll((String)node, (String)escape.getAsString(), (String)key);
        }
        return node;
    }

    public XMPPID(Namespace namespace, String unamehost) throws URISyntaxException {
        super(namespace);
        unamehost = XMPPID.fixPercentEscape(unamehost);
        if (unamehost == null) {
            throw new URISyntaxException(unamehost, Messages.XMPPID_EXCEPTION_XMPPID_USERNAME_NOT_NULL);
        }
        int atIndex = unamehost.lastIndexOf(64);
        if (atIndex == -1) {
            throw new URISyntaxException(unamehost, Messages.XMPPID_EXCEPTION_HOST_PORT_NOT_VALID);
        }
        this.username = XMPPID.fixEscapeInNode(unamehost.substring(0, atIndex));
        String remainder = unamehost.substring(atIndex + 1);
        if ((atIndex = remainder.lastIndexOf(58)) != -1) {
            try {
                int slashLoc = remainder.indexOf(PATH_DELIMITER);
                this.port = slashLoc != -1 ? Integer.parseInt(remainder.substring(atIndex + 1, slashLoc)) : Integer.parseInt(remainder.substring(atIndex + 1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new URISyntaxException(unamehost, Messages.XMPPID_EXCEPTION_INVALID_PORT);
            }
            this.hostname = remainder.substring(0, atIndex);
        }
        if ((atIndex = remainder.indexOf(PATH_DELIMITER)) != -1) {
            if (this.hostname == null) {
                this.hostname = remainder.substring(0, atIndex);
            }
            this.setResourceName(remainder.substring(atIndex + 1));
        } else {
            this.setResourceName(null);
        }
        if (this.hostname == null) {
            this.hostname = remainder;
        }
    }

    protected int namespaceCompareTo(BaseID o) {
        return this.getName().compareTo(o.getName());
    }

    protected boolean namespaceEquals(BaseID o) {
        boolean resourceEquals;
        if (!(o instanceof XMPPID)) {
            return false;
        }
        XMPPID other = (XMPPID)o;
        String thisResourceName = this.getResourceName();
        String otherResourceName = other.getResourceName();
        boolean bl = resourceEquals = thisResourceName == null && otherResourceName == null || thisResourceName != null && otherResourceName != null && thisResourceName.equals(otherResourceName);
        return resourceEquals && this.getUsernameAtHost().equals(other.getUsernameAtHost());
    }

    protected String namespaceGetName() {
        return this.getUsernameAtHost();
    }

    protected int namespaceHashCode() {
        return this.getUsernameAtHost().hashCode();
    }

    public String getNodename() {
        return this.username;
    }

    protected String namespaceToExternalForm() {
        return String.valueOf(this.getNamespace().getScheme()) + "://" + this.getFQName();
    }

    public String getUsername() {
        return XMPPID.unfixEscapeInNode(this.username);
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getResourceName() {
        return this.resourcename;
    }

    public void setResourceName(String resourceName) {
        this.resourcename = resourceName;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsernameAtHost() {
        if (this.getUsername().indexOf(64) != -1) {
            return this.getUsername();
        }
        return String.valueOf(this.getUsername()) + '@' + this.getHostname() + (this.getPort() == -1 ? "" : ":" + this.getPort());
    }

    public String getFQName() {
        String rn = this.getResourceName();
        return String.valueOf(this.getUsernameAtHost()) + PATH_DELIMITER + (rn == null ? "" : rn);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("XMPPID[");
        sb.append(this.toExternalForm()).append("]");
        return sb.toString();
    }

    public Object getAdapter(Class clazz) {
        if (clazz.isInstance((Object)this)) {
            return this;
        }
        return super.getAdapter(clazz);
    }

    static class XMPPEscape {
        StringBuffer buf = new StringBuffer();

        public XMPPEscape(char[] chars) {
            if (chars != null) {
                int i = 0;
                while (i < chars.length) {
                    this.buf.append(chars[i]);
                    ++i;
                }
            }
        }

        public String getAsString() {
            return this.buf.toString();
        }
    }
}

