/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.filetransfer.FileTransfer;
import org.jivesoftware.smackx.filetransfer.FileTransferNegotiator;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;

public class OutgoingFileTransfer
extends FileTransfer {
    private static int RESPONSE_TIMEOUT = 60000;
    private OutputStream outputStream;
    private String initiator;
    private Thread transferThread;

    public static int getResponseTimeout() {
        return RESPONSE_TIMEOUT;
    }

    public static void setResponseTimeout(int responseTimeout) {
        RESPONSE_TIMEOUT = responseTimeout;
    }

    protected OutgoingFileTransfer(String initiator, String target, String streamID, FileTransferNegotiator transferNegotiator) {
        super(target, streamID, transferNegotiator);
        this.initiator = initiator;
    }

    protected void setOutputStream(OutputStream stream) {
        if (this.outputStream == null) {
            this.outputStream = stream;
        }
    }

    protected OutputStream getOutputStream() {
        if (this.getStatus().equals(FileTransfer.Status.NEGOTIATED)) {
            return this.outputStream;
        }
        return null;
    }

    public synchronized OutputStream sendFile(String fileName, long fileSize, String description) throws XMPPException {
        if (this.isDone() || this.outputStream != null) {
            throw new IllegalStateException("The negotation process has already been attempted on this file transfer");
        }
        try {
            this.outputStream = this.negotiateStream(fileName, fileSize, description);
        }
        catch (XMPPException e) {
            this.handleXMPPException(e);
            throw e;
        }
        return this.outputStream;
    }

    public synchronized void sendFile(final String fileName, final long fileSize, final String description, NegotiationProgress progress) {
        this.checkTransferThread();
        if (this.isDone() || this.outputStream != null) {
            throw new IllegalStateException("The negotation process has already been attempted for this file transfer");
        }
        progress.delegate = this;
        this.transferThread = new Thread(new Runnable(){

            public void run() {
                try {
                    OutgoingFileTransfer.this.outputStream = OutgoingFileTransfer.this.negotiateStream(fileName, fileSize, description);
                }
                catch (XMPPException e) {
                    OutgoingFileTransfer.this.handleXMPPException(e);
                }
            }
        }, "File Transfer Negotiation " + this.streamID);
        this.transferThread.start();
    }

    private void checkTransferThread() {
        if (this.transferThread != null && this.transferThread.isAlive() || this.isDone()) {
            throw new IllegalStateException("File transfer in progress or has already completed.");
        }
    }

    public synchronized void sendFile(final File file, final String description) throws XMPPException {
        this.checkTransferThread();
        if (file == null || !file.exists() || !file.canRead()) {
            throw new IllegalArgumentException("Could not read file");
        }
        this.setFileInfo(file.getAbsolutePath(), file.getName(), file.length());
        this.transferThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    OutgoingFileTransfer.this.outputStream = OutgoingFileTransfer.this.negotiateStream(file.getName(), file.length(), description);
                }
                catch (XMPPException e) {
                    OutgoingFileTransfer.this.handleXMPPException(e);
                    return;
                }
                if (OutgoingFileTransfer.this.outputStream == null) {
                    return;
                }
                if (!OutgoingFileTransfer.this.updateStatus(FileTransfer.Status.NEGOTIATED, FileTransfer.Status.IN_PROGRESS)) {
                    return;
                }
                FileInputStream inputStream = null;
                try {
                    try {
                        inputStream = new FileInputStream(file);
                        OutgoingFileTransfer.this.writeToStream(inputStream, OutgoingFileTransfer.this.outputStream);
                    }
                    catch (FileNotFoundException e) {
                        OutgoingFileTransfer.this.setStatus(FileTransfer.Status.ERROR);
                        OutgoingFileTransfer.this.setError(FileTransfer.Error.BAD_FILE);
                        OutgoingFileTransfer.this.setException(e);
                    }
                    catch (XMPPException e) {
                        OutgoingFileTransfer.this.setStatus(FileTransfer.Status.ERROR);
                        OutgoingFileTransfer.this.setException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_6 = null;
                    try {
                        if (inputStream != null) {
                            ((InputStream)inputStream).close();
                        }
                        OutgoingFileTransfer.this.outputStream.flush();
                        OutgoingFileTransfer.this.outputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                {
                    Object var3_7 = null;
                }
                try {}
                catch (IOException iOException) {}
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
                OutgoingFileTransfer.this.outputStream.flush();
                OutgoingFileTransfer.this.outputStream.close();
                OutgoingFileTransfer.this.updateStatus(FileTransfer.Status.IN_PROGRESS, FileTransfer.Status.COMPLETE);
            }
        }, "File Transfer " + this.streamID);
        this.transferThread.start();
    }

    private void handleXMPPException(XMPPException e) {
        this.setStatus(FileTransfer.Status.ERROR);
        XMPPError error = e.getXMPPError();
        if (error != null) {
            int code = error.getCode();
            if (code == 403) {
                this.setStatus(FileTransfer.Status.REFUSED);
                return;
            }
            if (code == 400) {
                this.setStatus(FileTransfer.Status.ERROR);
                this.setError(FileTransfer.Error.NOT_ACCEPTABLE);
            }
        }
        this.setException(e);
    }

    public long getBytesSent() {
        return this.amountWritten;
    }

    private OutputStream negotiateStream(String fileName, long fileSize, String description) throws XMPPException {
        if (!this.updateStatus(FileTransfer.Status.INITIAL, FileTransfer.Status.NEGOTIATING_TRANSFER)) {
            throw new XMPPException("Illegal state change");
        }
        StreamNegotiator streamNegotiator = this.negotiator.negotiateOutgoingTransfer(this.getPeer(), this.streamID, fileName, fileSize, description, RESPONSE_TIMEOUT);
        if (streamNegotiator == null) {
            this.setStatus(FileTransfer.Status.ERROR);
            this.setError(FileTransfer.Error.NO_RESPONSE);
            return null;
        }
        if (!this.updateStatus(FileTransfer.Status.NEGOTIATING_TRANSFER, FileTransfer.Status.NEGOTIATING_STREAM)) {
            throw new XMPPException("Illegal state change");
        }
        this.outputStream = streamNegotiator.createOutgoingStream(this.streamID, this.initiator, this.getPeer());
        if (!this.updateStatus(FileTransfer.Status.NEGOTIATING_STREAM, FileTransfer.Status.NEGOTIATED)) {
            throw new XMPPException("Illegal state change");
        }
        return this.outputStream;
    }

    public void cancel() {
        this.setStatus(FileTransfer.Status.CANCLED);
    }

    public static class NegotiationProgress {
        private OutgoingFileTransfer delegate;

        public FileTransfer.Status getStatus() {
            if (this.delegate == null) {
                throw new IllegalStateException("delegate not yet set");
            }
            return this.delegate.getStatus();
        }

        public OutputStream getOutputStream() {
            if (this.delegate == null) {
                throw new IllegalStateException("delegate not yet set");
            }
            return this.delegate.getOutputStream();
        }
    }
}

